/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.tile;

import elucent.eidolon.api.ritual.IncenseRitual;
import elucent.eidolon.common.tile.IBurner;
import elucent.eidolon.common.tile.TileEntityBase;
import elucent.eidolon.registries.IncenseRegistry;
import elucent.eidolon.registries.Registry;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;

public class CenserTileEntity
extends TileEntityBase
implements IBurner {
    ItemStack incense = ItemStack.f_41583_;
    boolean isBurning;
    int burnCounter;
    IncenseRitual incenseRitual;

    public CenserTileEntity(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public CenserTileEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)Registry.CENSER_TILE_ENTITY.get(), pos, state);
    }

    @Override
    public boolean canStartBurning() {
        return !this.isBurning && !this.incense.m_41619_();
    }

    @Override
    public void onDestroyed(BlockState state, BlockPos pos) {
        super.onDestroyed(state, pos);
        if (!this.isBurning && !this.incense.m_41619_() && this.f_58857_ != null) {
            this.f_58857_.m_7967_((Entity)new ItemEntity(this.f_58857_, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), this.incense));
        }
    }

    public void tick() {
        if (this.f_58857_ == null) {
            return;
        }
        if (!this.f_58857_.f_46443_ && this.isBurning && this.incense() != null) {
            ++this.burnCounter;
            this.incense().tick(this.burnCounter);
            this.sync();
        }
        if (this.burnCounter == 80) {
            this.incense = ItemStack.f_41583_;
            this.sync();
        }
        if (this.f_58857_.f_46443_ && this.isBurning && this.incense() != null) {
            this.incenseRitual.animateParticles(this, this.burnCounter);
        }
    }

    @Override
    public InteractionResult onActivated(BlockState state, BlockPos pos, Player player, InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND && this.f_58857_ instanceof ServerLevel && !this.isBurning) {
            ItemStack itemInHand = player.m_21120_(hand);
            if (itemInHand.m_41619_() && !this.incense.m_41619_()) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)this.incense);
                this.incense = ItemStack.f_41583_;
                if (!this.f_58857_.f_46443_) {
                    this.sync();
                }
                return InteractionResult.SUCCESS;
            }
            if (!itemInHand.m_41619_() && this.incense.m_41619_()) {
                if (IncenseRegistry.getIncenseRitual(itemInHand.m_41720_()) != null) {
                    this.incense = itemInHand.m_41620_(1);
                    if (!this.f_58857_.f_46443_) {
                        this.sync();
                    }
                    return InteractionResult.SUCCESS;
                }
            } else if (!itemInHand.m_41619_() && !this.incense.m_41619_()) {
                if (itemInHand.m_41720_() instanceof FlintAndSteelItem && !this.f_58857_.f_46443_ && this.canStartBurning()) {
                    this.startBurning(player, this.f_58857_, pos);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    @Override
    public void startBurning(Player player, @NotNull Level world, BlockPos pos) {
        if (this.incense() != null && this.incense().start(player, this)) {
            this.isBurning = true;
            world.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(this.isBurning)));
            this.burnCounter = 0;
            this.sync();
        }
    }

    public void m_142466_(@NotNull CompoundTag pTag) {
        super.m_142466_(pTag);
        this.incense = pTag.m_128441_("incense") ? ItemStack.m_41712_((CompoundTag)pTag.m_128469_("incense")) : ItemStack.f_41583_;
        if (pTag.m_128441_("incenseContext") && this.incense.m_41619_()) {
            this.incenseRitual = IncenseRitual.read(pTag);
            this.incenseRitual.start(null, this);
        }
        this.burnCounter = pTag.m_128451_("burnCounter");
        this.isBurning = pTag.m_128471_("isBurning");
    }

    protected void m_183515_(@NotNull CompoundTag pTag) {
        super.m_183515_(pTag);
        if (!this.incense.m_41619_()) {
            pTag.m_128365_("incense", (Tag)this.incense.m_41739_(new CompoundTag()));
        }
        if (this.incenseRitual != null) {
            this.incenseRitual.write(pTag);
        }
        pTag.m_128405_("burnCounter", this.burnCounter);
        pTag.m_128379_("isBurning", this.isBurning);
    }

    @Override
    public void extinguish() {
        if (this.f_58857_ instanceof ServerLevel) {
            this.isBurning = false;
            this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(this.isBurning)));
            this.burnCounter = 0;
            this.incenseRitual = null;
            this.sync();
        }
    }

    public IncenseRitual incense() {
        if (this.incenseRitual == null && !this.incense.m_41619_()) {
            this.incenseRitual = IncenseRegistry.getIncenseRitual(this.incense.m_41720_());
        }
        return this.incenseRitual;
    }
}

