/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.entity;

import elucent.eidolon.api.spells.Rune;
import elucent.eidolon.api.spells.Sign;
import elucent.eidolon.api.spells.SignSequence;
import elucent.eidolon.api.spells.Spell;
import elucent.eidolon.client.particle.RuneParticleData;
import elucent.eidolon.network.Networking;
import elucent.eidolon.network.SpellCastPacket;
import elucent.eidolon.registries.EidolonAttributes;
import elucent.eidolon.registries.EidolonEntities;
import elucent.eidolon.registries.EidolonSounds;
import elucent.eidolon.registries.Runes;
import elucent.eidolon.registries.Signs;
import elucent.eidolon.registries.Spells;
import elucent.eidolon.util.KnowledgeUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class ChantCasterEntity
extends Entity
implements IEntityAdditionalSpawnData {
    public static final EntityDataAccessor<CompoundTag> RUNES = SynchedEntityData.m_135353_(ChantCasterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
    public static final EntityDataAccessor<CompoundTag> SIGNS = SynchedEntityData.m_135353_(ChantCasterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
    public static final EntityDataAccessor<Integer> INDEX = SynchedEntityData.m_135353_(ChantCasterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Optional<UUID>> CASTER_ID = SynchedEntityData.m_135353_(ChantCasterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    public static final EntityDataAccessor<Boolean> SUCCEEDED = SynchedEntityData.m_135353_(ChantCasterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public int timer = 0;
    public int deathTimer = 0;
    public Vec3 look;
    @Nullable
    Player caster;

    public ChantCasterEntity(Level world, Player caster, List<Sign> runes, Vec3 look) {
        super((EntityType)EidolonEntities.CHANT_CASTER.get(), world);
        this.look = look;
        this.caster = caster;
        this.setChantTag(runes);
        this.m_20088_().m_135381_(CASTER_ID, Optional.of(caster.m_20148_()));
    }

    public ChantCasterEntity(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    public static void createChanter(Player player, Level world, List<Sign> runes) {
        for (Sign rune : runes) {
            if (KnowledgeUtil.knowsSign(player, rune)) continue;
            return;
        }
        Vec3 placement = player.m_20182_().m_82520_(0.0, (double)(player.m_20206_() * 2.0f / 3.0f), 0.0).m_82549_(player.m_20154_().m_82490_(0.5));
        ChantCasterEntity entity = new ChantCasterEntity(world, player, runes, player.m_20154_());
        entity.m_6034_(placement.f_82479_, placement.f_82480_, placement.f_82481_);
        world.m_7967_((Entity)entity);
    }

    protected CompoundTag getNoRunesTag() {
        CompoundTag emptyRunes = new CompoundTag();
        emptyRunes.m_128365_("runes", (Tag)new ListTag());
        return emptyRunes;
    }

    protected List<Rune> loadRunesTag() {
        ArrayList<Rune> runes = new ArrayList<Rune>();
        ListTag runesTag = ((CompoundTag)this.m_20088_().m_135370_(RUNES)).m_128437_("runes", 8);
        for (int i = 0; i < runesTag.size(); ++i) {
            Rune r = Runes.find(new ResourceLocation(runesTag.m_128778_(i)));
            if (r == null) continue;
            runes.add(r);
        }
        return runes;
    }

    protected void setRunesTag(List<Rune> runes) {
        ListTag runesList = new ListTag();
        CompoundTag runesTag = new CompoundTag();
        for (Rune r : runes) {
            runesList.add((Object)StringTag.m_129297_((String)r.getRegistryName().toString()));
        }
        runesTag.m_128365_("runes", (Tag)runesList);
        this.m_20088_().m_135381_(RUNES, (Object)runesTag);
    }

    protected List<Sign> loadChantTag() {
        ArrayList<Sign> runes = new ArrayList<Sign>();
        ListTag runesTag = ((CompoundTag)this.m_20088_().m_135370_(RUNES)).m_128437_("runes", 8);
        for (int i = 0; i < runesTag.size(); ++i) {
            Sign r = Signs.find(new ResourceLocation(runesTag.m_128778_(i)));
            if (r == null) continue;
            runes.add(r);
        }
        return runes;
    }

    protected void setChantTag(List<Sign> signs) {
        ListTag signList = new ListTag();
        CompoundTag signTag = new CompoundTag();
        for (Sign r : signs) {
            signList.add((Object)StringTag.m_129297_((String)r.getRegistryName().toString()));
        }
        signTag.m_128365_("runes", (Tag)signList);
        this.m_20088_().m_135381_(RUNES, (Object)signTag);
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(RUNES, (Object)this.getNoRunesTag());
        this.m_20088_().m_135372_(SIGNS, (Object)new SignSequence().serializeNbt());
        this.m_20088_().m_135372_(INDEX, (Object)0);
        this.m_20088_().m_135372_(CASTER_ID, Optional.empty());
        this.m_20088_().m_135372_(SUCCEEDED, (Object)false);
    }

    public void m_8119_() {
        double castSpeed;
        super.m_8119_();
        if (this.deathTimer > 0) {
            --this.deathTimer;
            if (this.deathTimer <= 0) {
                this.m_142687_(Entity.RemovalReason.KILLED);
            }
            return;
        }
        if (this.timer > 0) {
            --this.timer;
            if (this.timer <= 0) {
                CompoundTag signData = (CompoundTag)this.m_20088_().m_135370_(SIGNS);
                Optional optuuid = (Optional)this.m_20088_().m_135370_(CASTER_ID);
                if (!this.f_19853_.f_46443_ && optuuid.isPresent()) {
                    SignSequence seq = SignSequence.deserializeNbt(signData);
                    Spell spell = Spells.find(seq, this.f_19853_);
                    Player player = this.f_19853_.m_46003_((UUID)optuuid.get());
                    if (spell != null && player != null && spell.canCast(this.f_19853_, this.m_20183_(), player, seq)) {
                        spell.cast(this.f_19853_, this.m_20183_(), player, seq);
                        Networking.sendToTracking(this.f_19853_, this.m_20183_(), new SpellCastPacket(player, this.m_20183_(), spell, seq));
                        this.m_20088_().m_135381_(SUCCEEDED, (Object)true);
                    } else {
                        this.f_19853_.m_5594_(null, this.m_20183_(), SoundEvents.f_11937_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                        this.m_20088_().m_135381_(SUCCEEDED, (Object)false);
                    }
                }
                this.deathTimer = 20;
                return;
            }
        }
        this.cacheCaster();
        if (this.caster == null) {
            castSpeed = 1.0;
        } else {
            AttributeInstance attribute = this.caster.m_21051_((Attribute)EidolonAttributes.CHANTING_SPEED.get());
            double d = castSpeed = attribute != null ? attribute.m_22135_() : 1.0;
        }
        if (this.timer <= 0 && this.f_19797_ % Mth.m_14107_((double)(5.0 / castSpeed)) == 0) {
            List<Sign> runes = this.loadChantTag();
            SignSequence seq = SignSequence.deserializeNbt((CompoundTag)this.m_20088_().m_135370_(SIGNS));
            Vector3f initColor = seq.getAverageColor();
            int index = (Integer)this.m_20088_().m_135370_(INDEX);
            if (index >= runes.size()) {
                return;
            }
            Sign sign = runes.get(index);
            seq.addRight(sign);
            Vector3f afterColor = seq.getAverageColor();
            double x = this.m_20185_() + 0.1 * this.f_19796_.m_188583_();
            double y = this.m_20186_() + 0.1 * this.f_19796_.m_188583_();
            double z = this.m_20189_() + 0.1 * this.f_19796_.m_188583_();
            for (int i = 0; i < 2; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)new RuneParticleData(Runes.find(ResourceLocation.m_135820_((String)"eidolon:sin")), initColor.x(), initColor.y(), initColor.z(), afterColor.x(), afterColor.y(), afterColor.z()), x, y, z, this.look.f_82479_ * 0.03, this.look.f_82480_ * 0.03, this.look.f_82481_ * 0.03);
            }
            this.f_19853_.m_5594_(null, this.m_20183_(), (SoundEvent)EidolonSounds.CHANT_WORD.get(), SoundSource.NEUTRAL, 0.7f, this.f_19796_.m_188501_() * 0.375f + 0.625f);
            if (index + 1 >= runes.size()) {
                Spell match = Spells.find(seq, this.f_19853_);
                int n = this.timer = match != null ? match.getDelay() : 10;
            }
            if (!this.f_19853_.f_46443_) {
                this.m_20088_().m_135381_(INDEX, (Object)(index + 1));
                this.m_20088_().m_135381_(SIGNS, (Object)seq.serializeNbt());
            }
        }
        if (this.caster != null) {
            double rad = Math.toRadians(this.caster.f_20885_);
            this.m_146884_(this.caster.m_146892_().m_82520_(-Math.sin(rad) / 2.0, -0.75, Math.cos(rad) / 2.0));
            this.look = this.caster.m_20154_();
        }
    }

    private void cacheCaster() {
        Player e;
        Optional optuuid;
        if (this.caster == null && (optuuid = (Optional)this.m_20088_().m_135370_(CASTER_ID)).isPresent() && (e = this.f_19853_.m_46003_((UUID)optuuid.get())) != null) {
            this.caster = e;
        }
    }

    protected void m_7378_(CompoundTag compound) {
        this.m_20088_().m_135381_(RUNES, (Object)compound.m_128469_("runes_tag"));
        this.m_20088_().m_135381_(SIGNS, (Object)compound.m_128469_("signs_tag"));
        this.m_20088_().m_135381_(INDEX, (Object)compound.m_128451_("index"));
        this.m_20088_().m_135381_(CASTER_ID, Optional.of(compound.m_128342_("caster_id")));
        this.look = new Vec3(compound.m_128459_("lookX"), compound.m_128459_("lookY"), compound.m_128459_("lookZ"));
        this.timer = compound.m_128451_("timer");
        this.deathTimer = compound.m_128451_("deathTimer");
        this.m_20088_().m_135381_(SUCCEEDED, (Object)compound.m_128471_("succeeded"));
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128365_("runes_tag", (Tag)this.m_20088_().m_135370_(RUNES));
        compound.m_128365_("signs_tag", (Tag)this.m_20088_().m_135370_(SIGNS));
        compound.m_128405_("index", ((Integer)this.m_20088_().m_135370_(INDEX)).intValue());
        compound.m_128405_("timer", this.timer);
        if (((Optional)this.m_20088_().m_135370_(CASTER_ID)).isPresent()) {
            compound.m_128362_("caster_id", (UUID)((Optional)this.m_20088_().m_135370_(CASTER_ID)).get());
        }
        compound.m_128347_("lookX", this.look.f_82479_);
        compound.m_128347_("lookY", this.look.f_82480_);
        compound.m_128347_("lookZ", this.look.f_82481_);
        compound.m_128405_("deathTimer", this.deathTimer);
        compound.m_128379_("succeeded", ((Boolean)this.m_20088_().m_135370_(SUCCEEDED)).booleanValue());
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.writeDouble(this.look.f_82479_);
        buffer.writeDouble(this.look.f_82480_);
        buffer.writeDouble(this.look.f_82481_);
    }

    public void readSpawnData(FriendlyByteBuf buf) {
        this.look = new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
    }
}

