/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import nl.requios.effortlessbuilding.EffortlessBuildingClient;
import nl.requios.effortlessbuilding.buildmodifier.BaseModifier;
import nl.requios.effortlessbuilding.buildmodifier.Mirror;
import nl.requios.effortlessbuilding.buildmodifier.RadialMirror;
import nl.requios.effortlessbuilding.render.RenderHandler;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class ModifierRenderer {
    protected static final Color colorX = new Color(255, 72, 52);
    protected static final Color colorY = new Color(67, 204, 51);
    protected static final Color colorZ = new Color(52, 247, 255);
    protected static final Color colorRadial = new Color(52, 247, 255);
    protected static final int lineAlpha = 200;
    protected static final int planeAlpha = 50;
    protected static final Vec3 epsilon = new Vec3(0.001, 0.001, 0.001);

    public static void render(PoseStack ms, MultiBufferSource.BufferSource buffer) {
        List<BaseModifier> modifierSettingsList = EffortlessBuildingClient.BUILD_MODIFIERS.getModifierSettingsList();
        for (BaseModifier modifierSettings : modifierSettingsList) {
            if (modifierSettings == null) continue;
            if (modifierSettings instanceof Mirror) {
                ModifierRenderer.renderMirror(ms, buffer, (Mirror)modifierSettings);
                continue;
            }
            if (!(modifierSettings instanceof RadialMirror)) continue;
            ModifierRenderer.renderRadialMirror(ms, buffer, (RadialMirror)modifierSettings);
        }
    }

    private static void renderMirror(PoseStack ms, MultiBufferSource.BufferSource buffer, Mirror m) {
        if (m != null && m.enabled && (m.mirrorX || m.mirrorY || m.mirrorZ)) {
            Vec3 posB;
            Vec3 posA;
            Vec3 pos = m.position.m_82549_(epsilon);
            int radius = m.radius;
            if (m.mirrorX) {
                posA = new Vec3(pos.f_82479_, pos.f_82480_ - (double)radius, pos.f_82481_ - (double)radius);
                posB = new Vec3(pos.f_82479_, pos.f_82480_ + (double)radius, pos.f_82481_ + (double)radius);
                ModifierRenderer.drawMirrorPlane(ms, buffer, posA, posB, colorX, m.drawLines, m.drawPlanes, true);
            }
            if (m.mirrorY) {
                posA = new Vec3(pos.f_82479_ - (double)radius, pos.f_82480_, pos.f_82481_ - (double)radius);
                posB = new Vec3(pos.f_82479_ + (double)radius, pos.f_82480_, pos.f_82481_ + (double)radius);
                ModifierRenderer.drawMirrorPlaneY(ms, buffer, posA, posB, colorY, m.drawLines, m.drawPlanes);
            }
            if (m.mirrorZ) {
                posA = new Vec3(pos.f_82479_ - (double)radius, pos.f_82480_ - (double)radius, pos.f_82481_);
                posB = new Vec3(pos.f_82479_ + (double)radius, pos.f_82480_ + (double)radius, pos.f_82481_);
                ModifierRenderer.drawMirrorPlane(ms, buffer, posA, posB, colorZ, m.drawLines, m.drawPlanes, true);
            }
            if (m.drawLines && (m.mirrorX && m.mirrorY || m.mirrorX && m.mirrorZ || m.mirrorY && m.mirrorZ)) {
                ModifierRenderer.drawMirrorLines(ms, buffer, m);
            }
        }
    }

    private static void renderRadialMirror(PoseStack ms, MultiBufferSource.BufferSource buffer, RadialMirror r) {
        if (r != null && r.enabled) {
            Vec3 pos = r.position.m_82549_(epsilon);
            int radius = r.radius;
            float angle = (float)Math.PI * 2 / (float)r.slices;
            Vec3 relStartVec = new Vec3((double)radius, 0.0, 0.0);
            if (r.slices % 4 == 2) {
                relStartVec = relStartVec.m_82524_(angle / 2.0f);
            }
            for (int i = 0; i < r.slices; ++i) {
                Vec3 relNewVec = relStartVec.m_82524_(angle * (float)i);
                Vec3 newVec = pos.m_82549_(relNewVec);
                Vec3 posA = new Vec3(pos.f_82479_, pos.f_82480_ - (double)radius, pos.f_82481_);
                Vec3 posB = new Vec3(newVec.f_82479_, pos.f_82480_ + (double)radius, newVec.f_82481_);
                ModifierRenderer.drawMirrorPlane(ms, buffer, posA, posB, colorRadial, r.drawLines, r.drawPlanes, false);
            }
        }
    }

    protected static void drawMirrorPlane(PoseStack ms, MultiBufferSource.BufferSource renderTypeBuffer, Vec3 posA, Vec3 posB, Color c, boolean drawLines, boolean drawPlanes, boolean drawVerticalLines) {
        VertexConsumer buffer;
        Matrix4f matrixPos = ms.m_85850_().m_252922_();
        if (drawPlanes) {
            buffer = RenderHandler.beginPlanes(renderTypeBuffer);
            buffer.m_252986_(matrixPos, (float)posA.f_82479_, (float)posA.f_82480_, (float)posA.f_82481_).m_6122_(c.getRed(), c.getGreen(), c.getBlue(), 50).m_5752_();
            buffer.m_252986_(matrixPos, (float)posA.f_82479_, (float)posB.f_82480_, (float)posA.f_82481_).m_6122_(c.getRed(), c.getGreen(), c.getBlue(), 50).m_5752_();
            buffer.m_252986_(matrixPos, (float)posB.f_82479_, (float)posA.f_82480_, (float)posB.f_82481_).m_6122_(c.getRed(), c.getGreen(), c.getBlue(), 50).m_5752_();
            buffer.m_252986_(matrixPos, (float)posB.f_82479_, (float)posB.f_82480_, (float)posB.f_82481_).m_6122_(c.getRed(), c.getGreen(), c.getBlue(), 50).m_5752_();
            buffer.m_252986_(matrixPos, (float)posA.f_82479_, (float)posA.f_82480_, (float)posA.f_82481_).m_6122_(c.getRed(), c.getGreen(), c.getBlue(), 50).m_5752_();
            buffer.m_252986_(matrixPos, (float)posA.f_82479_, (float)posB.f_82480_, (float)posA.f_82481_).m_6122_(c.getRed(), c.getGreen(), c.getBlue(), 50).m_5752_();
            RenderHandler.endPlanes(renderTypeBuffer);
        }
        if (drawLines) {
            buffer = RenderHandler.beginLines(renderTypeBuffer);
            Vec3 middle = posA.m_82549_(posB).m_82490_(0.5);
            buffer.m_252986_(matrixPos, (float)posA.f_82479_, (float)middle.f_82480_, (float)posA.f_82481_).m_6122_(c.getRed(), c.getGreen(), c.getBlue(), 200).m_5752_();
            buffer.m_252986_(matrixPos, (float)posB.f_82479_, (float)middle.f_82480_, (float)posB.f_82481_).m_6122_(c.getRed(), c.getGreen(), c.getBlue(), 200).m_5752_();
            if (drawVerticalLines) {
                buffer.m_252986_(matrixPos, (float)middle.f_82479_, (float)posA.f_82480_, (float)middle.f_82481_).m_6122_(c.getRed(), c.getGreen(), c.getBlue(), 200).m_5752_();
                buffer.m_252986_(matrixPos, (float)middle.f_82479_, (float)posB.f_82480_, (float)middle.f_82481_).m_6122_(c.getRed(), c.getGreen(), c.getBlue(), 200).m_5752_();
            }
            RenderHandler.endLines(renderTypeBuffer);
        }
    }

    protected static void drawMirrorPlaneY(PoseStack matrixStack, MultiBufferSource.BufferSource renderTypeBuffer, Vec3 posA, Vec3 posB, Color c, boolean drawLines, boolean drawPlanes) {
        VertexConsumer buffer;
        Matrix4f matrixPos = matrixStack.m_85850_().m_252922_();
        if (drawPlanes) {
            buffer = RenderHandler.beginPlanes(renderTypeBuffer);
            buffer.m_252986_(matrixPos, (float)posA.f_82479_, (float)posA.f_82480_, (float)posA.f_82481_).m_6122_(c.getRed(), c.getGreen(), c.getBlue(), 50).m_5752_();
            buffer.m_252986_(matrixPos, (float)posA.f_82479_, (float)posA.f_82480_, (float)posB.f_82481_).m_6122_(c.getRed(), c.getGreen(), c.getBlue(), 50).m_5752_();
            buffer.m_252986_(matrixPos, (float)posB.f_82479_, (float)posA.f_82480_, (float)posA.f_82481_).m_6122_(c.getRed(), c.getGreen(), c.getBlue(), 50).m_5752_();
            buffer.m_252986_(matrixPos, (float)posB.f_82479_, (float)posA.f_82480_, (float)posB.f_82481_).m_6122_(c.getRed(), c.getGreen(), c.getBlue(), 50).m_5752_();
            buffer.m_252986_(matrixPos, (float)posA.f_82479_, (float)posA.f_82480_, (float)posA.f_82481_).m_6122_(c.getRed(), c.getGreen(), c.getBlue(), 50).m_5752_();
            buffer.m_252986_(matrixPos, (float)posA.f_82479_, (float)posA.f_82480_, (float)posB.f_82481_).m_6122_(c.getRed(), c.getGreen(), c.getBlue(), 50).m_5752_();
            RenderHandler.endPlanes(renderTypeBuffer);
        }
        if (drawLines) {
            buffer = RenderHandler.beginLines(renderTypeBuffer);
            Vec3 middle = posA.m_82549_(posB).m_82490_(0.5);
            buffer.m_252986_(matrixPos, (float)middle.f_82479_, (float)middle.f_82480_, (float)posA.f_82481_).m_6122_(c.getRed(), c.getGreen(), c.getBlue(), 200).m_5752_();
            buffer.m_252986_(matrixPos, (float)middle.f_82479_, (float)middle.f_82480_, (float)posB.f_82481_).m_6122_(c.getRed(), c.getGreen(), c.getBlue(), 200).m_5752_();
            buffer.m_252986_(matrixPos, (float)posA.f_82479_, (float)middle.f_82480_, (float)middle.f_82481_).m_6122_(c.getRed(), c.getGreen(), c.getBlue(), 200).m_5752_();
            buffer.m_252986_(matrixPos, (float)posB.f_82479_, (float)middle.f_82480_, (float)middle.f_82481_).m_6122_(c.getRed(), c.getGreen(), c.getBlue(), 200).m_5752_();
            RenderHandler.endLines(renderTypeBuffer);
        }
    }

    protected static void drawMirrorLines(PoseStack matrixStack, MultiBufferSource.BufferSource renderTypeBuffer, Mirror m) {
        VertexConsumer buffer = RenderHandler.beginLines(renderTypeBuffer);
        Matrix4f matrixPos = matrixStack.m_85850_().m_252922_();
        Vec3 pos = m.position.m_82549_(epsilon);
        buffer.m_252986_(matrixPos, (float)pos.f_82479_ - (float)m.radius, (float)pos.f_82480_, (float)pos.f_82481_).m_6122_(colorX.getRed(), colorX.getGreen(), colorX.getBlue(), 200).m_5752_();
        buffer.m_252986_(matrixPos, (float)pos.f_82479_ + (float)m.radius, (float)pos.f_82480_, (float)pos.f_82481_).m_6122_(colorX.getRed(), colorX.getGreen(), colorX.getBlue(), 200).m_5752_();
        buffer.m_252986_(matrixPos, (float)pos.f_82479_, (float)pos.f_82480_ - (float)m.radius, (float)pos.f_82481_).m_6122_(colorY.getRed(), colorY.getGreen(), colorY.getBlue(), 200).m_5752_();
        buffer.m_252986_(matrixPos, (float)pos.f_82479_, (float)pos.f_82480_ + (float)m.radius, (float)pos.f_82481_).m_6122_(colorY.getRed(), colorY.getGreen(), colorY.getBlue(), 200).m_5752_();
        buffer.m_252986_(matrixPos, (float)pos.f_82479_, (float)pos.f_82480_, (float)pos.f_82481_ - (float)m.radius).m_6122_(colorZ.getRed(), colorZ.getGreen(), colorZ.getBlue(), 200).m_5752_();
        buffer.m_252986_(matrixPos, (float)pos.f_82479_, (float)pos.f_82480_, (float)pos.f_82481_ + (float)m.radius).m_6122_(colorZ.getRed(), colorZ.getGreen(), colorZ.getBlue(), 200).m_5752_();
        RenderHandler.endLines(renderTypeBuffer);
    }
}

