/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.create.foundation.utility;

import java.util.HashMap;
import java.util.Map;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;

public final class NBTProcessors {
    private static final Map<BlockEntityType<?>, UnaryOperator<CompoundTag>> processors = new HashMap();
    private static final Map<BlockEntityType<?>, UnaryOperator<CompoundTag>> survivalProcessors = new HashMap();

    public static synchronized void addProcessor(BlockEntityType<?> type, UnaryOperator<CompoundTag> processor) {
        processors.put(type, processor);
    }

    public static synchronized void addSurvivalProcessor(BlockEntityType<?> type, UnaryOperator<CompoundTag> processor) {
        survivalProcessors.put(type, processor);
    }

    public static boolean textComponentHasClickEvent(String json) {
        MutableComponent component = Component.Serializer.m_130701_((String)(json.isEmpty() ? "\"\"" : json));
        return component != null && component.m_7383_() != null && component.m_7383_().m_131182_() != null;
    }

    private NBTProcessors() {
    }

    @Nullable
    public static CompoundTag process(BlockEntity tileEntity, CompoundTag compound, boolean survival) {
        if (compound == null) {
            return null;
        }
        BlockEntityType type = tileEntity.m_58903_();
        if (survival && survivalProcessors.containsKey(type)) {
            compound = (CompoundTag)survivalProcessors.get(type).apply(compound);
        }
        if (compound != null && processors.containsKey(type)) {
            return (CompoundTag)processors.get(type).apply(compound);
        }
        if (tileEntity instanceof SpawnerBlockEntity) {
            return compound;
        }
        if (tileEntity.m_6326_()) {
            return null;
        }
        return compound;
    }

    static {
        NBTProcessors.addProcessor(BlockEntityType.f_58924_, data -> {
            for (int i = 0; i < 4; ++i) {
                if (!NBTProcessors.textComponentHasClickEvent(data.m_128461_("Text" + (i + 1)))) continue;
                return null;
            }
            return data;
        });
        NBTProcessors.addProcessor(BlockEntityType.f_58908_, data -> {
            if (!data.m_128425_("Book", 10)) {
                return data;
            }
            CompoundTag book = data.m_128469_("Book");
            if (!book.m_128425_("tag", 10)) {
                return data;
            }
            CompoundTag tag = book.m_128469_("tag");
            if (!tag.m_128425_("pages", 9)) {
                return data;
            }
            ListTag pages = tag.m_128437_("pages", 8);
            for (Tag inbt : pages) {
                if (!NBTProcessors.textComponentHasClickEvent(inbt.m_7916_())) continue;
                return null;
            }
            return data;
        });
    }
}

