/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.buildmode;

import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import nl.requios.effortlessbuilding.EffortlessBuilding;
import nl.requios.effortlessbuilding.buildmode.BuildModeEnum;
import nl.requios.effortlessbuilding.network.IsUsingBuildModePacket;
import nl.requios.effortlessbuilding.network.PacketHandler;
import nl.requios.effortlessbuilding.utilities.BlockSet;

@OnlyIn(value=Dist.CLIENT)
public class BuildModes {
    private BuildModeEnum buildMode = BuildModeEnum.DISABLED;
    private BuildModeEnum previousBuildMode = BuildModeEnum.DISABLED;
    private BuildModeEnum beforeDisabledBuildMode = BuildModeEnum.SINGLE;

    public void findCoordinates(BlockSet blocks, Player player) {
        this.buildMode.instance.findCoordinates(blocks);
    }

    public BuildModeEnum getBuildMode() {
        return this.buildMode;
    }

    public void setBuildMode(BuildModeEnum buildMode) {
        this.buildMode = buildMode;
        PacketHandler.INSTANCE.sendToServer((Object)new IsUsingBuildModePacket(this.buildMode != BuildModeEnum.DISABLED));
        EffortlessBuilding.log((Player)Minecraft.m_91087_().f_91074_, I18n.m_118938_((String)buildMode.getNameKey(), (Object[])new Object[0]), true);
    }

    public void activatePreviousBuildMode() {
        BuildModeEnum temp = this.buildMode;
        this.setBuildMode(this.previousBuildMode);
        this.previousBuildMode = temp;
    }

    public void activateDisableBuildModeToggle() {
        if (this.buildMode == BuildModeEnum.DISABLED) {
            this.setBuildMode(this.beforeDisabledBuildMode);
        } else {
            this.beforeDisabledBuildMode = this.buildMode;
            this.setBuildMode(BuildModeEnum.DISABLED);
        }
    }

    public void onCancel() {
        this.getBuildMode().instance.initialize();
    }

    public static Vec3 findXBound(double x, Vec3 start, Vec3 look) {
        double y = (x - start.f_82479_) / look.f_82479_ * look.f_82480_ + start.f_82480_;
        double z = (x - start.f_82479_) / look.f_82479_ * look.f_82481_ + start.f_82481_;
        return new Vec3(x, y, z);
    }

    public static Vec3 findYBound(double y, Vec3 start, Vec3 look) {
        double x = (y - start.f_82480_) / look.f_82480_ * look.f_82479_ + start.f_82479_;
        double z = (y - start.f_82480_) / look.f_82480_ * look.f_82481_ + start.f_82481_;
        return new Vec3(x, y, z);
    }

    public static Vec3 findZBound(double z, Vec3 start, Vec3 look) {
        double x = (z - start.f_82481_) / look.f_82481_ * look.f_82479_ + start.f_82479_;
        double y = (z - start.f_82481_) / look.f_82481_ * look.f_82480_ + start.f_82480_;
        return new Vec3(x, y, z);
    }

    public static Vec3 getPlayerLookVec(Player player) {
        Vec3 lookVec = player.m_20154_();
        double x = lookVec.f_82479_;
        double y = lookVec.f_82480_;
        double z = lookVec.f_82481_;
        if (Math.abs(x) < 1.0E-4) {
            x = 1.0E-4;
        }
        if (Math.abs(x - 1.0) < 1.0E-4) {
            x = 0.9999;
        }
        if (Math.abs(x + 1.0) < 1.0E-4) {
            x = -0.9999;
        }
        if (Math.abs(y) < 1.0E-4) {
            y = 1.0E-4;
        }
        if (Math.abs(y - 1.0) < 1.0E-4) {
            y = 0.9999;
        }
        if (Math.abs(y + 1.0) < 1.0E-4) {
            y = -0.9999;
        }
        if (Math.abs(z) < 1.0E-4) {
            z = 1.0E-4;
        }
        if (Math.abs(z - 1.0) < 1.0E-4) {
            z = 0.9999;
        }
        if (Math.abs(z + 1.0) < 1.0E-4) {
            z = -0.9999;
        }
        return new Vec3(x, y, z);
    }

    public static boolean isCriteriaValid(Vec3 start, Vec3 look, int reach, Player player, boolean skipRaytrace, Vec3 lineBound, Vec3 planeBound, double distToPlayerSq) {
        boolean intersects = false;
        if (!skipRaytrace) {
            ClipContext rayTraceContext = new ClipContext(start, lineBound, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player);
            BlockHitResult rayTraceResult = player.m_9236_().m_45547_(rayTraceContext);
            intersects = rayTraceResult != null && rayTraceResult.m_6662_() == HitResult.Type.BLOCK && planeBound.m_82546_(rayTraceResult.m_82450_()).m_82556_() > 4.0;
        }
        return planeBound.m_82546_(start).m_82526_(look) > 0.0 && distToPlayerSq > 2.0 && distToPlayerSq < (double)(reach * reach) && !intersects;
    }
}

