/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.diet;

import com.illusivesoulworks.diet.api.DietApi;
import com.illusivesoulworks.diet.api.type.IDietTracker;
import com.illusivesoulworks.diet.client.DietKeys;
import com.illusivesoulworks.diet.common.DietEvents;
import com.illusivesoulworks.diet.common.command.DietCommand;
import com.illusivesoulworks.diet.common.command.DietGroupArgument;
import com.illusivesoulworks.diet.common.config.DietConfigLoader;
import com.illusivesoulworks.diet.common.data.group.DietGroups;
import com.illusivesoulworks.diet.common.data.suite.DietSuites;
import com.illusivesoulworks.diet.common.integration.IntegrationManager;
import com.illusivesoulworks.diet.common.network.DietForgeNetwork;
import com.illusivesoulworks.diet.common.util.DietOverride;
import com.illusivesoulworks.diet.common.util.DietValueGenerator;
import com.illusivesoulworks.diet.data.DietBlockTagsProvider;
import com.illusivesoulworks.diet.data.DietTagsProvider;
import com.mojang.brigadier.CommandDispatcher;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.commands.synchronization.SingletonArgumentInfo;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod(value="diet")
public class DietForgeMod {
    private static final DeferredRegister<Attribute> ATTRIBUTES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ATTRIBUTES, (String)"diet");
    public static final RegistryObject<Attribute> NATURAL_REGEN = ATTRIBUTES.register("natural_regeneration", () -> DietApi.getInstance().getNaturalRegeneration());

    public DietForgeMod() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(this::setup);
        eventBus.addListener(this::process);
        eventBus.addListener(this::gatherData);
        eventBus.addListener(this::registerCaps);
        eventBus.addListener(this::modifyAttributes);
        DietConfigLoader.setup();
        ATTRIBUTES.register(eventBus);
        MinecraftForge.EVENT_BUS.addListener(this::serverStarting);
        MinecraftForge.EVENT_BUS.addListener(this::onDatapackSync);
        MinecraftForge.EVENT_BUS.addListener(this::setupCommands);
        MinecraftForge.EVENT_BUS.addListener(this::addReloaders);
    }

    private void setup(FMLCommonSetupEvent evt) {
        DietForgeNetwork.setup();
        IntegrationManager.setup();
        evt.enqueueWork(() -> (SingletonArgumentInfo)ArgumentTypeInfos.registerByClass(DietGroupArgument.class, (ArgumentTypeInfo)SingletonArgumentInfo.m_235451_(DietGroupArgument::group)));
    }

    private void addReloaders(AddReloadListenerEvent evt) {
        evt.addListener((PreparableReloadListener)DietGroups.SERVER);
        evt.addListener((PreparableReloadListener)DietSuites.SERVER);
    }

    private void process(InterModProcessEvent evt) {
        DietOverride.process(evt.getIMCStream());
    }

    private void gatherData(GatherDataEvent evt) {
        DataGenerator generator = evt.getGenerator();
        if (evt.includeServer()) {
            ExistingFileHelper existingFileHelper = evt.getExistingFileHelper();
            CompletableFuture lookupProvider = evt.getLookupProvider();
            DataGenerator gen = evt.getGenerator();
            PackOutput packOutput = gen.getPackOutput();
            DietBlockTagsProvider blockTagsProvider = new DietBlockTagsProvider(packOutput, lookupProvider, existingFileHelper);
            generator.addProvider(true, (DataProvider)new DietTagsProvider(packOutput, lookupProvider, blockTagsProvider.m_274426_(), existingFileHelper));
        }
    }

    private void registerCaps(RegisterCapabilitiesEvent evt) {
        evt.register(IDietTracker.class);
    }

    private void modifyAttributes(EntityAttributeModificationEvent evt) {
        evt.add(EntityType.f_20532_, DietApi.getInstance().getNaturalRegeneration());
    }

    private void serverStarting(ServerStartingEvent evt) {
        DietValueGenerator.reload(evt.getServer());
    }

    private void onDatapackSync(OnDatapackSyncEvent evt) {
        if (evt.getPlayer() == null) {
            DietEvents.syncDatapack(evt.getPlayerList().m_7873_());
        } else {
            DietEvents.syncDatapack(evt.getPlayer());
        }
    }

    private void setupCommands(RegisterCommandsEvent evt) {
        DietCommand.register((CommandDispatcher<CommandSourceStack>)evt.getDispatcher());
    }

    @Mod.EventBusSubscriber(modid="diet", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ClientModEvents {
        @SubscribeEvent
        public static void registerKeys(RegisterKeyMappingsEvent evt) {
            evt.register(DietKeys.get());
        }
    }
}

