/*
 * Decompiled with CFR 0.152.
 */
package com.glisco.deathlog.server;

import com.glisco.deathlog.client.DeathInfo;
import com.glisco.deathlog.death_info.SpecialPropertyProvider;
import com.glisco.deathlog.death_info.properties.CoordinatesProperty;
import com.glisco.deathlog.death_info.properties.InventoryProperty;
import com.glisco.deathlog.death_info.properties.LocationProperty;
import com.glisco.deathlog.death_info.properties.ScoreProperty;
import com.glisco.deathlog.death_info.properties.StringProperty;
import com.glisco.deathlog.storage.BaseDeathLogStorage;
import com.glisco.deathlog.storage.DeathInfoCreatedCallback;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.Nullable;

public class ServerDeathLogStorage
extends BaseDeathLogStorage {
    private final Map<UUID, List<DeathInfo>> deathInfos = new HashMap<UUID, List<DeathInfo>>();
    private final Path deathLogDir = FabricLoader.getInstance().getGameDir().resolve("deaths").toAbsolutePath();

    public ServerDeathLogStorage() {
        if (!Files.exists(this.deathLogDir, new LinkOption[0]) && !this.deathLogDir.toFile().mkdir()) {
            this.raiseError("Failed to create directory");
            LOGGER.error("Failed to create DeathLog storage directory, further disk operations have been disabled");
            return;
        }
        try {
            Files.list(this.deathLogDir).forEach(path -> {
                UUID uuid;
                if (this.isErrored()) {
                    return;
                }
                if (!Files.exists(path, new LinkOption[0])) {
                    return;
                }
                if (path.endsWith(".dat")) {
                    return;
                }
                try {
                    uuid = UUID.fromString(FilenameUtils.getBaseName((String)path.toString()));
                }
                catch (IllegalArgumentException e) {
                    this.raiseError("Invalid filename");
                    e.printStackTrace();
                    LOGGER.error("Failed to parse UUID from filename '{}', further disk operations have been disabled", (Object)FilenameUtils.removeExtension((String)path.toString()));
                    return;
                }
                this.deathInfos.put(uuid, this.load(path.toFile()).join());
            });
        }
        catch (IOException | IllegalArgumentException e) {
            this.raiseError("Unknown problem");
            e.printStackTrace();
            LOGGER.error("Failed to load DeathLog database, further disk operations have been disabled");
        }
    }

    @Override
    public List<DeathInfo> getDeathInfoList(UUID profile) {
        return this.deathInfos.getOrDefault(profile, new ArrayList());
    }

    @Override
    public void delete(DeathInfo info, UUID profile) {
        this.deathInfos.get(profile).remove(info);
        this.save(this.deathLogDir.resolve(profile.toString() + ".dat").toFile(), this.deathInfos.get(profile));
    }

    @Override
    public void store(class_2561 deathMessage, class_1657 player) {
        DeathInfo deathInfo = new DeathInfo();
        deathInfo.setProperty("inventory", new InventoryProperty(player.method_31548()));
        deathInfo.setProperty("coordinates", new CoordinatesProperty(player.method_24515()));
        deathInfo.setProperty("dimension", new StringProperty("deathlog.deathinfoproperty.dimension", player.method_37908().method_27983().method_29177().toString()));
        deathInfo.setProperty("location", new LocationProperty("Server", true));
        deathInfo.setProperty("score", new ScoreProperty(player.method_7272(), player.field_7520, player.field_7510, player.field_7495));
        deathInfo.setProperty("death_message", new StringProperty("deathlog.deathinfoproperty.death_message", deathMessage.getString()));
        deathInfo.setProperty("time_of_death", new StringProperty("deathlog.deathinfoproperty.time_of_death", new Date().toString()));
        SpecialPropertyProvider.apply(deathInfo, player);
        ((DeathInfoCreatedCallback)DeathInfoCreatedCallback.EVENT.invoker()).event(deathInfo);
        this.deathInfos.computeIfAbsent(player.method_5667(), uuid -> new ArrayList()).add(deathInfo);
        this.save(this.deathLogDir.resolve(player.method_5667().toString() + ".dat").toFile(), this.deathInfos.get(player.method_5667()));
    }

    @Override
    public void restore(int index, @Nullable UUID profile) {
    }
}

