/*
 * Decompiled with CFR 0.152.
 */
package com.glisco.deathlog.network;

import com.glisco.deathlog.DeathLogCommon;
import com.glisco.deathlog.client.DeathInfo;
import com.glisco.deathlog.client.DeathLogClient;
import com.glisco.deathlog.client.gui.DeathLogScreen;
import com.glisco.deathlog.network.RemoteDeathLogStorage;
import com.glisco.deathlog.server.DeathLogServer;
import com.glisco.deathlog.storage.BaseDeathLogStorage;
import java.util.List;
import java.util.UUID;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_437;
import net.minecraft.class_634;
import net.minecraft.server.MinecraftServer;

public class DeathLogPackets {

    public static class Server {
        public static final class_2960 OPEN_SCREEN_ID = new class_2960("deathlog", "open_screen");
        public static final class_2960 SEND_INFO_ID = new class_2960("deathlog", "send_info");

        public static void registerDedicatedListeners() {
            ServerPlayNetworking.registerGlobalReceiver((class_2960)Client.REQUEST_DELETION_ID, Server::handleDelete);
        }

        public static void registerCommonListeners() {
            ServerPlayNetworking.registerGlobalReceiver((class_2960)Client.REQUEST_RESTORE_ID, Server::handleRestore);
            ServerPlayNetworking.registerGlobalReceiver((class_2960)Client.FETCH_INFO_ID, Server::sendInfo);
        }

        private static void sendInfo(MinecraftServer minecraftServer, class_3222 player, class_3244 serverPlayNetworkHandler, class_2540 byteBuf, PacketSender packetSender) {
            UUID profileId = byteBuf.method_10790();
            int index = byteBuf.method_10816();
            minecraftServer.execute(() -> {
                if (!DeathLogServer.hasPermission(player, "deathlog.view")) {
                    BaseDeathLogStorage.LOGGER.warn("Received unauthorized info request from {}", (Object)player.method_5477().getString());
                    return;
                }
                DeathInfo info = DeathLogCommon.getStorage().getDeathInfoList(profileId).get(index);
                class_2540 buffer = PacketByteBufs.create();
                buffer.method_10804(index);
                info.write(buffer);
                ServerPlayNetworking.send((class_3222)player, (class_2960)SEND_INFO_ID, (class_2540)buffer);
            });
        }

        private static void handleRestore(MinecraftServer minecraftServer, class_3222 player, class_3244 serverPlayNetworkHandler, class_2540 byteBuf, PacketSender packetSender) {
            UUID profileId = byteBuf.method_10790();
            int index = byteBuf.method_10816();
            minecraftServer.execute(() -> {
                if (!DeathLogServer.hasPermission(player, "deathlog.restore")) {
                    BaseDeathLogStorage.LOGGER.warn("Received unauthorized restore packet from {}", (Object)player.method_5477().getString());
                    return;
                }
                class_3222 targetPlayer = minecraftServer.method_3760().method_14602(profileId);
                if (targetPlayer == null) {
                    BaseDeathLogStorage.LOGGER.warn("Received restore packet for invalid player");
                    return;
                }
                List<DeathInfo> infoList = DeathLogCommon.getStorage().getDeathInfoList(profileId);
                if (index > infoList.size() - 1) {
                    BaseDeathLogStorage.LOGGER.warn("Received restore packet with invalid index from '{}'", (Object)player.method_5477().getString());
                    return;
                }
                infoList.get(index).restore(targetPlayer);
            });
        }

        private static void handleDelete(MinecraftServer minecraftServer, class_3222 player, class_3244 serverPlayNetworkHandler, class_2540 byteBuf, PacketSender packetSender) {
            UUID profileId = byteBuf.method_10790();
            int index = byteBuf.method_10816();
            minecraftServer.execute(() -> {
                if (!DeathLogServer.hasPermission(player, "deathlog.delete")) {
                    BaseDeathLogStorage.LOGGER.warn("Received unauthorized delete packet from {}", (Object)player.method_5477().getString());
                    return;
                }
                DeathLogServer.getStorage().delete(DeathLogServer.getStorage().getDeathInfoList(profileId).get(index), profileId);
            });
        }

        public static void openScreen(UUID profileId, class_3222 target) {
            class_2540 buffer = PacketByteBufs.create();
            List<DeathInfo> infos = DeathLogServer.getStorage().getDeathInfoList(profileId);
            buffer.method_34062(infos, (packetByteBuf, info) -> info.writePartial((class_2540)packetByteBuf));
            buffer.method_10797(profileId);
            buffer.writeBoolean(target.method_5682().method_3760().method_14602(profileId) != null);
            ServerPlayNetworking.send((class_3222)target, (class_2960)OPEN_SCREEN_ID, (class_2540)buffer);
        }
    }

    public static class Client {
        public static final class_2960 REQUEST_DELETION_ID = new class_2960("deathlog", "request_deletion");
        public static final class_2960 REQUEST_RESTORE_ID = new class_2960("deathlog", "request_restore");
        public static final class_2960 FETCH_INFO_ID = new class_2960("deathlog", "fetch_info");

        public static void registerListeners() {
            ClientPlayNetworking.registerGlobalReceiver((class_2960)Server.OPEN_SCREEN_ID, Client::handleOpenScreen);
            ClientPlayNetworking.registerGlobalReceiver((class_2960)Server.SEND_INFO_ID, Client::receiveInfo);
        }

        private static void receiveInfo(class_310 client, class_634 clientPlayNetworkHandler, class_2540 byteBuf, PacketSender packetSender) {
            int index = byteBuf.method_10816();
            DeathInfo info = DeathInfo.read(byteBuf);
            client.execute(() -> {
                class_437 patt1959$temp = client.field_1755;
                if (!(patt1959$temp instanceof DeathLogScreen)) {
                    BaseDeathLogStorage.LOGGER.warn("Received invalid death info packet");
                    return;
                }
                DeathLogScreen screen = (DeathLogScreen)patt1959$temp;
                screen.updateInfo(info, index);
            });
        }

        private static void handleOpenScreen(class_310 minecraftClient, class_634 clientPlayNetworkHandler, class_2540 packetByteBuf, PacketSender packetSender) {
            RemoteDeathLogStorage storage = RemoteDeathLogStorage.read(packetByteBuf);
            boolean canRestore = packetByteBuf.readBoolean();
            minecraftClient.execute(() -> DeathLogClient.openScreen(storage, canRestore));
        }

        public static void requestDeletion(UUID profile, int index) {
            class_2540 buffer = PacketByteBufs.create();
            buffer.method_10797(profile);
            buffer.method_10804(index);
            ClientPlayNetworking.send((class_2960)REQUEST_DELETION_ID, (class_2540)buffer);
        }

        public static void requestRestore(UUID profile, int index) {
            class_2540 buffer = PacketByteBufs.create();
            buffer.method_10797(profile);
            buffer.method_10804(index);
            ClientPlayNetworking.send((class_2960)REQUEST_RESTORE_ID, (class_2540)buffer);
        }

        public static void fetchInfo(UUID profile, int index) {
            class_2540 buffer = PacketByteBufs.create();
            buffer.method_10797(profile);
            buffer.method_10804(index);
            ClientPlayNetworking.send((class_2960)FETCH_INFO_ID, (class_2540)buffer);
        }
    }
}

