/*
 * Decompiled with CFR 0.152.
 */
package com.glisco.deathlog.client;

import com.glisco.deathlog.death_info.DeathInfoProperty;
import com.glisco.deathlog.death_info.DeathInfoPropertySerializer;
import com.glisco.deathlog.death_info.RestorableDeathInfoProperty;
import com.glisco.deathlog.death_info.properties.InventoryProperty;
import com.glisco.deathlog.death_info.properties.TrinketComponentProperty;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3545;

public class DeathInfo {
    public static final String COORDINATES_KEY = "coordinates";
    public static final String DIMENSION_KEY = "dimension";
    public static final String LOCATION_KEY = "location";
    public static final String SCORE_KEY = "score";
    public static final String DEATH_MESSAGE_KEY = "death_message";
    public static final String TIME_OF_DEATH_KEY = "time_of_death";
    public static final String INVENTORY_KEY = "inventory";
    private final Map<String, DeathInfoProperty> properties = new LinkedHashMap<String, DeathInfoProperty>();

    public static DeathInfo readFromNbt(class_2499 nbt) {
        DeathInfo deathInfo = new DeathInfo();
        nbt.forEach(element -> {
            class_3545<DeathInfoProperty, String> parsed = DeathInfoPropertySerializer.load((class_2487)element);
            deathInfo.setProperty((String)parsed.method_15441(), (DeathInfoProperty)parsed.method_15442());
        });
        return deathInfo;
    }

    public class_2499 writeNbt() {
        class_2499 nbt = new class_2499();
        this.properties.forEach((s, property) -> nbt.add((Object)DeathInfoPropertySerializer.save(property, s)));
        return nbt;
    }

    public static DeathInfo read(class_2540 buffer) {
        return DeathInfo.readFromNbt(buffer.method_10798().method_10554("DeathInfo", 10));
    }

    public void write(class_2540 buffer) {
        class_2487 nbt = new class_2487();
        nbt.method_10566("DeathInfo", (class_2520)this.writeNbt());
        buffer.method_10794(nbt);
    }

    public void writePartial(class_2540 buffer) {
        class_2499 list = new class_2499();
        this.properties.forEach((s, property) -> {
            if (property instanceof InventoryProperty || property instanceof TrinketComponentProperty) {
                return;
            }
            list.add((Object)DeathInfoPropertySerializer.save(property, s));
        });
        class_2487 nbt = new class_2487();
        nbt.method_10566("DeathInfo", (class_2520)list);
        buffer.method_10794(nbt);
    }

    public void restore(class_3222 player) {
        this.properties.values().stream().filter(property -> property instanceof RestorableDeathInfoProperty).forEach(property -> ((RestorableDeathInfoProperty)property).restore(player));
    }

    public void setProperty(String property, DeathInfoProperty value) {
        this.properties.put(property, value);
    }

    public Optional<DeathInfoProperty> getProperty(String property) {
        return Optional.ofNullable(this.properties.get(property));
    }

    public boolean isPartial() {
        return this.getProperty(INVENTORY_KEY).isEmpty();
    }

    public class_2561 getListName() {
        DeathInfoProperty property = this.getProperty(TIME_OF_DEATH_KEY).orElse(null);
        return property == null ? class_2561.method_43471((String)"text.deathlog.info.time_missing") : property.formatted();
    }

    public class_2561 getTitle() {
        DeathInfoProperty property = this.getProperty(DEATH_MESSAGE_KEY).orElse(null);
        return property == null ? class_2561.method_43471((String)"text.deathlog.info.death_message_missing") : property.formatted();
    }

    public List<class_2561> getLeftColumnText() {
        ArrayList<class_2561> texts = new ArrayList<class_2561>();
        this.iterateDisplayProperties(property -> texts.add(property.getName()));
        return texts;
    }

    public List<class_2561> getRightColumnText() {
        ArrayList<class_2561> texts = new ArrayList<class_2561>();
        this.iterateDisplayProperties(property -> texts.add(property.formatted()));
        return texts;
    }

    public String createSearchString() {
        StringBuilder builder = new StringBuilder();
        this.properties.forEach((s, property) -> builder.append(property.toSearchableString()));
        return builder.toString().toLowerCase();
    }

    private void iterateDisplayProperties(Consumer<DeathInfoProperty> callback) {
        this.properties.forEach((s, property) -> {
            if (!property.getType().displayedInInfoView()) {
                return;
            }
            callback.accept((DeathInfoProperty)property);
        });
    }

    public class_2371<class_1799> getPlayerArmor() {
        Optional<DeathInfoProperty> propertyOptional = this.getProperty(INVENTORY_KEY);
        if (propertyOptional.isEmpty()) {
            return class_2371.method_10211();
        }
        return ((InventoryProperty)propertyOptional.get()).getPlayerArmor();
    }

    public class_2371<class_1799> getPlayerItems() {
        Optional<DeathInfoProperty> propertyOptional = this.getProperty(INVENTORY_KEY);
        if (propertyOptional.isEmpty()) {
            return class_2371.method_10211();
        }
        return ((InventoryProperty)propertyOptional.get()).getPlayerItems();
    }
}

