/*
 * Decompiled with CFR 0.152.
 */
package me.duquee.createutilities.ponder;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import me.duquee.createutilities.ponder.ParallelSceneBuilder;
import net.createmod.ponder.api.scene.SceneBuilder;
import net.createmod.ponder.foundation.PonderScene;
import net.createmod.ponder.foundation.instruction.PonderInstruction;

public class ParallelInstruction
extends PonderInstruction {
    private final List<PonderInstruction> schedule = new ArrayList<PonderInstruction>();
    private final List<PonderInstruction> activeSchedule = new ArrayList<PonderInstruction>();
    public final ParallelSceneBuilder scene;

    public ParallelInstruction(SceneBuilder builder) {
        this.scene = new ParallelSceneBuilder(builder, this);
    }

    public void reset(PonderScene scene) {
        super.reset(scene);
        this.activeSchedule.clear();
        this.schedule.forEach(mdi -> mdi.reset(scene));
    }

    public boolean isComplete() {
        return this.activeSchedule.isEmpty();
    }

    public void onScheduled(PonderScene scene) {
        this.activeSchedule.addAll(this.schedule);
    }

    public void tick(PonderScene scene) {
        Iterator<PonderInstruction> iterator = this.activeSchedule.iterator();
        while (iterator.hasNext()) {
            PonderInstruction instruction = iterator.next();
            instruction.tick(scene);
            if (instruction.isComplete()) {
                iterator.remove();
                if (!instruction.isBlocking()) continue;
                break;
            }
            if (!instruction.isBlocking()) continue;
            break;
        }
    }

    public void addInstruction(PonderInstruction instruction) {
        this.schedule.add(instruction);
    }
}

