/*
 * Decompiled with CFR 0.152.
 */
package net.pttheta.loveandwar.recipe.drawing;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeSerializer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.pttheta.loveandwar.recipe.drawing.DrawingRecipe;

public class SequencedAssemblyDrawingRecipeSerializer
extends ProcessingRecipeSerializer<DrawingRecipe> {
    private static final String RESULT_KEY = "result";
    private static final String SEQUENCED_ASSEMBLY_RESULT_KEY = "results";
    private static final String INGREDIENT_KEY = "input";
    private static final String SEQUENCED_ASSEMBLY_INGREDIENT_KEY = "ingredients";

    public SequencedAssemblyDrawingRecipeSerializer(ProcessingRecipeBuilder.ProcessingRecipeFactory<DrawingRecipe> factory) {
        super(factory);
    }

    protected void writeToJson(JsonObject json, DrawingRecipe recipe) {
        super.writeToJson(json, (ProcessingRecipe)recipe);
    }

    protected ItemStack readOutput(JsonObject json) {
        JsonElement results;
        if (json.has(RESULT_KEY)) {
            JsonElement result = json.get(RESULT_KEY);
            if (result.isJsonObject() && result.getAsJsonObject().has("item")) {
                return ShapedRecipe.m_151274_((JsonObject)result.getAsJsonObject());
            }
        } else if (json.has(SEQUENCED_ASSEMBLY_RESULT_KEY) && (results = json.get(SEQUENCED_ASSEMBLY_RESULT_KEY)).isJsonArray() && !results.getAsJsonArray().isEmpty()) {
            JsonObject result = results.getAsJsonArray().get(0).getAsJsonObject();
            if (!result.has("count")) {
                result.add("count", (JsonElement)new JsonPrimitive((Number)1));
            }
            return ShapedRecipe.m_151274_((JsonObject)result);
        }
        return ItemStack.f_41583_;
    }

    protected Ingredient readIngredient(JsonObject json) {
        JsonElement jsonArray;
        if (json.has(INGREDIENT_KEY)) {
            return Ingredient.m_43917_((JsonElement)json.get(INGREDIENT_KEY).getAsJsonObject());
        }
        if (json.has(SEQUENCED_ASSEMBLY_INGREDIENT_KEY) && (jsonArray = json.get(SEQUENCED_ASSEMBLY_INGREDIENT_KEY)).isJsonArray() && !jsonArray.getAsJsonArray().isEmpty()) {
            return Ingredient.m_43917_((JsonElement)jsonArray.getAsJsonArray().get(0));
        }
        return Ingredient.f_43901_;
    }

    protected DrawingRecipe readFromJson(ResourceLocation recipeId, JsonObject json) {
        ItemStack output = this.readOutput(json);
        Ingredient input = this.readIngredient(json);
        return new DrawingRecipe(input, output, recipeId);
    }

    protected void writeToBuffer(FriendlyByteBuf buffer, DrawingRecipe recipe) {
        buffer.m_130055_(recipe.output);
        recipe.ingredient.m_43923_(buffer);
    }

    protected DrawingRecipe readFromBuffer(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        ItemStack output = buffer.m_130267_();
        Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        return new DrawingRecipe(input, output, recipeId);
    }
}

