/*
 * Decompiled with CFR 0.152.
 */
package net.pttheta.loveandwar.recipe;

import java.util.function.Supplier;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.pttheta.loveandwar.recipe.drawing.DrawingRecipe;
import net.pttheta.loveandwar.recipe.drawing.DrawingRecipeProcessingFactory;
import net.pttheta.loveandwar.recipe.drawing.SequencedAssemblyDrawingRecipeSerializer;
import net.pttheta.loveandwar.recipe.stamping.SequencedAssemblyStampingRecipeSerializer;
import net.pttheta.loveandwar.recipe.stamping.StampingRecipe;
import net.pttheta.loveandwar.recipe.stamping.StampingRecipeProcessingFactory;

public class ModRecipes {
    public static final DeferredRegister<RecipeSerializer<?>> SERIALIZERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"createloveandwar");
    public static final DeferredRegister<RecipeType<?>> RECIPE_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_TYPES, (String)"createloveandwar");
    public static final Supplier<RecipeType<DrawingRecipe>> DRAWING_TYPE = ModRecipes.register("drawing");
    public static final Supplier<RecipeType<StampingRecipe>> STAMPING_TYPE = ModRecipes.register("stamping");
    public static RegistryObject<RecipeSerializer<?>> DRAWING = SERIALIZERS.register("drawing", () -> new SequencedAssemblyDrawingRecipeSerializer(new DrawingRecipeProcessingFactory()));
    public static RegistryObject<RecipeSerializer<?>> STAMPING = SERIALIZERS.register("stamping", () -> new SequencedAssemblyStampingRecipeSerializer(new StampingRecipeProcessingFactory()));

    private static <T extends Recipe<?>> Supplier<RecipeType<T>> register(final String id) {
        return RECIPE_TYPES.register(id, () -> new RecipeType<T>(){

            public String toString() {
                return id;
            }
        });
    }

    public static void register(IEventBus event) {
        SERIALIZERS.register(event);
        RECIPE_TYPES.register(event);
    }
}

