/*
 * Decompiled with CFR 0.152.
 */
package net.pttheta.loveandwar.blocks.stamping;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.kinetics.belt.behaviour.BeltProcessingBehaviour;
import com.simibubi.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.ArrayList;
import java.util.List;
import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.extensions.IForgeItemStack;
import net.pttheta.loveandwar.blocks.stamping.BeltStampingCallbacks;

public class StampingBehaviour
extends BeltProcessingBehaviour {
    public static final int CYCLE = 240;
    public static final int ENTITY_SCAN = 10;
    public List<ItemStack> particleItems = new ArrayList<ItemStack>();
    public StampingBehaviourSpecifics specifics;
    public int prevRunningTicks;
    public int runningTicks;
    public boolean running;
    public boolean finished;
    public Mode mode;
    int entityScanCooldown;

    public <T extends SmartBlockEntity> StampingBehaviour(T be) {
        super(be);
        this.specifics = (StampingBehaviourSpecifics)be;
        this.mode = Mode.WORLD;
        this.entityScanCooldown = 10;
        this.whenItemEnters((s, i) -> BeltStampingCallbacks.onItemReceived(s, i, this));
        this.whileItemHeld((s, i) -> BeltStampingCallbacks.whenItemHeld(s, i, this));
    }

    public void read(CompoundTag compound, boolean clientPacket) {
        this.running = compound.m_128471_("Running");
        this.mode = Mode.values()[compound.m_128451_("Mode")];
        this.finished = compound.m_128471_("Finished");
        this.prevRunningTicks = this.runningTicks = compound.m_128451_("Ticks");
        super.read(compound, clientPacket);
        if (clientPacket) {
            NBTHelper.iterateCompoundList((ListTag)compound.m_128437_("ParticleItems", 10), c -> this.particleItems.add(ItemStack.m_41712_((CompoundTag)c)));
            this.spawnParticles();
        }
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128379_("Running", this.running);
        compound.m_128405_("Mode", this.mode.ordinal());
        compound.m_128379_("Finished", this.finished);
        compound.m_128405_("Ticks", this.runningTicks);
        super.write(compound, clientPacket);
        if (clientPacket) {
            compound.m_128365_("ParticleItems", (Tag)NBTHelper.writeCompoundList(this.particleItems, IForgeItemStack::serializeNBT));
            this.particleItems.clear();
        }
    }

    public float getRenderedHeadOffset(float partialTicks) {
        if (!this.running) {
            return 0.0f;
        }
        int runningTicks = Math.abs(this.runningTicks);
        float ticks = Mth.m_14179_((float)partialTicks, (float)this.prevRunningTicks, (float)runningTicks);
        if (runningTicks < 160) {
            return (float)Mth.m_14008_((double)Math.pow(ticks / 240.0f * 2.0f, 3.0), (double)0.0, (double)1.0);
        }
        return Mth.m_14036_((float)((240.0f - ticks) / 240.0f * 3.0f), (float)0.0f, (float)1.0f);
    }

    public void start(Mode mode) {
        this.mode = mode;
        this.running = true;
        this.prevRunningTicks = 0;
        this.runningTicks = 0;
        this.particleItems.clear();
        this.blockEntity.sendData();
    }

    public void addTemplate(ItemStack item) {
        this.specifics.setTemplate(item);
    }

    public boolean inWorld() {
        return this.mode == Mode.WORLD;
    }

    public void tick() {
        super.tick();
        Level level = this.getWorld();
        BlockPos worldPosition = this.getPos();
        if (!this.running || level == null) {
            if (level != null && !level.f_46443_) {
                if (this.specifics.getKineticSpeed() == 0.0f) {
                    return;
                }
                if (this.entityScanCooldown > 0) {
                    --this.entityScanCooldown;
                }
                if (this.entityScanCooldown <= 0) {
                    this.entityScanCooldown = 10;
                    if (BlockEntityBehaviour.get((BlockGetter)level, (BlockPos)worldPosition.m_6625_(2), (BehaviourType)TransportedItemStackHandlerBehaviour.TYPE) != null) {
                        return;
                    }
                    for (ItemEntity itemEntity : level.m_45976_(ItemEntity.class, new AABB(worldPosition.m_7495_()).m_82406_(0.125))) {
                        if (!itemEntity.m_6084_() || !itemEntity.m_20096_() || !this.specifics.tryProcessInWorld(itemEntity, true)) continue;
                        this.start(Mode.WORLD);
                        return;
                    }
                }
            }
            return;
        }
        if (level.f_46443_ && this.runningTicks == -120) {
            this.prevRunningTicks = 120;
            return;
        }
        if (this.runningTicks == 120 && this.specifics.getKineticSpeed() != 0.0f) {
            if (this.inWorld()) {
                this.applyInWorld();
            }
            if (level.m_8055_(worldPosition.m_6625_(2)).m_60827_() == SoundType.f_56745_) {
                AllSoundEvents.MECHANICAL_PRESS_ACTIVATION_ON_BELT.playOnServer(level, (Vec3i)worldPosition);
            } else {
                AllSoundEvents.MECHANICAL_PRESS_ACTIVATION.playOnServer(level, (Vec3i)worldPosition, 0.5f, 0.75f + Math.abs(this.specifics.getKineticSpeed()) / 1024.0f);
            }
            if (!level.f_46443_) {
                this.blockEntity.sendData();
            }
        }
        if (!level.f_46443_ && this.runningTicks > 240) {
            this.finished = true;
            this.running = false;
            this.particleItems.clear();
            this.specifics.onStampingCompleted();
            this.blockEntity.sendData();
            return;
        }
        this.prevRunningTicks = this.runningTicks;
        this.runningTicks += this.getRunningTickSpeed();
        if (this.prevRunningTicks < 120 && this.runningTicks >= 120) {
            this.runningTicks = 120;
            if (level.f_46443_ && !this.blockEntity.isVirtual()) {
                this.runningTicks = -120;
            }
        }
    }

    protected void applyInWorld() {
        Level level = this.getWorld();
        BlockPos worldPosition = this.getPos();
        AABB bb = new AABB(worldPosition.m_6625_(1));
        boolean bulk = this.specifics.canProcessInBulk();
        this.particleItems.clear();
        if (level.f_46443_) {
            return;
        }
        for (Entity entity : level.m_45933_(null, bb)) {
            if (!(entity instanceof ItemEntity)) continue;
            ItemEntity itemEntity = (ItemEntity)entity;
            if (!entity.m_6084_() || !entity.m_20096_()) continue;
            this.entityScanCooldown = 0;
            if (this.specifics.tryProcessInWorld(itemEntity, false)) {
                this.blockEntity.sendData();
            }
            if (bulk) continue;
            break;
        }
    }

    public int getRunningTickSpeed() {
        float speed = this.specifics.getKineticSpeed();
        if (speed == 0.0f) {
            return 0;
        }
        return (int)Mth.m_14179_((float)Mth.m_14036_((float)(Math.abs(speed) / 512.0f), (float)0.0f, (float)1.0f), (float)1.0f, (float)60.0f);
    }

    protected void spawnParticles() {
        if (this.particleItems.isEmpty()) {
            return;
        }
        BlockPos worldPosition = this.getPos();
        if (this.mode == Mode.BELT) {
            this.particleItems.forEach(stack -> this.makePressingParticleEffect(VecHelper.getCenterOf((Vec3i)worldPosition.m_6625_(2)).m_82520_(0.0, 0.5, 0.0), (ItemStack)stack));
        }
        if (this.mode == Mode.WORLD) {
            this.particleItems.forEach(stack -> this.makePressingParticleEffect(VecHelper.getCenterOf((Vec3i)worldPosition.m_6625_(1)).m_82520_(0.0, -0.25, 0.0), (ItemStack)stack));
        }
        this.particleItems.clear();
    }

    public void makePressingParticleEffect(Vec3 pos, ItemStack stack) {
        this.makePressingParticleEffect(pos, stack, this.specifics.getParticleAmount());
    }

    public void makePressingParticleEffect(Vec3 pos, ItemStack stack, int amount) {
        Level level = this.getWorld();
        if (level == null || !level.f_46443_) {
            return;
        }
        for (int i = 0; i < amount; ++i) {
            Vec3 motion = VecHelper.offsetRandomly((Vec3)Vec3.f_82478_, (RandomSource)level.f_46441_, (float)0.125f).m_82542_(1.0, 0.0, 1.0);
            motion = motion.m_82520_(0.0, amount != 1 ? 0.125 : 0.0625, 0.0);
            level.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), pos.f_82479_, pos.f_82480_ - 0.25, pos.f_82481_, motion.f_82479_, motion.f_82480_, motion.f_82481_);
        }
    }

    public static interface StampingBehaviourSpecifics {
        public boolean tryProcessOnBelt(TransportedItemStack var1, List<ItemStack> var2, boolean var3);

        public boolean tryProcessInWorld(ItemEntity var1, boolean var2);

        public boolean canProcessInBulk();

        public void onStampingCompleted();

        public int getParticleAmount();

        public float getKineticSpeed();

        public void setTemplate(ItemStack var1);
    }

    public static enum Mode {
        WORLD(1.0f),
        BELT(1.1875f);

        public float headOffset;

        private Mode(float headOffset) {
            this.headOffset = headOffset;
        }
    }
}

