/*
 * Decompiled with CFR 0.152.
 */
package net.pttheta.loveandwar.blocks.drawing;

import com.simibubi.create.Create;
import com.simibubi.create.content.kinetics.belt.BeltHelper;
import com.simibubi.create.content.kinetics.belt.behaviour.BeltProcessingBehaviour;
import com.simibubi.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.world.item.ItemStack;
import net.pttheta.loveandwar.blocks.drawing.DrawingBehaviour;

public class BeltDrawingCallbacks {
    static BeltProcessingBehaviour.ProcessingResult onItemReceived(TransportedItemStack transported, TransportedItemStackHandlerBehaviour handler, DrawingBehaviour behaviour) {
        if (behaviour.specifics.getKineticSpeed() == 0.0f) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        if (behaviour.running) {
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        if (!behaviour.specifics.tryProcessOnBelt(transported, null, true)) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        behaviour.start(DrawingBehaviour.Mode.BELT);
        return BeltProcessingBehaviour.ProcessingResult.HOLD;
    }

    static BeltProcessingBehaviour.ProcessingResult whenItemHeld(TransportedItemStack transported, TransportedItemStackHandlerBehaviour handler, DrawingBehaviour behaviour) {
        if (behaviour.specifics.getKineticSpeed() == 0.0f) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        if (!behaviour.running) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        if (behaviour.runningTicks != 120) {
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        behaviour.particleItems.clear();
        ArrayList<ItemStack> results = new ArrayList<ItemStack>();
        if (!behaviour.specifics.tryProcessOnBelt(transported, results, false)) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        boolean bulk = behaviour.specifics.canProcessInBulk() || transported.stack.m_41613_() == 1;
        List collect = results.stream().map(stack -> {
            TransportedItemStack copy = transported.copy();
            boolean centered = BeltHelper.isItemUpright((ItemStack)stack);
            copy.stack = stack;
            copy.locked = true;
            copy.angle = centered ? 180 : Create.RANDOM.nextInt(360);
            return copy;
        }).collect(Collectors.toList());
        if (bulk) {
            if (collect.isEmpty()) {
                handler.handleProcessingOnItem(transported, TransportedItemStackHandlerBehaviour.TransportedResult.removeItem());
            } else {
                handler.handleProcessingOnItem(transported, TransportedItemStackHandlerBehaviour.TransportedResult.convertTo(collect));
            }
        } else {
            TransportedItemStack left = transported.copy();
            left.stack.m_41774_(1);
            if (collect.isEmpty()) {
                handler.handleProcessingOnItem(transported, TransportedItemStackHandlerBehaviour.TransportedResult.convertTo((TransportedItemStack)left));
            } else {
                handler.handleProcessingOnItem(transported, TransportedItemStackHandlerBehaviour.TransportedResult.convertToAndLeaveHeld(collect, (TransportedItemStack)left));
            }
        }
        behaviour.blockEntity.sendData();
        return BeltProcessingBehaviour.ProcessingResult.HOLD;
    }
}

