/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.munitions.config;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.PacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import rbasamoyai.createbigcannons.base.tag_utils.FluidTypeDataHolder;
import rbasamoyai.createbigcannons.multiloader.NetworkPlatform;
import rbasamoyai.createbigcannons.network.RootPacket;
import rbasamoyai.createbigcannons.utils.CBCRegistryUtils;
import rbasamoyai.createbigcannons.utils.CBCUtils;

public class FluidDragHandler {
    private static final FluidTypeDataHolder<Double> FLUID_DRAG = new FluidTypeDataHolder();

    public static void loadTags() {
        FLUID_DRAG.loadTags();
    }

    public static double getFluidDrag(FluidState fluidState) {
        return fluidState.m_76178_() ? 0.0 : FluidDragHandler.getFluidDrag(fluidState.m_76152_());
    }

    public static double getFluidDrag(Fluid fluid) {
        Double value = FLUID_DRAG.getData(fluid);
        return value == null ? 0.0 : value;
    }

    public static void writeBuf(FriendlyByteBuf buf) {
        FLUID_DRAG.writeToNetwork(buf, FriendlyByteBuf::writeDouble);
    }

    public static void readBuf(FriendlyByteBuf buf) {
        FLUID_DRAG.readFromNetwork(buf, FriendlyByteBuf::readDouble);
    }

    public static void syncTo(ServerPlayer player) {
        NetworkPlatform.sendToClientPlayer(new ClientboundFluidDragPacket(), player);
    }

    public static void syncToAll(MinecraftServer server) {
        NetworkPlatform.sendToClientAll(new ClientboundFluidDragPacket(), server);
    }

    public record ClientboundFluidDragPacket(@Nullable FriendlyByteBuf buf) implements RootPacket
    {
        public ClientboundFluidDragPacket() {
            this(null);
        }

        public static ClientboundFluidDragPacket copyOf(FriendlyByteBuf buf) {
            return new ClientboundFluidDragPacket(new FriendlyByteBuf(buf.copy()));
        }

        @Override
        public void rootEncode(FriendlyByteBuf buf) {
            FluidDragHandler.writeBuf(buf);
        }

        @Override
        public void handle(Executor exec, PacketListener listener, @Nullable ServerPlayer sender) {
            if (this.buf != null) {
                FluidDragHandler.readBuf(this.buf);
            }
        }
    }

    public static class ReloadListener
    extends SimpleJsonResourceReloadListener {
        private static final Gson GSON = new Gson();
        public static final ReloadListener INSTANCE = new ReloadListener();

        ReloadListener() {
            super(GSON, "fluid_drag");
        }

        protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager manager, ProfilerFiller profiler) {
            FLUID_DRAG.cleanUp();
            for (Map.Entry<ResourceLocation, JsonElement> entry : map.entrySet()) {
                JsonElement el = entry.getValue();
                if (!el.isJsonObject()) continue;
                JsonObject obj = el.getAsJsonObject();
                double fluidDrag = Math.max(GsonHelper.m_144742_((JsonObject)obj, (String)"fluid_drag", (double)0.0), 0.0);
                ResourceLocation loc = entry.getKey();
                if (loc.m_135815_().startsWith("tags/")) {
                    TagKey tag = TagKey.m_203882_(CBCRegistryUtils.getFluidRegistryKey(), (ResourceLocation)CBCUtils.location(loc.m_135827_(), loc.m_135815_().substring(5)));
                    FLUID_DRAG.addTagData(tag, fluidDrag);
                    continue;
                }
                Fluid fluid = CBCRegistryUtils.getOptionalFluid(loc).orElseThrow(() -> new JsonSyntaxException("Unknown fluid type '" + String.valueOf(loc) + "'"));
                FLUID_DRAG.addData(fluid, fluidDrag);
            }
        }
    }
}

