/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.cannon_control.fixed_cannon_mount;

import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import rbasamoyai.createbigcannons.cannon_control.cannon_mount.CannonMountBlock;
import rbasamoyai.createbigcannons.cannon_control.fixed_cannon_mount.FixedCannonMountBlockEntity;
import rbasamoyai.createbigcannons.index.CBCBlockEntities;

public class FixedCannonMountBlock
extends DirectionalBlock
implements IBE<FixedCannonMountBlockEntity>,
IWrenchable {
    public static final BooleanProperty ASSEMBLY_POWERED = CannonMountBlock.ASSEMBLY_POWERED;
    public static final BooleanProperty FIRE_POWERED = CannonMountBlock.FIRE_POWERED;
    public static final DirectionProperty ROTATION = DirectionProperty.m_61549_((String)"rotation", (Direction[])new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST});

    public FixedCannonMountBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)f_52588_, (Comparable)Direction.NORTH)).m_61124_((Property)ROTATION, (Comparable)Direction.NORTH)).m_61124_((Property)ASSEMBLY_POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FIRE_POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_52588_, ROTATION, ASSEMBLY_POWERED, FIRE_POWERED});
        super.m_7926_(builder);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction dir = context.m_7820_();
        boolean flag = context.m_43723_() != null && context.m_43723_().m_6144_();
        BlockState state = (BlockState)this.m_49966_().m_61124_((Property)f_52588_, (Comparable)(flag ? dir : dir.m_122424_()));
        if (dir.m_122434_().m_122478_()) {
            Direction facing = context.m_8125_();
            state = (BlockState)state.m_61124_((Property)ROTATION, (Comparable)(dir == Direction.UP ? facing : facing.m_122424_()));
        }
        return state;
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean isMoving) {
        if (!level.f_46443_ && !level.m_183326_().m_183588_(pos, (Object)this)) {
            level.m_186460_(pos, (Block)this, 0);
        }
    }

    public Direction getAssemblyFace(BlockState state) {
        Direction dir1;
        Direction facing = (Direction)state.m_61143_((Property)f_52588_);
        Direction rotation = (Direction)state.m_61143_((Property)ROTATION);
        if (facing.m_122434_().m_122478_()) {
            return facing == Direction.UP || rotation.m_122434_() == Direction.Axis.X ? rotation : rotation.m_122424_();
        }
        Direction direction = dir1 = rotation.m_122434_() == Direction.Axis.X ? rotation : rotation.m_175362_(Direction.Axis.X);
        if (dir1.m_122434_().m_122478_()) {
            return dir1;
        }
        int rot = facing.m_122416_();
        Direction dir2 = dir1;
        for (int i = 0; i < rot; ++i) {
            dir2 = dir2.m_122428_();
        }
        return facing.m_122434_() == Direction.Axis.Z && rotation.m_122434_() == Direction.Axis.X ? dir2.m_122424_() : dir2;
    }

    public Direction getFiringFace(BlockState state) {
        return this.getAssemblyFace(state).m_122424_();
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        boolean prevAssemblyPowered = (Boolean)state.m_61143_((Property)ASSEMBLY_POWERED);
        boolean prevFirePowered = (Boolean)state.m_61143_((Property)FIRE_POWERED);
        boolean assemblyPowered = this.hasNeighborSignal((Level)level, state, pos, ASSEMBLY_POWERED);
        boolean firePowered = this.hasNeighborSignal((Level)level, state, pos, FIRE_POWERED);
        Direction fireDirection = this.getFiringFace(state);
        int firePower = level.m_277185_(pos.m_121945_(fireDirection), fireDirection);
        this.withBlockEntityDo((BlockGetter)level, pos, mount -> mount.onRedstoneUpdate(assemblyPowered, prevAssemblyPowered, firePowered, prevFirePowered, firePower));
    }

    private boolean hasNeighborSignal(Level level, BlockState state, BlockPos pos, BooleanProperty property) {
        if (property == FIRE_POWERED) {
            Direction fireDirection = this.getFiringFace(state);
            return level.m_277185_(pos.m_121945_(fireDirection), fireDirection) > 0;
        }
        if (property == ASSEMBLY_POWERED) {
            Direction assemblyDirection = this.getAssemblyFace(state);
            return level.m_277185_(pos.m_121945_(assemblyDirection), assemblyDirection) > 0;
        }
        return false;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        if (((Direction)state.m_61143_((Property)f_52588_)).m_122434_().m_122478_()) {
            return (BlockState)state.m_61124_((Property)ROTATION, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)ROTATION)));
        }
        return (BlockState)state.m_61124_((Property)f_52588_, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)f_52588_)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        if (((Direction)state.m_61143_((Property)f_52588_)).m_122434_().m_122478_()) {
            return (BlockState)state.m_61124_((Property)ROTATION, (Comparable)mirror.m_54848_((Direction)state.m_61143_((Property)ROTATION)));
        }
        return (BlockState)state.m_61124_((Property)f_52588_, (Comparable)mirror.m_54848_((Direction)state.m_61143_((Property)f_52588_)));
    }

    public BlockState getRotatedBlockState(BlockState originalState, Direction targetedFace) {
        Direction facing = (Direction)originalState.m_61143_((Property)f_52588_);
        if (targetedFace.m_122434_() == facing.m_122434_()) {
            return (BlockState)originalState.m_61124_((Property)ROTATION, (Comparable)((Direction)originalState.m_61143_((Property)ROTATION)).m_122427_());
        }
        Direction facing1 = facing.m_175362_(targetedFace.m_122434_());
        BlockState newState = (BlockState)originalState.m_61124_((Property)f_52588_, (Comparable)facing1);
        if (targetedFace.m_122434_() == Direction.Axis.X && (facing == Direction.DOWN || facing1 == Direction.UP)) {
            newState = (BlockState)newState.m_61124_((Property)ROTATION, (Comparable)((Direction)newState.m_61143_((Property)ROTATION)).m_122424_());
        }
        if (targetedFace.m_122434_() == Direction.Axis.Z) {
            newState = (BlockState)newState.m_61124_((Property)ROTATION, (Comparable)((Direction)newState.m_61143_((Property)ROTATION)).m_122428_());
        }
        return newState;
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        BlockEntity blockEntity;
        InteractionResult resultType = super.onWrenched(state, context);
        if (!context.m_43725_().f_46443_ && resultType.m_19077_() && (blockEntity = context.m_43725_().m_7702_(context.m_8083_())) instanceof FixedCannonMountBlockEntity) {
            FixedCannonMountBlockEntity mount = (FixedCannonMountBlockEntity)blockEntity;
            mount.disassemble();
        }
        return resultType;
    }

    public Class<FixedCannonMountBlockEntity> getBlockEntityClass() {
        return FixedCannonMountBlockEntity.class;
    }

    public BlockEntityType<? extends FixedCannonMountBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CBCBlockEntities.FIXED_CANNON_MOUNT.get();
    }
}

