/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.cannon_control.cannon_mount;

import com.simibubi.create.content.kinetics.base.KineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.block.IBE;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import rbasamoyai.createbigcannons.cannon_control.cannon_mount.CannonMountBlockEntity;
import rbasamoyai.createbigcannons.index.CBCBlockEntities;

public class CannonMountBlock
extends KineticBlock
implements IBE<CannonMountBlockEntity> {
    public static final DirectionProperty HORIZONTAL_FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty ASSEMBLY_POWERED = BooleanProperty.m_61465_((String)"assembly_powered");
    public static final BooleanProperty FIRE_POWERED = BooleanProperty.m_61465_((String)"fire_powered");
    public static final DirectionProperty VERTICAL_DIRECTION = BlockStateProperties.f_155997_;

    public CannonMountBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)HORIZONTAL_FACING, (Comparable)Direction.NORTH)).m_61124_((Property)ASSEMBLY_POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FIRE_POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)VERTICAL_DIRECTION, (Comparable)Direction.DOWN));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{HORIZONTAL_FACING, ASSEMBLY_POWERED, FIRE_POWERED, VERTICAL_DIRECTION});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)HORIZONTAL_FACING, (Comparable)context.m_8125_())).m_61124_((Property)VERTICAL_DIRECTION, (Comparable)context.m_151260_());
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.m_61143_((Property)HORIZONTAL_FACING)).m_122434_() == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X;
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return face.m_122434_() == this.getRotationAxis(state) || face == state.m_61143_((Property)VERTICAL_DIRECTION);
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)HORIZONTAL_FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)HORIZONTAL_FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return (BlockState)state.m_61124_((Property)HORIZONTAL_FACING, (Comparable)mirror.m_54848_((Direction)state.m_61143_((Property)HORIZONTAL_FACING)));
    }

    public Class<CannonMountBlockEntity> getBlockEntityClass() {
        return CannonMountBlockEntity.class;
    }

    public BlockEntityType<? extends CannonMountBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CBCBlockEntities.CANNON_MOUNT.get();
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean isMoving) {
        if (!level.f_46443_ && !level.m_183326_().m_183588_(pos, (Object)this)) {
            level.m_186460_(pos, (Block)this, 0);
        }
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        boolean prevAssemblyPowered = (Boolean)state.m_61143_((Property)ASSEMBLY_POWERED);
        boolean prevFirePowered = (Boolean)state.m_61143_((Property)FIRE_POWERED);
        boolean assemblyPowered = this.hasNeighborSignal((Level)level, state, pos, ASSEMBLY_POWERED);
        boolean firePowered = this.hasNeighborSignal((Level)level, state, pos, FIRE_POWERED);
        Direction fireDirection = (Direction)state.m_61143_((Property)HORIZONTAL_FACING);
        int firePower = level.m_277185_(pos.m_121945_(fireDirection), fireDirection);
        this.withBlockEntityDo((BlockGetter)level, pos, cmbe -> cmbe.onRedstoneUpdate(assemblyPowered, prevAssemblyPowered, firePowered, prevFirePowered, firePower));
    }

    private boolean hasNeighborSignal(Level level, BlockState state, BlockPos pos, BooleanProperty property) {
        if (property == FIRE_POWERED) {
            Direction fireDirection = (Direction)state.m_61143_((Property)HORIZONTAL_FACING);
            return level.m_277185_(pos.m_121945_(fireDirection), fireDirection) > 0;
        }
        if (property == ASSEMBLY_POWERED) {
            Direction assemblyDirection = ((Direction)state.m_61143_((Property)HORIZONTAL_FACING)).m_122424_();
            return level.m_277185_(pos.m_121945_(assemblyDirection), assemblyDirection) > 0;
        }
        return false;
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.m_6807_(state, level, pos, oldState, isMoving);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof CannonMountBlockEntity) {
            CannonMountBlockEntity mount = (CannonMountBlockEntity)blockEntity;
            for (KineticBlockEntity kbe : mount.getAllKineticBlockEntities()) {
                kbe.preventSpeedUpdate = 0;
                if (oldState.m_60734_() != state.m_60734_() || state.m_155947_() != oldState.m_155947_() || !this.areStatesKineticallyEquivalent(oldState, state)) continue;
                kbe.preventSpeedUpdate = 2;
            }
        }
    }

    public void m_7742_(BlockState stateIn, LevelAccessor level, BlockPos pos, int flags, int count) {
        BlockEntity blockEntity;
        if (!level.m_5776_() && (blockEntity = level.m_7702_(pos)) instanceof CannonMountBlockEntity) {
            CannonMountBlockEntity mount = (CannonMountBlockEntity)blockEntity;
            mount.tryUpdatingSpeed();
        }
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        BlockEntity blockEntity;
        InteractionResult resultType = super.onWrenched(state, context);
        if (!context.m_43725_().f_46443_ && resultType.m_19077_() && (blockEntity = context.m_43725_().m_7702_(context.m_8083_())) instanceof CannonMountBlockEntity) {
            CannonMountBlockEntity mount = (CannonMountBlockEntity)blockEntity;
            mount.disassemble();
        }
        return resultType;
    }

    public BlockState getRotatedBlockState(BlockState originalState, Direction targetedFace) {
        BlockState newState = super.getRotatedBlockState(originalState, targetedFace);
        if (newState != originalState) {
            return newState;
        }
        if (targetedFace.m_122434_().m_122479_()) {
            return (BlockState)originalState.m_61122_((Property)VERTICAL_DIRECTION);
        }
        return originalState;
    }
}

