/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.liquid_blaze_burner;

import com.mrh0.createaddition.blocks.liquid_blaze_burner.LiquidBlazeBurnerBlock;
import com.mrh0.createaddition.index.CARecipes;
import com.mrh0.createaddition.network.IObserveTileEntity;
import com.mrh0.createaddition.network.ObservePacket;
import com.mrh0.createaddition.recipe.FluidRecipeWrapper;
import com.mrh0.createaddition.recipe.liquid_burning.LiquidBurningRecipe;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllTags;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.fluids.tank.FluidTankBlock;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class LiquidBlazeBurnerBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation,
IObserveTileEntity {
    public static final int MAX_HEAT_CAPACITY = 10000;
    protected FuelType activeFuel;
    protected int remainingBurnTime = 0;
    protected LerpedFloat headAnimation;
    protected LerpedFloat headAngle;
    protected boolean isCreative = false;
    protected boolean goggles = false;
    protected boolean hat;
    protected LazyOptional<IFluidHandler> fluidCapability;
    protected FluidTank tankInventory;
    private Optional<LiquidBurningRecipe> recipeCache = Optional.empty();
    private Fluid lastFluid = null;
    private int updateTimeout = 10;
    private boolean changed = true;
    public boolean first = true;

    public LiquidBlazeBurnerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.activeFuel = FuelType.NONE;
        this.headAnimation = LerpedFloat.linear();
        this.headAngle = LerpedFloat.angular();
        this.headAngle.startWithValue((double)((AngleHelper.horizontalAngle((Direction)state.m_61145_((Property)LiquidBlazeBurnerBlock.f_54117_).orElse(Direction.SOUTH)) + 180.0f) % 360.0f));
        this.tankInventory = this.createInventory();
        this.fluidCapability = LazyOptional.of(() -> this.tankInventory);
    }

    public void addBehaviours(List<BlockEntityBehaviour> list) {
    }

    protected SmartFluidTank createInventory() {
        return new SmartFluidTank(4000, this::onFluidStackChanged);
    }

    protected void onFluidStackChanged(FluidStack newFluidStack) {
        if (!this.m_58898_()) {
            return;
        }
        this.update(newFluidStack);
    }

    private void update(FluidStack stack) {
        if (this.f_58857_.m_5776_()) {
            return;
        }
        if (stack.getFluid() != this.lastFluid) {
            this.recipeCache = this.find(stack, this.f_58857_);
        }
        this.lastFluid = stack.getFluid();
        this.changed = true;
    }

    public Optional<LiquidBurningRecipe> find(FluidStack stack, Level level) {
        if (stack == null) {
            return Optional.empty();
        }
        if (level == null) {
            return Optional.empty();
        }
        if (CARecipes.LIQUID_BURNING_TYPE.get() == null) {
            return Optional.empty();
        }
        return level.m_7465_().m_44015_(CARecipes.LIQUID_BURNING_TYPE.get(), (Container)new FluidRecipeWrapper(stack), level);
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    public void burningTick() {
        if (this.f_58857_.m_5776_()) {
            return;
        }
        if (this.first) {
            this.update(this.tankInventory.getFluid());
        }
        this.first = false;
        if (this.remainingBurnTime < 1 && this.recipeCache.isEmpty()) {
            return;
        }
        if (this.tankInventory.getFluidAmount() < 100) {
            return;
        }
        if (this.remainingBurnTime > 10000) {
            return;
        }
        try {
            this.remainingBurnTime += this.recipeCache.get().getBurnTime() / 10;
            this.activeFuel = this.recipeCache.get().isSuperheated() ? FuelType.SPECIAL : FuelType.NORMAL;
        }
        catch (Exception e) {
            return;
        }
        this.tankInventory.drain(100, IFluidHandler.FluidAction.EXECUTE);
        BlazeBurnerBlock.HeatLevel prev = this.getHeatLevelFromBlock();
        this.playSound();
        this.updateBlockState();
        if (prev != this.getHeatLevelFromBlock()) {
            this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_11701_, SoundSource.BLOCKS, 0.125f + this.f_58857_.f_46441_.m_188501_() * 0.125f, 1.15f - this.f_58857_.f_46441_.m_188501_() * 0.25f);
            this.spawnParticleBurst(this.activeFuel == FuelType.SPECIAL);
        }
    }

    public FuelType getActiveFuel() {
        return this.activeFuel;
    }

    public int getRemainingBurnTime() {
        return this.remainingBurnTime;
    }

    public boolean isCreative() {
        return this.isCreative;
    }

    public void tick() {
        super.tick();
        if (this.f_58857_.f_46443_) {
            this.tickAnimation();
            if (!this.isVirtual()) {
                this.spawnParticles(this.getHeatLevelFromBlock(), 1.0);
            }
            return;
        }
        this.burningTick();
        if (this.isCreative) {
            return;
        }
        if (this.remainingBurnTime > 0) {
            --this.remainingBurnTime;
        }
        if (this.activeFuel == FuelType.NORMAL) {
            this.updateBlockState();
        }
        if (this.remainingBurnTime > 0) {
            return;
        }
        if (this.activeFuel == FuelType.SPECIAL) {
            this.activeFuel = FuelType.NORMAL;
            this.remainingBurnTime = 5000;
        } else {
            this.activeFuel = FuelType.NONE;
        }
        this.updateBlockState();
    }

    @OnlyIn(value=Dist.CLIENT)
    private void tickAnimation() {
        boolean active;
        boolean bl = active = this.getHeatLevelFromBlock().isAtLeast(BlazeBurnerBlock.HeatLevel.FADING) && this.isValidBlockAbove();
        if (!active) {
            float target = 0.0f;
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player != null && !player.m_20145_()) {
                double z;
                double x;
                if (this.isVirtual()) {
                    x = -4.0;
                    z = -10.0;
                } else {
                    x = player.m_20185_();
                    z = player.m_20189_();
                }
                double dx = x - ((double)this.m_58899_().m_123341_() + 0.5);
                double dz = z - ((double)this.m_58899_().m_123343_() + 0.5);
                target = AngleHelper.deg((double)(-Mth.m_14136_((double)dz, (double)dx))) - 90.0f;
            }
            target = this.headAngle.getValue() + AngleHelper.getShortestAngleDiff((double)this.headAngle.getValue(), (double)target);
            this.headAngle.chase((double)target, 0.25, LerpedFloat.Chaser.exp((double)5.0));
            this.headAngle.tickChaser();
        } else {
            this.headAngle.chase((double)((AngleHelper.horizontalAngle((Direction)this.m_58900_().m_61145_((Property)LiquidBlazeBurnerBlock.f_54117_).orElse(Direction.SOUTH)) + 180.0f) % 360.0f), 0.125, LerpedFloat.Chaser.EXP);
            this.headAngle.tickChaser();
        }
        this.headAnimation.chase(active ? 1.0 : 0.0, 0.25, LerpedFloat.Chaser.exp((double)0.25));
        this.headAnimation.tickChaser();
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        if (!this.isCreative) {
            compound.m_128405_("fuelLevel", this.activeFuel.ordinal());
            compound.m_128405_("burnTimeRemaining", this.remainingBurnTime);
        } else {
            compound.m_128379_("isCreative", true);
        }
        if (this.goggles) {
            compound.m_128379_("Goggles", true);
        }
        if (this.hat) {
            compound.m_128379_("TrainHat", true);
        }
        compound.m_128365_("TankContent", (Tag)this.tankInventory.writeToNBT(new CompoundTag()));
        super.write(compound, clientPacket);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        this.activeFuel = FuelType.values()[compound.m_128451_("fuelLevel")];
        this.remainingBurnTime = compound.m_128451_("burnTimeRemaining");
        this.isCreative = compound.m_128471_("isCreative");
        this.goggles = compound.m_128441_("Goggles");
        this.hat = compound.m_128441_("TrainHat");
        this.tankInventory.readFromNBT(compound.m_128469_("TankContent"));
        super.read(compound, clientPacket);
    }

    public BlazeBurnerBlock.HeatLevel getHeatLevelFromBlock() {
        return BlazeBurnerBlock.getHeatLevelOf((BlockState)this.m_58900_());
    }

    public void updateBlockState() {
        this.setBlockHeat(this.getHeatLevelFromFuelType(this.activeFuel));
    }

    protected void setBlockHeat(BlazeBurnerBlock.HeatLevel heat) {
        BlazeBurnerBlock.HeatLevel inBlockState = this.getHeatLevelFromBlock();
        if (inBlockState == heat) {
            return;
        }
        this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_(LiquidBlazeBurnerBlock.HEAT_LEVEL, (Comparable)heat));
        this.notifyUpdate();
    }

    private boolean tryUpdateLiquid(ItemStack itemStack, boolean simulate) {
        LazyOptional cap = itemStack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM);
        if (!cap.isPresent()) {
            return false;
        }
        IFluidHandlerItem handler = (IFluidHandlerItem)cap.orElse(null);
        if (handler.getFluidInTank(0).isEmpty()) {
            return false;
        }
        FluidStack stack = handler.getFluidInTank(0);
        Optional<LiquidBurningRecipe> recipe = this.find(stack, this.f_58857_);
        if (!recipe.isPresent()) {
            return false;
        }
        LazyOptional tecap = this.getCapability(ForgeCapabilities.FLUID_HANDLER);
        if (!tecap.isPresent()) {
            return false;
        }
        IFluidHandler tehandler = (IFluidHandler)tecap.orElse(null);
        if (tehandler.getTankCapacity(0) - tehandler.getFluidInTank(0).getAmount() < 1000) {
            return false;
        }
        if (!simulate) {
            tehandler.fill(new FluidStack(handler.getFluidInTank(0).getFluid(), 1000), IFluidHandler.FluidAction.EXECUTE);
        }
        if (!simulate) {
            this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_11778_, SoundSource.BLOCKS, 0.125f + this.f_58857_.f_46441_.m_188501_() * 0.125f, 0.75f - this.f_58857_.f_46441_.m_188501_() * 0.25f);
        }
        return true;
    }

    protected boolean tryUpdateFuel(ItemStack itemStack, boolean forceOverflow, boolean simulate) {
        int newBurnTime;
        if (this.isCreative) {
            return false;
        }
        FuelType newFuel = FuelType.NONE;
        if (this.tryUpdateLiquid(itemStack, simulate)) {
            return true;
        }
        if (AllTags.AllItemTags.BLAZE_BURNER_FUEL_SPECIAL.matches(itemStack)) {
            newBurnTime = 1000;
            newFuel = FuelType.SPECIAL;
        } else {
            newBurnTime = ForgeHooks.getBurnTime((ItemStack)itemStack, null);
            if (newBurnTime > 0) {
                newFuel = FuelType.NORMAL;
            } else if (AllTags.AllItemTags.BLAZE_BURNER_FUEL_REGULAR.matches(itemStack)) {
                newBurnTime = 1600;
                newFuel = FuelType.NORMAL;
            }
        }
        if (newFuel == FuelType.NONE) {
            return false;
        }
        if (newFuel.ordinal() < this.activeFuel.ordinal()) {
            return false;
        }
        if (this.activeFuel == FuelType.SPECIAL && this.remainingBurnTime > 20) {
            return false;
        }
        if (newFuel == this.activeFuel) {
            if (this.remainingBurnTime + newBurnTime > 10000 && !forceOverflow) {
                return false;
            }
            newBurnTime = Mth.m_14045_((int)(this.remainingBurnTime + newBurnTime), (int)0, (int)10000);
        }
        if (simulate) {
            return true;
        }
        this.activeFuel = newFuel;
        this.remainingBurnTime = newBurnTime;
        if (this.f_58857_.f_46443_) {
            this.spawnParticleBurst(this.activeFuel == FuelType.SPECIAL);
            return true;
        }
        BlazeBurnerBlock.HeatLevel prev = this.getHeatLevelFromBlock();
        this.playSound();
        this.updateBlockState();
        if (prev != this.getHeatLevelFromBlock()) {
            this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_11701_, SoundSource.BLOCKS, 0.125f + this.f_58857_.f_46441_.m_188501_() * 0.125f, 1.15f - this.f_58857_.f_46441_.m_188501_() * 0.25f);
        }
        return true;
    }

    protected void applyCreativeFuel() {
        this.activeFuel = FuelType.NONE;
        this.remainingBurnTime = 0;
        this.isCreative = true;
        BlazeBurnerBlock.HeatLevel next = this.getHeatLevelFromBlock().nextActiveLevel();
        if (this.f_58857_.f_46443_) {
            this.spawnParticleBurst(next.isAtLeast(BlazeBurnerBlock.HeatLevel.SEETHING));
            return;
        }
        this.playSound();
        if (next == BlazeBurnerBlock.HeatLevel.FADING) {
            next = next.nextActiveLevel();
        }
        this.setBlockHeat(next);
    }

    public boolean isCreativeFuel(ItemStack stack) {
        return AllItems.CREATIVE_BLAZE_CAKE.isIn(stack);
    }

    public boolean isValidBlockAbove() {
        BlockState blockState = this.f_58857_.m_8055_(this.f_58858_.m_7494_());
        return AllBlocks.BASIN.has(blockState) || blockState.m_60734_() instanceof FluidTankBlock;
    }

    protected void playSound() {
        this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_11705_, SoundSource.BLOCKS, 0.125f + this.f_58857_.f_46441_.m_188501_() * 0.125f, 0.75f - this.f_58857_.f_46441_.m_188501_() * 0.25f);
    }

    protected BlazeBurnerBlock.HeatLevel getHeatLevelFromFuelType(FuelType fuel) {
        BlazeBurnerBlock.HeatLevel level = BlazeBurnerBlock.HeatLevel.SMOULDERING;
        switch (this.activeFuel) {
            case SPECIAL: {
                level = BlazeBurnerBlock.HeatLevel.SEETHING;
                break;
            }
            case NORMAL: {
                boolean lowPercent = (double)this.remainingBurnTime / 10000.0 < 0.0125;
                level = lowPercent ? BlazeBurnerBlock.HeatLevel.FADING : BlazeBurnerBlock.HeatLevel.KINDLED;
                break;
            }
        }
        return level;
    }

    protected void spawnParticles(BlazeBurnerBlock.HeatLevel heatLevel, double burstMult) {
        if (this.f_58857_ == null) {
            return;
        }
        if (heatLevel == BlazeBurnerBlock.HeatLevel.NONE) {
            return;
        }
        RandomSource r = this.f_58857_.m_213780_();
        Vec3 c = VecHelper.getCenterOf((Vec3i)this.f_58858_);
        Vec3 v = c.m_82549_(VecHelper.offsetRandomly((Vec3)Vec3.f_82478_, (RandomSource)r, (float)0.125f).m_82542_(1.0, 0.0, 1.0));
        if (r.m_188503_(3) == 0) {
            this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123755_, v.f_82479_, v.f_82480_, v.f_82481_, 0.0, 0.0, 0.0);
        }
        if (r.m_188503_(2) != 0) {
            return;
        }
        boolean empty = this.f_58857_.m_8055_(this.f_58858_.m_7494_()).m_60812_((BlockGetter)this.f_58857_, this.f_58858_.m_7494_()).m_83281_();
        double yMotion = empty ? 0.0625 : r.m_188500_() * (double)0.0125f;
        Vec3 v2 = c.m_82549_(VecHelper.offsetRandomly((Vec3)Vec3.f_82478_, (RandomSource)r, (float)0.5f).m_82542_(1.0, 0.25, 1.0).m_82541_().m_82490_((empty ? 0.25 : 0.5) + r.m_188500_() * 0.125)).m_82520_(0.0, 0.5, 0.0);
        if (heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.SEETHING)) {
            this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123745_, v2.f_82479_, v2.f_82480_, v2.f_82481_, 0.0, yMotion, 0.0);
        } else if (heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.FADING)) {
            this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123744_, v2.f_82479_, v2.f_82480_, v2.f_82481_, 0.0, yMotion, 0.0);
        }
    }

    public void spawnParticleBurst(boolean soulFlame) {
        Vec3 c = VecHelper.getCenterOf((Vec3i)this.f_58858_);
        RandomSource r = this.f_58857_.f_46441_;
        for (int i = 0; i < 20; ++i) {
            Vec3 offset = VecHelper.offsetRandomly((Vec3)Vec3.f_82478_, (RandomSource)r, (float)0.5f).m_82542_(1.0, 0.25, 1.0).m_82541_();
            Vec3 v = c.m_82549_(offset.m_82490_(0.5 + r.m_188500_() * 0.125)).m_82520_(0.0, 0.125, 0.0);
            Vec3 m = offset.m_82490_(0.03125);
            this.f_58857_.m_7106_((ParticleOptions)(soulFlame ? ParticleTypes.f_123745_ : ParticleTypes.f_123744_), v.f_82479_, v.f_82480_, v.f_82481_, m.f_82479_, m.f_82480_, m.f_82481_);
        }
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        ObservePacket.send(this.f_58858_, 0);
        return this.containedFluidTooltip(tooltip, isPlayerSneaking, this.getCapability(ForgeCapabilities.FLUID_HANDLER));
    }

    @Override
    public void onObserved(ServerPlayer player, ObservePacket pack) {
        this.notifyUpdate();
    }

    public static enum FuelType {
        NONE,
        NORMAL,
        SPECIAL;

    }
}

