/*
 * Decompiled with CFR 0.152.
 */
package com.happysg.radar.compat.computercraft;

import com.happysg.radar.CreateRadar;
import com.happysg.radar.block.radar.bearing.RadarBearingBlockEntity;
import com.happysg.radar.block.radar.track.RadarTrack;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.GenericPeripheral;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.phys.Vec3;

public class RadarBearingPeripheral
implements GenericPeripheral {
    public String id() {
        return CreateRadar.asResource("radar").toString();
    }

    @LuaFunction(mainThread=true)
    public static List<Map<? super String, Object>> getTracks(RadarBearingBlockEntity radarEntity) {
        ArrayList<Map<? super String, Object>> tracks = new ArrayList<Map<? super String, Object>>();
        for (RadarTrack track : radarEntity.getTracks()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("position", RadarBearingPeripheral.getMapFromVector(track.position()));
            map.put("velocity", RadarBearingPeripheral.getMapFromVector(track.velocity()));
            map.put("category", track.trackCategory().toString());
            map.put("id", track.id());
            map.put("scannedTime", track.scannedTime());
            map.put("entityType", track.entityType());
            tracks.add(map);
        }
        return tracks;
    }

    @LuaFunction(mainThread=true)
    public static HashMap<String, Double> getPosition(RadarBearingBlockEntity radarEntity) {
        return RadarBearingPeripheral.getMapFromVector(radarEntity.getWorldPos().m_252807_());
    }

    @LuaFunction(mainThread=true)
    public static double getRotation(RadarBearingBlockEntity radarEntity) {
        return radarEntity.getAngle();
    }

    @LuaFunction(mainThread=true)
    public static double getRotationSpeed(RadarBearingBlockEntity radarEntity) {
        return radarEntity.getAngularSpeed();
    }

    @LuaFunction(mainThread=true)
    public static double getRange(RadarBearingBlockEntity radarEntity) {
        return radarEntity.getRange();
    }

    @LuaFunction(mainThread=true)
    public static int getDishCount(RadarBearingBlockEntity radarEntity) {
        return radarEntity.getDishCount();
    }

    public static HashMap<String, Double> getMapFromVector(Vec3 vector) {
        HashMap<String, Double> vectorMap = new HashMap<String, Double>();
        vectorMap.put("x", vector.f_82479_);
        vectorMap.put("y", vector.f_82480_);
        vectorMap.put("z", vector.f_82481_);
        return vectorMap;
    }
}

