/*
 * Decompiled with CFR 0.152.
 */
package com.happysg.radar.compat.cbc;

import com.happysg.radar.compat.cbc.CannonUtil;
import com.happysg.radar.compat.cbc.VS2TargetingSolver;
import com.simibubi.create.content.contraptions.Contraption;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3d;
import org.valkyrienskies.core.api.ships.LoadedShip;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import rbasamoyai.createbigcannons.cannon_control.cannon_mount.CannonMountBlockEntity;
import rbasamoyai.createbigcannons.cannon_control.contraption.AbstractMountedCannonContraption;
import rbasamoyai.createbigcannons.cannon_control.contraption.PitchOrientedContraptionEntity;

public class VS2CannonTargeting {
    public static List<List<Double>> calculatePitchAndYawVS2(CannonMountBlockEntity mount, Vec3 targetPos, ServerLevel level) {
        Contraption contraption;
        if (mount == null || targetPos == null) {
            return null;
        }
        PitchOrientedContraptionEntity contraption2 = mount.getContraption();
        if (contraption2 == null || !((contraption = contraption2.getContraption()) instanceof AbstractMountedCannonContraption)) {
            return null;
        }
        AbstractMountedCannonContraption cannonContraption = (AbstractMountedCannonContraption)contraption;
        float chargePower = CannonUtil.getInitialVelocity(cannonContraption, level);
        Vec3 mountPos = mount.m_58899_().m_252807_();
        int barrelLength = CannonUtil.getBarrelLength(cannonContraption);
        Direction initialDirection = cannonContraption.initialOrientation();
        double drag = CannonUtil.getProjectileDrag(cannonContraption, level);
        double gravity = CannonUtil.getProjectileGravity(cannonContraption, level);
        return VS2CannonTargeting.calculatePitchAndYawVS2((Level)level, chargePower, targetPos, mountPos, barrelLength, initialDirection, drag, gravity);
    }

    public static List<List<Double>> calculatePitchAndYawVS2(Level level, double speed, Vec3 targetPos, Vec3 mountPos, int barrelLength, Direction initialDirection, double drag, double gravity) {
        LoadedShip ship = VSGameUtilsKt.getShipObjectManagingPos((Level)level, (double)mountPos.f_82479_, (double)mountPos.f_82480_, (double)mountPos.f_82481_);
        if (ship == null) {
            System.out.println("null");
            return null;
        }
        Vector3d eulerAngles = new Vector3d();
        ship.getTransform().getShipToWorldRotation().getEulerAnglesYXZ(eulerAngles);
        double x = eulerAngles.x;
        double z = eulerAngles.z;
        double initialZeta = -eulerAngles.y;
        double initialPsi = 0.0;
        double initialTheta = 0.0;
        if (initialDirection == Direction.NORTH) {
            initialPsi = -z;
            initialTheta = x;
        } else if (initialDirection == Direction.SOUTH) {
            initialPsi = z;
            initialTheta = -x;
        } else if (initialDirection == Direction.EAST) {
            initialPsi = x;
            initialTheta = z;
        } else if (initialDirection == Direction.WEST) {
            initialPsi = -x;
            initialTheta = -z;
        }
        VS2TargetingSolver targetingSolver = new VS2TargetingSolver(level, speed, drag, gravity, barrelLength, mountPos, targetPos, initialTheta, initialZeta, initialPsi, (Ship)ship);
        return targetingSolver.solveThetaZeta();
    }
}

