/*
 * Decompiled with CFR 0.152.
 */
package com.happysg.radar.block.radar.bearing;

import com.happysg.radar.block.radar.bearing.RadarBearingBlock;
import com.happysg.radar.block.radar.bearing.RadarContraption;
import com.happysg.radar.block.radar.behavior.IRadar;
import com.happysg.radar.block.radar.behavior.RadarScanningBlockBehavior;
import com.happysg.radar.block.radar.track.RadarTrack;
import com.happysg.radar.compat.vs2.PhysicsHandler;
import com.happysg.radar.config.RadarConfig;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.api.stress.BlockStressValues;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.AssemblyException;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.ControlledContraptionEntity;
import com.simibubi.create.content.contraptions.IControlContraption;
import com.simibubi.create.content.contraptions.bearing.MechanicalBearingBlockEntity;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.ServerSpeedProvider;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class RadarBearingBlockEntity
extends MechanicalBearingBlockEntity
implements IRadar {
    private int dishCount;
    private boolean creative;
    private Direction receiverFacing = Direction.NORTH;
    private RadarScanningBlockBehavior scanningBehavior;

    public RadarBearingBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.movementMode.setValue(IControlContraption.MovementMode.MOVE_NEVER_PLACE.ordinal());
        this.scanningBehavior = new RadarScanningBlockBehavior((SmartBlockEntity)this);
        behaviours.add(this.scanningBehavior);
    }

    @Override
    public BlockPos getWorldPos() {
        return this.m_58899_();
    }

    public void tick() {
        super.tick();
        if (this.running) {
            this.scanningBehavior.setRange(this.getRange());
            this.scanningBehavior.setAngle(this.getGlobalAngle());
        }
    }

    @Override
    public float getGlobalAngle() {
        Vec3 receiverVector = new Vec3((double)this.receiverFacing.m_122429_(), (double)this.receiverFacing.m_122430_(), (double)this.receiverFacing.m_122431_());
        float receiverAngle = (float)Math.toDegrees(Math.atan2(receiverVector.f_82479_, receiverVector.f_82481_));
        return (receiverAngle + this.angle + 360.0f) % 360.0f;
    }

    public float getAngularSpeed() {
        if (!((Boolean)RadarConfig.server().gearRadarBearingSpeed.get()).booleanValue()) {
            return super.getAngularSpeed();
        }
        float speed = RadarBearingBlockEntity.convertToAngular((float)this.getSpeed());
        if (this.getSpeed() == 0.0f) {
            speed = 0.0f;
        }
        if (this.f_58857_.f_46443_) {
            speed *= ServerSpeedProvider.get();
            speed += this.clientAngleDiff / 3.0f;
        }
        return speed / (4.0f + (float)(this.getDishCount() / 10));
    }

    public void assemble() {
        if (!(this.f_58857_.m_8055_(this.m_58899_()).m_60734_() instanceof RadarBearingBlock)) {
            return;
        }
        RadarContraption contraption = this.createContraption();
        if (contraption == null) {
            return;
        }
        if (this.isWindmill()) {
            this.award(AllAdvancements.WINDMILL);
        }
        if (contraption.getSailBlocks() >= 128) {
            this.award(AllAdvancements.WINDMILL_MAXED);
        }
        this.updateGeneratedRotation();
        this.updateContraptionData();
        this.notifyUpdate();
    }

    public void disassemble() {
        super.disassemble();
        this.updateContraptionData();
    }

    public float calculateStressApplied() {
        float impact;
        this.lastStressApplied = impact = (float)BlockStressValues.getImpact((Block)this.getStressConfigKey()) + (float)this.getDishCount();
        return impact;
    }

    private RadarContraption createContraption() {
        RadarContraption contraption = new RadarContraption();
        try {
            if (!contraption.assemble(this.f_58857_, this.m_58899_())) {
                return null;
            }
            this.lastException = null;
        }
        catch (AssemblyException e) {
            this.lastException = e;
            this.sendData();
            return null;
        }
        contraption.removeBlocksFromWorld(this.f_58857_, BlockPos.f_121853_);
        this.movedContraption = ControlledContraptionEntity.create((Level)this.f_58857_, (IControlContraption)this, (Contraption)contraption);
        BlockPos anchor = this.getBlockPosition().m_7494_();
        this.movedContraption.m_6034_((double)anchor.m_123341_(), (double)anchor.m_123342_(), (double)anchor.m_123343_());
        this.movedContraption.setRotationAxis(Direction.Axis.Y);
        this.f_58857_.m_7967_((Entity)this.movedContraption);
        AllSoundEvents.CONTRAPTION_ASSEMBLE.playOnServer(this.f_58857_, (Vec3i)this.m_58899_());
        this.running = true;
        this.angle = 0.0f;
        return contraption;
    }

    private void updateContraptionData() {
        this.dishCount = this.getContraption().map(RadarContraption::getDishCount).orElse(0);
        this.receiverFacing = this.getContraption().map(RadarContraption::getReceiverFacing).orElse(Direction.NORTH);
        this.creative = this.getContraption().map(RadarContraption::isCreative).orElse(false);
        this.scanningBehavior.setRange(this.getRange());
        this.scanningBehavior.setScanPos(PhysicsHandler.getWorldVec((BlockEntity)this));
        this.scanningBehavior.setRunning(this.running);
        this.scanningBehavior.setAngle(this.getGlobalAngle());
        this.notifyUpdate();
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        tooltip.add((Component)Component.m_237110_((String)"create_radar.radar.dish_count", (Object[])new Object[]{this.dishCount}));
        tooltip.add((Component)Component.m_237110_((String)"create_radar.radar.range", (Object[])new Object[]{Float.valueOf(this.getRange())}));
        return true;
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.dishCount = compound.m_128451_("dishCount");
        this.creative = compound.m_128471_("creative");
        if (compound.m_128441_("receiverFacing")) {
            this.receiverFacing = Direction.m_122376_((int)compound.m_128451_("receiverFacing"));
        }
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128405_("dishCount", this.dishCount);
        compound.m_128379_("creative", this.creative);
        if (this.receiverFacing != null) {
            compound.m_128405_("receiverFacing", this.receiverFacing.m_122411_());
        }
    }

    public int getDishCount() {
        return this.dishCount;
    }

    public Optional<RadarContraption> getContraption() {
        return Optional.ofNullable(this.movedContraption).map(AbstractContraptionEntity::getContraption).filter(c -> c instanceof RadarContraption).map(c -> (RadarContraption)((Object)c));
    }

    public float getAngle() {
        return this.angle;
    }

    public Direction getReceiverFacing() {
        return this.receiverFacing;
    }

    @Override
    public float getRange() {
        if (this.creative) {
            return ((Integer)RadarConfig.server().maxRadarRange.get()).intValue();
        }
        return Math.min((Integer)RadarConfig.server().radarBaseRange.get() + this.dishCount * (Integer)RadarConfig.server().dishRangeIncrease.get(), (Integer)RadarConfig.server().maxRadarRange.get());
    }

    @Override
    public Collection<RadarTrack> getTracks() {
        return this.scanningBehavior.getRadarTracks();
    }
}

