/*
 * Decompiled with CFR 0.152.
 */
package com.happysg.radar.block.monitor;

import com.happysg.radar.block.monitor.MonitorBlock;
import com.happysg.radar.block.monitor.MonitorBlockEntity;
import com.happysg.radar.block.monitor.MonitorFilter;
import com.happysg.radar.block.monitor.MonitorSprite;
import com.happysg.radar.block.radar.behavior.IRadar;
import com.happysg.radar.block.radar.track.RadarTrack;
import com.happysg.radar.compat.vs2.PhysicsHandler;
import com.happysg.radar.config.RadarConfig;
import com.happysg.radar.registry.ModRenderTypes;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.renderer.SmartBlockEntityRenderer;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.createmod.catnip.theme.Color;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class MonitorRenderer
extends SmartBlockEntityRenderer<MonitorBlockEntity> {
    private static final float DEPTH_BACKGROUND = 0.94f;
    private static final float DEPTH_GRID = 0.945f;
    private static final float DEPTH_SWEEP = 0.947f;
    private static final float DEPTH_TRACK_BASE = 0.95f;
    private static final float DEPTH_TRACK_INCREMENT = 1.0E-4f;
    private static final float ALPHA_BACKGROUND = 0.6f;
    private static final float ALPHA_GRID = 0.5f;
    private static final float ALPHA_SWEEP = 0.8f;
    private static final float TRACK_POSITION_SCALE = 0.75f;

    public MonitorRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(MonitorBlockEntity blockEntity, float partialTicks, PoseStack ms, MultiBufferSource bufferSource, int light, int overlay) {
        super.renderSafe((SmartBlockEntity)blockEntity, partialTicks, ms, bufferSource, light, overlay);
        if (!blockEntity.isController()) {
            return;
        }
        this.setupMonitorTransform(ms, (Direction)blockEntity.m_58900_().m_61143_((Property)MonitorBlock.f_54117_));
        blockEntity.getRadar().ifPresent(radar -> {
            if (!radar.isRunning()) {
                return;
            }
            this.renderRadarDisplay((IRadar)radar, blockEntity, ms, bufferSource, partialTicks);
        });
    }

    private void setupMonitorTransform(PoseStack ms, Direction direction) {
        ms.m_85837_(0.5, 0.5, 0.5);
        ms.m_252781_(Axis.f_252392_.m_252977_(direction.m_122435_()));
        ms.m_85837_(-0.5, -0.5, -0.5);
        ms.m_85837_(0.5, 0.5, 0.5);
        ms.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        ms.m_85837_(-0.5, -0.5, -0.5);
    }

    private void renderRadarDisplay(IRadar radar, MonitorBlockEntity blockEntity, PoseStack ms, MultiBufferSource bufferSource, float partialTicks) {
        this.renderGrid(radar, blockEntity, ms, bufferSource);
        this.renderSafeZones(radar, blockEntity, ms, bufferSource);
        this.renderBG(blockEntity, ms, bufferSource, MonitorSprite.RADAR_BG_FILLER);
        this.renderBG(blockEntity, ms, bufferSource, MonitorSprite.RADAR_BG_CIRCLE);
        this.renderSweep(radar, blockEntity, ms, bufferSource, partialTicks);
        this.renderRadarTracks(radar, blockEntity, ms, bufferSource);
    }

    private void renderSafeZones(IRadar radar, MonitorBlockEntity blockEntity, PoseStack ms, MultiBufferSource bufferSource) {
        List<AABB> safeZones = blockEntity.safeZones;
        if (safeZones == null || safeZones.isEmpty()) {
            return;
        }
        int size = blockEntity.getSize();
        float range = radar.getRange();
        Direction facing = (Direction)blockEntity.m_58900_().m_61143_((Property)MonitorBlock.f_54117_);
        Matrix4f m = ms.m_85850_().m_252922_();
        Matrix3f n = ms.m_85850_().m_252943_();
        Color color = new Color(3685186);
        float alpha = 0.4f;
        for (AABB zone : safeZones) {
            Vec3 zoneMin = this.transformWorldToRadar(zone.f_82288_, zone.f_82289_, zone.f_82290_, radar, blockEntity, facing, range, size);
            Vec3 zoneMax = this.transformWorldToRadar(zone.f_82291_, zone.f_82292_, zone.f_82293_, radar, blockEntity, facing, range, size);
            if (this.isOutsideDisplay(zoneMin) && this.isOutsideDisplay(zoneMax)) continue;
            VertexConsumer buffer = bufferSource.m_6299_(RenderType.m_110504_());
            this.renderZoneOutline(buffer, m, n, zoneMin, zoneMax, color, alpha);
        }
    }

    private void renderZoneOutline(VertexConsumer buffer, Matrix4f m, Matrix3f n, Vec3 min, Vec3 max, Color color, float alpha) {
        float r = color.getRedAsFloat();
        float g = color.getGreenAsFloat();
        float b = color.getBlueAsFloat();
        this.renderLine(buffer, m, n, (float)min.f_82479_, 0.945f, (float)min.f_82481_, (float)max.f_82479_, 0.945f, (float)min.f_82481_, r, g, b, alpha);
        this.renderLine(buffer, m, n, (float)max.f_82479_, 0.945f, (float)min.f_82481_, (float)max.f_82479_, 0.945f, (float)max.f_82481_, r, g, b, alpha);
        this.renderLine(buffer, m, n, (float)max.f_82479_, 0.945f, (float)max.f_82481_, (float)min.f_82479_, 0.945f, (float)max.f_82481_, r, g, b, alpha);
        this.renderLine(buffer, m, n, (float)min.f_82479_, 0.945f, (float)max.f_82481_, (float)min.f_82479_, 0.945f, (float)min.f_82481_, r, g, b, alpha);
    }

    private void renderLine(VertexConsumer buffer, Matrix4f matrix, Matrix3f normal, float x1, float y1, float z1, float x2, float y2, float z2, float r, float g, float b, float alpha) {
        buffer.m_252986_(matrix, x1, y1, z1).m_85950_(r, g, b, alpha).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix, x2, y2, z2).m_85950_(r, g, b, alpha).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    private void renderGrid(IRadar radar, MonitorBlockEntity blockEntity, PoseStack ms, MultiBufferSource bufferSource) {
        int size = blockEntity.getSize();
        float range = radar.getRange();
        float gridSpacing = range * 2.0f / (float)((Integer)RadarConfig.client().gridBoxScale.get()).intValue();
        VertexConsumer buffer = bufferSource.m_6299_(RenderType.m_110473_((ResourceLocation)MonitorSprite.GRID_SQUARE.getTexture()));
        Matrix4f m = ms.m_85850_().m_252922_();
        Matrix3f n = ms.m_85850_().m_252943_();
        Color color = new Color(((Integer)RadarConfig.client().groundRadarColor.get()).intValue());
        float xmin = 1 - size;
        float zmin = 1 - size;
        float xmax = 1.0f;
        float zmax = 1.0f;
        float u0 = -0.5f * gridSpacing;
        float v0 = -0.5f * gridSpacing;
        float u1 = 0.5f * gridSpacing;
        float v1 = -0.5f * gridSpacing;
        float u2 = 0.5f * gridSpacing;
        float v2 = 0.5f * gridSpacing;
        float u3 = -0.5f * gridSpacing;
        float v3 = 0.5f * gridSpacing;
        buffer.m_252986_(m, xmin, 0.945f, zmin).m_85950_(color.getRedAsFloat(), color.getGreenAsFloat(), color.getBlueAsFloat(), 0.5f).m_7421_(u0, v0).m_86008_(OverlayTexture.f_118083_).m_85969_(255).m_252939_(n, 0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(m, xmax, 0.945f, zmin).m_85950_(color.getRedAsFloat(), color.getGreenAsFloat(), color.getBlueAsFloat(), 0.5f).m_7421_(u1, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(255).m_252939_(n, 0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(m, xmax, 0.945f, zmax).m_85950_(color.getRedAsFloat(), color.getGreenAsFloat(), color.getBlueAsFloat(), 0.5f).m_7421_(u2, v2).m_86008_(OverlayTexture.f_118083_).m_85969_(255).m_252939_(n, 0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(m, xmin, 0.945f, zmax).m_85950_(color.getRedAsFloat(), color.getGreenAsFloat(), color.getBlueAsFloat(), 0.5f).m_7421_(u3, v3).m_86008_(OverlayTexture.f_118083_).m_85969_(255).m_252939_(n, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    private void renderRadarTracks(IRadar radar, MonitorBlockEntity monitor, PoseStack ms, MultiBufferSource bufferSource) {
        AtomicInteger depthCounter = new AtomicInteger(0);
        for (RadarTrack track : monitor.getTracks()) {
            this.renderTrack(track, monitor, radar, ms, bufferSource, depthCounter.getAndIncrement());
        }
    }

    private void renderTrack(RadarTrack track, MonitorBlockEntity monitor, IRadar radar, PoseStack ms, MultiBufferSource bufferSource, int depthMultiplier) {
        Direction monitorFacing = (Direction)monitor.m_58900_().m_61143_((Property)MonitorBlock.f_54117_);
        float scale = radar.getRange();
        int size = monitor.getSize();
        Vec3 radarPos = PhysicsHandler.getWorldPos(monitor.m_58904_(), radar.getWorldPos()).m_252807_();
        Vec3 relativePos = track.position().m_82546_(radarPos);
        if (radar.renderRelativeToMonitor()) {
            // empty if block
        }
        float xOff = this.calculateTrackOffset(relativePos, monitorFacing, scale, true);
        float zOff = this.calculateTrackOffset(relativePos, monitorFacing, scale, false);
        if (Math.abs(xOff) > 0.5f || Math.abs(zOff) > 0.5f) {
            return;
        }
        float xmin = (float)(1 - size) + (xOff *= 0.75f) * (float)size;
        float zmin = (float)(1 - size) + (zOff *= 0.75f) * (float)size;
        float xmax = xOff * (float)size + 1.0f;
        float zmax = zOff * (float)size + 1.0f;
        float depth = 0.95f + (float)depthMultiplier * 1.0E-4f;
        long currentTime = monitor.m_58904_().m_46467_();
        float trackAge = currentTime - track.scannedTime();
        float fadeTime = 100.0f;
        float fade = Math.min(1.0f, trackAge / fadeTime);
        float alpha = 1.0f - fade;
        MonitorFilter filter = monitor.filter;
        Color color = filter.getColor(track);
        VertexConsumer buffer = this.getBuffer(bufferSource, track.getSprite());
        Matrix4f m = ms.m_85850_().m_252922_();
        Matrix3f n = ms.m_85850_().m_252943_();
        this.renderVertices(buffer, m, n, color, alpha, depth, xmin, zmin, xmax, zmax);
        if (track.id().equals(monitor.hoveredEntity)) {
            this.renderVertices(this.getBuffer(bufferSource, MonitorSprite.TARGET_HOVERED), m, n, new Color(255, 255, 0), alpha, depth - 1.0E-4f, xmin, zmin, xmax, zmax);
        }
        if (track.id().equals(monitor.selectedEntity)) {
            this.renderVertices(this.getBuffer(bufferSource, MonitorSprite.TARGET_SELECTED), m, n, new Color(255, 0, 0), alpha, depth - 2.0E-4f, xmin, zmin, xmax, zmax);
        }
    }

    private float calculateTrackOffset(Vec3 relativePos, Direction monitorFacing, float scale, boolean isXOffset) {
        float offset;
        if (isXOffset) {
            float f = offset = monitorFacing.m_122434_() == Direction.Axis.Z ? this.getOffset(relativePos.m_7096_(), scale) : this.getOffset(relativePos.m_7094_(), scale);
            if (monitorFacing == Direction.NORTH || monitorFacing == Direction.EAST) {
                offset = -offset;
            }
        } else {
            float f = offset = monitorFacing.m_122434_() == Direction.Axis.Z ? this.getOffset(relativePos.m_7094_(), scale) : this.getOffset(relativePos.m_7096_(), scale);
            if (monitorFacing == Direction.NORTH || monitorFacing == Direction.WEST) {
                offset = -offset;
            }
        }
        return offset;
    }

    private float getOffset(double coordinate, float scale) {
        return (float)(coordinate / (double)scale) / 2.0f;
    }

    private boolean isOutsideDisplay(Vec3 point) {
        return Math.abs(point.f_82479_) > 0.5 || Math.abs(point.f_82481_) > 0.5;
    }

    private Vec3 transformWorldToRadar(double x, double y, double z, IRadar radar, MonitorBlockEntity monitor, Direction facing, float range, int size) {
        Vec3 radarPos = PhysicsHandler.getWorldPos(monitor.m_58904_(), radar.getWorldPos()).m_252807_();
        Vec3 relativePos = new Vec3(x, y, z).m_82546_(radarPos);
        float xOff = this.calculateTrackOffset(relativePos, facing, range, true) * 0.75f;
        float zOff = this.calculateTrackOffset(relativePos, facing, range, false) * 0.75f;
        float displayX = (float)(1 - size) + xOff * (float)size;
        float displayZ = (float)(1 - size) + zOff * (float)size;
        return new Vec3((double)displayX, (double)0.945f, (double)displayZ);
    }

    private VertexConsumer getBuffer(MultiBufferSource bufferSource, MonitorSprite sprite) {
        return bufferSource.m_6299_(ModRenderTypes.polygonOffset(sprite.getTexture()));
    }

    private void renderVertices(VertexConsumer buffer, Matrix4f m, Matrix3f n, Color color, float alpha, float depth, float xmin, float zmin, float xmax, float zmax) {
        float u0 = 0.0f;
        float v0 = 0.0f;
        float u1 = 1.0f;
        float v1 = 0.0f;
        float u2 = 1.0f;
        float v2 = 1.0f;
        float u3 = 0.0f;
        float v3 = 1.0f;
        float r = color.getRedAsFloat();
        float g = color.getGreenAsFloat();
        float b = color.getBlueAsFloat();
        buffer.m_252986_(m, xmin, depth, zmin).m_85950_(r, g, b, alpha).m_7421_(u0, v0).m_86008_(OverlayTexture.f_118083_).m_85969_(255).m_252939_(n, 0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(m, xmax, depth, zmin).m_85950_(r, g, b, alpha).m_7421_(u1, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(255).m_252939_(n, 0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(m, xmax, depth, zmax).m_85950_(r, g, b, alpha).m_7421_(u2, v2).m_86008_(OverlayTexture.f_118083_).m_85969_(255).m_252939_(n, 0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(m, xmin, depth, zmax).m_85950_(r, g, b, alpha).m_7421_(u3, v3).m_86008_(OverlayTexture.f_118083_).m_85969_(255).m_252939_(n, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    private void renderBG(MonitorBlockEntity blockEntity, PoseStack ms, MultiBufferSource bufferSource, MonitorSprite monitorSprite) {
        int size = blockEntity.getSize();
        Matrix4f m = ms.m_85850_().m_252922_();
        Matrix3f n = ms.m_85850_().m_252943_();
        Color color = new Color(((Integer)RadarConfig.client().groundRadarColor.get()).intValue());
        float minX = 1.0f - (float)size;
        float minZ = 1.0f - (float)size;
        float maxX = 1.0f;
        float maxZ = 1.0f;
        this.renderVertices(this.getBuffer(bufferSource, monitorSprite), m, n, color, 0.6f, 0.94f, minX, minZ, maxX, maxZ);
    }

    public void renderSweep(IRadar radar, MonitorBlockEntity controller, PoseStack ms, MultiBufferSource bufferSource, float partialTicks) {
        if (!radar.isRunning()) {
            return;
        }
        VertexConsumer buffer = bufferSource.m_6299_(ModRenderTypes.polygonOffset(MonitorSprite.RADAR_SWEEP.getTexture()));
        Matrix4f m = ms.m_85850_().m_252922_();
        Matrix3f n = ms.m_85850_().m_252943_();
        Color color = new Color(((Integer)RadarConfig.client().groundRadarColor.get()).intValue());
        float monitorAngle = 0.0f;
        if (radar.renderRelativeToMonitor()) {
            Direction monitorFacing = (Direction)controller.m_58900_().m_61143_((Property)MonitorBlock.f_54117_);
            Vec3 facingVec = new Vec3((double)monitorFacing.m_122429_(), (double)monitorFacing.m_122430_(), (double)monitorFacing.m_122431_());
            Vec3 angleVec = PhysicsHandler.getWorldVecDirectionTransform(facingVec, (BlockEntity)controller);
            monitorAngle = (float)Math.toDegrees(Math.atan2(angleVec.f_82479_, angleVec.f_82481_));
            if (monitorFacing == Direction.NORTH || monitorFacing == Direction.SOUTH) {
                monitorAngle = (monitorAngle + 180.0f) % 360.0f;
            }
            monitorAngle = (monitorAngle + 360.0f) % 360.0f;
        }
        float currentAngle = radar.getGlobalAngle();
        float angleDiff = monitorAngle + (currentAngle = (currentAngle + 360.0f) % 360.0f);
        if (angleDiff > 180.0f) {
            angleDiff -= 360.0f;
        }
        if (angleDiff < -180.0f) {
            angleDiff += 360.0f;
        }
        float angleRad = angleDiff * (float)Math.PI / 180.0f;
        float cos = (float)Math.cos(angleRad);
        float sin = (float)Math.sin(angleRad);
        float centerX = 0.5f;
        float centerY = 0.5f;
        int size = controller.getSize();
        float u0 = centerX + (0.0f - centerX) * cos - (0.0f - centerY) * sin;
        float v0 = centerY + (0.0f - centerX) * sin + (0.0f - centerY) * cos;
        float u1 = centerX + (1.0f - centerX) * cos - (0.0f - centerY) * sin;
        float v1 = centerY + (1.0f - centerX) * sin + (0.0f - centerY) * cos;
        float u2 = centerX + (1.0f - centerX) * cos - (1.0f - centerY) * sin;
        float v2 = centerY + (1.0f - centerX) * sin + (1.0f - centerY) * cos;
        float u3 = centerX + (0.0f - centerX) * cos - (1.0f - centerY) * sin;
        float v3 = centerY + (0.0f - centerX) * sin + (1.0f - centerY) * cos;
        buffer.m_252986_(m, 1.0f - (float)size, 0.947f, 1.0f - (float)size).m_85950_(color.getRedAsFloat(), color.getGreenAsFloat(), color.getBlueAsFloat(), 0.8f).m_7421_(u0, v0).m_86008_(OverlayTexture.f_118083_).m_85969_(255).m_252939_(n, 0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(m, 1.0f, 0.947f, 1.0f - (float)size).m_85950_(color.getRedAsFloat(), color.getGreenAsFloat(), color.getBlueAsFloat(), 0.8f).m_7421_(u1, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(255).m_252939_(n, 0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(m, 1.0f, 0.947f, 1.0f).m_85950_(color.getRedAsFloat(), color.getGreenAsFloat(), color.getBlueAsFloat(), 0.8f).m_7421_(u2, v2).m_86008_(OverlayTexture.f_118083_).m_85969_(255).m_252939_(n, 0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(m, 1.0f - (float)size, 0.947f, 1.0f).m_85950_(color.getRedAsFloat(), color.getGreenAsFloat(), color.getBlueAsFloat(), 0.8f).m_7421_(u3, v3).m_86008_(OverlayTexture.f_118083_).m_85969_(255).m_252939_(n, 0.0f, 1.0f, 0.0f).m_5752_();
    }
}

