/*
 * Decompiled with CFR 0.152.
 */
package com.happysg.radar.block.guidance;

import com.happysg.radar.block.datalink.screens.TargetingConfig;
import com.happysg.radar.block.monitor.MonitorBlockEntity;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import rbasamoyai.createbigcannons.cannon_control.contraption.PitchOrientedContraptionEntity;
import riftyboi.cbcmodernwarfare.munitions.contraptions.MunitionsPhysicsContraptionEntity;
import riftyboi.cbcmodernwarfare.munitions.munitions_contraption_launcher.guidance.GuidanceBlockEntity;

public class RadarGuidanceBlockEntity
extends GuidanceBlockEntity {
    @Nullable
    private Vec3 target;
    private BlockPos monitorPos;

    public RadarGuidanceBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    public boolean canFire(PitchOrientedContraptionEntity pitchOrientedContraptionEntity) {
        this.checkForTarget(pitchOrientedContraptionEntity.m_9236_());
        return this.target != null;
    }

    private void checkForTarget(Level server) {
        if (this.monitorPos == null) {
            return;
        }
        BlockEntity blockEntity = server.m_7702_(this.monitorPos);
        if (blockEntity instanceof MonitorBlockEntity) {
            MonitorBlockEntity monitor = (MonitorBlockEntity)blockEntity;
            this.target = monitor.getController().getTargetPos(TargetingConfig.DEFAULT);
        }
    }

    public void tickMissileGuidance(MunitionsPhysicsContraptionEntity missile) {
        double timeToIntercept;
        double c;
        if (missile.m_9236_().f_46443_) {
            return;
        }
        this.checkForTarget(missile.m_9236_());
        if (this.target == null) {
            return;
        }
        Vec3 missilePos = missile.m_20182_();
        Vec3 targetPos = this.target;
        Vec3 targetVelocity = Vec3.f_82478_;
        Vec3 missileVelocity = missile.m_20184_();
        Vec3 relativePos = targetPos.m_82546_(missilePos);
        Vec3 relativeVelocity = targetVelocity.m_82546_(missileVelocity);
        double missileSpeed = missileVelocity.m_82553_();
        double a = relativeVelocity.m_82556_() - missileSpeed * missileSpeed;
        double b = 2.0 * relativePos.m_82526_(relativeVelocity);
        double discriminant = b * b - 4.0 * a * (c = relativePos.m_82556_());
        if (discriminant > 0.0 && a != 0.0) {
            double t2;
            double distance = (-b + Math.sqrt(discriminant)) / (2.0 * a);
            timeToIntercept = Math.min(distance, t2 = (-b - Math.sqrt(discriminant)) / (2.0 * a)) > 0.0 ? Math.min(distance, t2) : Math.max(distance, t2);
        } else {
            double distance = missile.m_20182_().m_82554_(this.target);
            timeToIntercept = distance / missileSpeed;
        }
        Vec3 interceptPoint = targetPos.m_82549_(targetVelocity.m_82490_(timeToIntercept));
        Vec3 directionToIntercept = interceptPoint.m_82546_(missilePos).m_82541_();
        Vec3 currentDirection = missileVelocity.m_82541_();
        currentDirection.m_82526_(directionToIntercept);
        double turningRate = this.calculateTurningSpeed(missile.getContraption().getBlocks().size(), missileSpeed, this.m_58900_());
        Vec3 adjustedDirection = currentDirection.m_165921_(directionToIntercept, turningRate).m_82541_();
        missile.setContraptionMotion(adjustedDirection.m_82490_(missileSpeed));
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        if (pTag.m_128441_("monitorPos")) {
            this.monitorPos = BlockPos.m_122022_((long)pTag.m_128454_("monitorPos"));
        }
        if (pTag.m_128441_("target")) {
            int[] targetArray = pTag.m_128465_("target");
            this.target = new Vec3((double)targetArray[0], (double)targetArray[1], (double)targetArray[2]);
        }
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        if (this.monitorPos != null) {
            pTag.m_128356_("monitorPos", this.monitorPos.m_121878_());
        }
        if (this.target != null) {
            pTag.m_128385_("target", new int[]{(int)this.target.f_82479_, (int)this.target.f_82480_, (int)this.target.f_82481_});
        }
    }
}

