/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createcentralkitchen.entry;

import com.simibubi.create.api.registry.CreateBuiltInRegistries;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.createmod.ponder.api.registration.PonderTagRegistrationHelper;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import plus.dragons.createcentralkitchen.CentralKitchen;
import plus.dragons.createcentralkitchen.content.logistics.block.mechanicalArm.BasketPoint;
import plus.dragons.createcentralkitchen.content.logistics.block.mechanicalArm.BlazeStovePoint;
import plus.dragons.createcentralkitchen.content.logistics.block.mechanicalArm.CookingPotPoint;
import plus.dragons.createcentralkitchen.content.logistics.block.mechanicalArm.CopperPotPoint;
import plus.dragons.createcentralkitchen.content.logistics.block.mechanicalArm.CuttingBoardPoint;
import plus.dragons.createcentralkitchen.content.logistics.block.mechanicalArm.SkilletPoint;
import plus.dragons.createcentralkitchen.content.logistics.block.mechanicalArm.StovePoint;
import plus.dragons.createcentralkitchen.foundation.ponder.PonderArmInteractionPointType;
import plus.dragons.createcentralkitchen.foundation.utility.Mods;

@Mod.EventBusSubscriber(modid="create_central_kitchen", bus=Mod.EventBusSubscriber.Bus.MOD)
public class CentralKitchenArmInterationTypes {
    public static final List<PonderArmInteractionPointType> TYPES = new ArrayList<PonderArmInteractionPointType>();
    public static final CuttingBoardPoint.Type CUTTING_BOARD = CentralKitchenArmInterationTypes.create("cutting_board", CuttingBoardPoint.Type::new);
    public static final BasketPoint.Type BASKET = CentralKitchenArmInterationTypes.create("basket", BasketPoint.Type::new);
    public static final StovePoint.Type STOVE = CentralKitchenArmInterationTypes.create("stove", StovePoint.Type::new);
    public static final BlazeStovePoint.Type BLAZE_STOVE = CentralKitchenArmInterationTypes.create("blaze_stove", BlazeStovePoint.Type::new);
    public static final CookingPotPoint.Type COOKING_POT = CentralKitchenArmInterationTypes.create("cooking_pot", CookingPotPoint.Type::new);
    public static final SkilletPoint.Type SKILLET = CentralKitchenArmInterationTypes.create("skillet", SkilletPoint.Type::new);
    public static final CopperPotPoint.Type COPPER_POT = CentralKitchenArmInterationTypes.create("copper_pot", CopperPotPoint.Type::new);

    private static <T extends PonderArmInteractionPointType> T create(String name, Function<ResourceLocation, T> factory) {
        ResourceLocation id = CentralKitchen.genRL(name);
        return (T)((Object)((PonderArmInteractionPointType)((Object)factory.apply(id))));
    }

    private static void register(PonderArmInteractionPointType ... types) {
        for (PonderArmInteractionPointType type : types) {
            CentralKitchenArmInterationTypes.pRegister(type);
            TYPES.add(type);
        }
    }

    private static <T extends PonderArmInteractionPointType> void pRegister(T type) {
        Registry.m_122965_((Registry)CreateBuiltInRegistries.ARM_INTERACTION_POINT_TYPE, (ResourceLocation)type.getID(), type);
    }

    @SubscribeEvent
    public static void register(FMLCommonSetupEvent event) {
        if (Mods.isLoaded("farmersdelight")) {
            CentralKitchenArmInterationTypes.register(STOVE, BLAZE_STOVE, COOKING_POT, SKILLET, CUTTING_BOARD, BASKET);
        }
        if (Mods.isLoaded("miners_delight")) {
            CentralKitchenArmInterationTypes.register(COPPER_POT);
        }
    }

    public static void registerPonderTags(PonderTagRegistrationHelper<ResourceLocation> helper) {
        for (PonderArmInteractionPointType type : TYPES) {
            type.addToPonderTag(helper);
        }
    }
}

