/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.track;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.AllShapes;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.trains.track.BezierConnection;
import com.simibubi.create.content.trains.track.BezierTrackPointLocation;
import com.simibubi.create.content.trains.track.TrackBlock;
import com.simibubi.create.content.trains.track.TrackBlockEntity;
import com.simibubi.create.content.trains.track.TrackRenderer;
import com.simibubi.create.content.trains.track.TrackShape;
import com.simibubi.create.content.trains.track.TrackVoxelShapes;
import com.simibubi.create.foundation.utility.RaycastHelper;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.data.WorldAttached;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderHighlightEvent;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class TrackBlockOutline {
    public static WorldAttached<Map<BlockPos, TrackBlockEntity>> TRACKS_WITH_TURNS = new WorldAttached(w -> new HashMap());
    public static BezierPointSelection result;
    private static final VoxelShape LONG_CROSS;
    private static final VoxelShape LONG_ORTHO;
    private static final VoxelShape LONG_ORTHO_OFFSET;

    public static void pickCurves() {
        Minecraft mc = Minecraft.m_91087_();
        Entity entity = mc.f_91075_;
        if (!(entity instanceof LocalPlayer)) {
            return;
        }
        LocalPlayer player = (LocalPlayer)entity;
        if (mc.f_91073_ == null) {
            return;
        }
        Vec3 origin = player.m_20299_(AnimationTickHolder.getPartialTicks((LevelAccessor)mc.f_91073_));
        double maxRange = mc.f_91077_ == null ? Double.MAX_VALUE : mc.f_91077_.m_82450_().m_82557_(origin);
        result = null;
        AttributeInstance range = player.m_21051_((Attribute)ForgeMod.BLOCK_REACH.get());
        Vec3 target = RaycastHelper.getTraceTarget((Player)player, Math.min(maxRange, range.m_22135_()) + 1.0, origin);
        Map turns = (Map)TRACKS_WITH_TURNS.get((LevelAccessor)mc.f_91073_);
        for (TrackBlockEntity be : turns.values()) {
            for (BezierConnection bc : be.connections.values()) {
                AABB bounds;
                if (!bc.isPrimary() || !(bounds = bc.getBounds()).m_82390_(origin) && bounds.m_82371_(origin, target).isEmpty()) continue;
                float[] stepLUT = bc.getStepLUT();
                int segments = (int)(bc.getLength() * 2.0);
                AABB segmentBounds = AllShapes.TRACK_ORTHO.get(Direction.SOUTH).m_83215_();
                segmentBounds = segmentBounds.m_82386_(-0.5, segmentBounds.m_82376_() / -2.0, -0.5);
                int bestSegment = -1;
                double bestDistance = Double.MAX_VALUE;
                double newMaxRange = maxRange;
                for (int i = 0; i < stepLUT.length - 2; ++i) {
                    double distanceToSqr;
                    float t = stepLUT[i] * (float)i / (float)segments;
                    float t1 = stepLUT[i + 1] * (float)(i + 1) / (float)segments;
                    float t2 = stepLUT[i + 2] * (float)(i + 2) / (float)segments;
                    Vec3 v1 = bc.getPosition(t);
                    Vec3 v2 = bc.getPosition(t2);
                    Vec3 diff = v2.m_82546_(v1);
                    Vec3 angles = TrackRenderer.getModelAngles(bc.getNormal(t1), diff);
                    Vec3 anchor = v1.m_82549_(diff.m_82490_(0.5));
                    Vec3 localOrigin = origin.m_82546_(anchor);
                    Vec3 localDirection = target.m_82546_(origin);
                    localOrigin = VecHelper.rotate((Vec3)localOrigin, (double)AngleHelper.deg((double)(-angles.f_82479_)), (Direction.Axis)Direction.Axis.X);
                    localOrigin = VecHelper.rotate((Vec3)localOrigin, (double)AngleHelper.deg((double)(-angles.f_82480_)), (Direction.Axis)Direction.Axis.Y);
                    localDirection = VecHelper.rotate((Vec3)localDirection, (double)AngleHelper.deg((double)(-angles.f_82479_)), (Direction.Axis)Direction.Axis.X);
                    Optional clip = segmentBounds.m_82371_(localOrigin, localOrigin.m_82549_(localDirection = VecHelper.rotate((Vec3)localDirection, (double)AngleHelper.deg((double)(-angles.f_82480_)), (Direction.Axis)Direction.Axis.Y)));
                    if (clip.isEmpty() || bestSegment != -1 && bestDistance < ((Vec3)clip.get()).m_82531_(0.0, 0.25, 0.0) || (distanceToSqr = ((Vec3)clip.get()).m_82557_(localOrigin)) > maxRange) continue;
                    bestSegment = i;
                    newMaxRange = distanceToSqr;
                    bestDistance = ((Vec3)clip.get()).m_82531_(0.0, 0.25, 0.0);
                    BezierTrackPointLocation location = new BezierTrackPointLocation(bc.getKey(), i);
                    result = new BezierPointSelection(be, location, anchor, angles, diff.m_82541_());
                }
                if (bestSegment == -1) continue;
                maxRange = newMaxRange;
            }
        }
        if (result == null) {
            return;
        }
        if (mc.f_91077_ != null && mc.f_91077_.m_6662_() != HitResult.Type.MISS) {
            Vec3 priorLoc = mc.f_91077_.m_82450_();
            mc.f_91077_ = BlockHitResult.m_82426_((Vec3)priorLoc, (Direction)Direction.UP, (BlockPos)BlockPos.m_274446_((Position)priorLoc));
        }
    }

    public static void drawCurveSelection(PoseStack ms, MultiBufferSource buffer, Vec3 camera) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91066_.f_92062_ || mc.f_91072_.m_105295_() == GameType.SPECTATOR) {
            return;
        }
        BezierPointSelection result = TrackBlockOutline.result;
        if (result == null) {
            return;
        }
        VertexConsumer vb = buffer.m_6299_(RenderType.m_110504_());
        Vec3 vec = result.vec().m_82546_(camera);
        Vec3 angles = result.angles();
        ((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)TransformStack.of((PoseStack)ms).pushPose().translate(vec.f_82479_, vec.f_82480_ + 0.125, vec.f_82481_)).rotateY((float)angles.f_82480_)).rotateX((float)angles.f_82479_)).translate(-0.5, -0.125, -0.5);
        boolean holdingTrack = AllTags.AllBlockTags.TRACKS.matches(Minecraft.m_91087_().f_91074_.m_21205_());
        TrackBlockOutline.renderShape(AllShapes.TRACK_ORTHO.get(Direction.SOUTH), ms, vb, holdingTrack ? Boolean.valueOf(false) : null);
        ms.m_85849_();
    }

    @SubscribeEvent
    public static void drawCustomBlockSelection(RenderHighlightEvent.Block event) {
        TrackBlockEntity tbe;
        BlockEntity blockEntity;
        Minecraft mc = Minecraft.m_91087_();
        BlockHitResult target = event.getTarget();
        BlockPos pos = target.m_82425_();
        BlockState blockstate = mc.f_91073_.m_8055_(pos);
        if (!(blockstate.m_60734_() instanceof TrackBlock)) {
            return;
        }
        if (!mc.f_91073_.m_6857_().m_61937_(pos)) {
            return;
        }
        VertexConsumer vb = event.getMultiBufferSource().m_6299_(RenderType.m_110504_());
        Vec3 camPos = event.getCamera().m_90583_();
        PoseStack ms = event.getPoseStack();
        ms.m_85836_();
        ms.m_85837_((double)pos.m_123341_() - camPos.f_82479_, (double)pos.m_123342_() - camPos.f_82480_, (double)pos.m_123343_() - camPos.f_82481_);
        boolean holdingTrack = AllTags.AllBlockTags.TRACKS.matches(Minecraft.m_91087_().f_91074_.m_21205_());
        TrackShape shape = (TrackShape)((Object)blockstate.m_61143_(TrackBlock.SHAPE));
        boolean canConnectFrom = !shape.isJunction() && (!((blockEntity = mc.f_91073_.m_7702_(pos)) instanceof TrackBlockEntity) || !(tbe = (TrackBlockEntity)blockEntity).isTilted());
        TrackBlockOutline.walkShapes(shape, (TransformStack)TransformStack.of((PoseStack)ms), s -> {
            TrackBlockOutline.renderShape(s, ms, vb, holdingTrack ? Boolean.valueOf(canConnectFrom) : null);
            event.setCanceled(true);
        });
        ms.m_85849_();
    }

    public static void renderShape(VoxelShape s, PoseStack ms, VertexConsumer vb, Boolean valid) {
        PoseStack.Pose transform = ms.m_85850_();
        s.m_83224_((x1, y1, z1, x2, y2, z2) -> {
            float xDiff = (float)(x2 - x1);
            float yDiff = (float)(y2 - y1);
            float zDiff = (float)(z2 - z1);
            float length = Mth.m_14116_((float)(xDiff * xDiff + yDiff * yDiff + zDiff * zDiff));
            xDiff /= length;
            yDiff /= length;
            zDiff /= length;
            float r = 0.0f;
            float g = 0.0f;
            float b = 0.0f;
            if (valid != null && valid.booleanValue()) {
                g = 1.0f;
                b = 1.0f;
                r = 1.0f;
            }
            if (valid != null && !valid.booleanValue()) {
                r = 1.0f;
                b = 0.125f;
                g = 0.25f;
            }
            vb.m_252986_(transform.m_252922_(), (float)x1, (float)y1, (float)z1).m_85950_(r, g, b, 0.4f).m_252939_(transform.m_252943_(), xDiff, yDiff, zDiff).m_5752_();
            vb.m_252986_(transform.m_252922_(), (float)x2, (float)y2, (float)z2).m_85950_(r, g, b, 0.4f).m_252939_(transform.m_252943_(), xDiff, yDiff, zDiff).m_5752_();
        });
    }

    private static void walkShapes(TrackShape shape, TransformStack msr, Consumer<VoxelShape> renderer) {
        float angle45 = 0.7853982f;
        if (shape == TrackShape.XO || shape == TrackShape.CR_NDX || shape == TrackShape.CR_PDX) {
            renderer.accept(AllShapes.TRACK_ORTHO.get(Direction.EAST));
        } else if (shape == TrackShape.ZO || shape == TrackShape.CR_NDZ || shape == TrackShape.CR_PDZ) {
            renderer.accept(AllShapes.TRACK_ORTHO.get(Direction.SOUTH));
        }
        if (shape.isPortal()) {
            for (Direction d : Iterate.horizontalDirections) {
                if (TrackShape.asPortal(d) != shape) continue;
                msr.rotateCentered(AngleHelper.rad((double)AngleHelper.horizontalAngle((Direction)d)), Direction.UP);
                renderer.accept(LONG_ORTHO_OFFSET);
                return;
            }
        }
        if (shape == TrackShape.PD || shape == TrackShape.CR_PDX || shape == TrackShape.CR_PDZ) {
            msr.rotateCentered(angle45, Direction.UP);
            renderer.accept(LONG_ORTHO);
        } else if (shape == TrackShape.ND || shape == TrackShape.CR_NDX || shape == TrackShape.CR_NDZ) {
            msr.rotateCentered(-0.7853982f, Direction.UP);
            renderer.accept(LONG_ORTHO);
        }
        if (shape == TrackShape.CR_O) {
            renderer.accept(AllShapes.TRACK_CROSS);
        } else if (shape == TrackShape.CR_D) {
            msr.rotateCentered(angle45, Direction.UP);
            renderer.accept(LONG_CROSS);
        }
        if (shape != TrackShape.AE && shape != TrackShape.AN && shape != TrackShape.AW && shape != TrackShape.AS) {
            return;
        }
        msr.translate(0.0f, 1.0f, 0.0f);
        msr.rotateCentered((float)Math.PI - AngleHelper.rad((double)shape.getModelRotation()), Direction.UP);
        msr.rotateX(angle45);
        msr.translate(0.0f, -0.1875f, 0.0625f);
        renderer.accept(LONG_ORTHO);
    }

    static {
        LONG_CROSS = Shapes.m_83110_((VoxelShape)TrackVoxelShapes.longOrthogonalZ(), (VoxelShape)TrackVoxelShapes.longOrthogonalX());
        LONG_ORTHO = TrackVoxelShapes.longOrthogonalZ();
        LONG_ORTHO_OFFSET = TrackVoxelShapes.longOrthogonalZOffset();
    }

    public record BezierPointSelection(TrackBlockEntity blockEntity, BezierTrackPointLocation loc, Vec3 vec, Vec3 angles, Vec3 direction) {
    }
}

