/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.wrench;

import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import net.minecraft.core.BlockPos;
import net.minecraft.core.IdMap;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.GameData;

public class RadialWrenchMenuSubmitPacket
extends SimplePacketBase {
    private final BlockPos blockPos;
    private final BlockState newState;

    public RadialWrenchMenuSubmitPacket(BlockPos blockPos, BlockState newState) {
        this.blockPos = blockPos;
        this.newState = newState;
    }

    public RadialWrenchMenuSubmitPacket(FriendlyByteBuf buffer) {
        this.blockPos = buffer.m_130135_();
        this.newState = (BlockState)buffer.m_236816_((IdMap)GameData.getBlockStateIDMap());
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.blockPos);
        buffer.m_236818_((IdMap)GameData.getBlockStateIDMap(), (Object)this.newState);
    }

    @Override
    public boolean handle(NetworkEvent.Context context) {
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            Level level = player.m_9236_();
            if (!level.m_8055_(this.blockPos).m_60713_(this.newState.m_60734_())) {
                return;
            }
            BlockState updatedState = Block.m_49931_((BlockState)this.newState, (LevelAccessor)level, (BlockPos)this.blockPos);
            KineticBlockEntity.switchToBlockState(level, this.blockPos, updatedState);
            IWrenchable.playRotateSound(level, this.blockPos);
        });
        return true;
    }
}

