/*
 * Decompiled with CFR 0.152.
 */
package net.combatroll.network;

import com.google.gson.Gson;
import net.combatroll.client.RollEffect;
import net.combatroll.config.ServerConfig;
import net.combatroll.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;

public class Packets {

    public static class ConfigSync {
        public static ResourceLocation ID = new ResourceLocation("combatroll", "config_sync");

        public static FriendlyByteBuf write(ServerConfig config) {
            Gson gson = new Gson();
            String json = gson.toJson((Object)config);
            FriendlyByteBuf buffer = PacketByteBufs.create();
            buffer.m_130070_(json);
            return buffer;
        }

        public static ServerConfig read(FriendlyByteBuf buffer) {
            Gson gson = new Gson();
            String json = buffer.m_130277_();
            ServerConfig config = (ServerConfig)gson.fromJson(json, ServerConfig.class);
            return config;
        }
    }

    public record RollAnimation(int playerId, RollEffect.Visuals visuals, Vec3 velocity) {
        public static ResourceLocation ID = new ResourceLocation("combatroll", "animation");

        public FriendlyByteBuf write() {
            FriendlyByteBuf buffer = PacketByteBufs.create();
            buffer.writeInt(this.playerId);
            buffer.m_130070_(this.visuals.animationName());
            buffer.m_130070_(this.visuals.particles().toString());
            buffer.writeDouble(this.velocity.f_82479_);
            buffer.writeDouble(this.velocity.f_82480_);
            buffer.writeDouble(this.velocity.f_82481_);
            return buffer;
        }

        public static RollAnimation read(FriendlyByteBuf buffer) {
            int playerId = buffer.readInt();
            RollEffect.Visuals visuals = new RollEffect.Visuals(buffer.m_130277_(), RollEffect.Particles.valueOf(buffer.m_130277_()));
            Vec3 velocity = new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
            return new RollAnimation(playerId, visuals, velocity);
        }
    }

    public record RollPublish(int playerId, RollEffect.Visuals visuals, Vec3 velocity) {
        public static ResourceLocation ID = new ResourceLocation("combatroll", "publish");

        public FriendlyByteBuf write() {
            FriendlyByteBuf buffer = PacketByteBufs.create();
            buffer.writeInt(this.playerId);
            buffer.m_130070_(this.visuals.animationName());
            buffer.m_130070_(this.visuals.particles().toString());
            buffer.writeDouble(this.velocity.f_82479_);
            buffer.writeDouble(this.velocity.f_82480_);
            buffer.writeDouble(this.velocity.f_82481_);
            return buffer;
        }

        public static RollPublish read(FriendlyByteBuf buffer) {
            int playerId = buffer.readInt();
            RollEffect.Visuals visuals = new RollEffect.Visuals(buffer.m_130277_(), RollEffect.Particles.valueOf(buffer.m_130277_()));
            Vec3 velocity = new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
            return new RollPublish(playerId, visuals, velocity);
        }
    }
}

