/*
 * Decompiled with CFR 0.152.
 */
package com.dsvv.cbcat.cannon.heavy_autocannon.qf_breech;

import com.dsvv.cbcat.cannon.heavy_autocannon.HeavyAutocannonBlockEntity;
import com.dsvv.cbcat.cannon.heavy_autocannon.IHeavyAutocannonBreechBE;
import com.dsvv.cbcat.cannon.heavy_autocannon.breech.HeavyAutocannonBreechBlock;
import com.dsvv.cbcat.cannon.heavy_autocannon.munitions.HeavyAutocannonCartridgeItem;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.Contraption;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import rbasamoyai.createbigcannons.cannon_control.contraption.PitchOrientedContraptionEntity;
import rbasamoyai.createbigcannons.cannons.autocannon.AnimatedAutocannon;
import rbasamoyai.createbigcannons.cannons.big_cannons.BigCannonBlock;

public class HeavyAutocannonQuickFireBreechBlockEntity
extends HeavyAutocannonBlockEntity
implements AnimatedAutocannon,
IHeavyAutocannonBreechBE {
    private int fireRate = 7;
    private int firingCooldown;
    private int animateTicks = 2;
    private boolean updateInstance = true;
    private boolean isOpen = false;
    private float openProgress = 0.0f;
    private final int openLimit = 3;
    private final Deque<ItemStack> inputBuffer = new LinkedList<ItemStack>();
    private ItemStack outputBuffer = ItemStack.f_41583_;
    private ItemStack cartridge = ItemStack.f_41583_;

    public HeavyAutocannonQuickFireBreechBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public int getQueueLimit() {
        return 5;
    }

    public Deque<ItemStack> getInputBuffer() {
        return this.inputBuffer;
    }

    public ItemStack getOutputBuffer() {
        return this.outputBuffer;
    }

    public void setOutputBuffer(ItemStack stack) {
        this.outputBuffer = stack;
    }

    public void tick() {
        super.tick();
        this.allTick(this.m_58904_());
    }

    @Override
    public void tickFromContraption(Level level, PitchOrientedContraptionEntity poce, BlockPos localPos) {
        super.tickFromContraption(level, poce, localPos);
        this.allTick(level);
        if (this.openProgress < 3.0f && this.isOpen) {
            this.openProgress += 1.0f;
        } else if (this.openProgress > 0.0f && !this.isOpen) {
            this.openProgress -= 1.0f;
        }
        if (!level.f_46443_ && this.updateInstance) {
            this.updateInstance = false;
            Contraption contraption = poce.getContraption();
            BigCannonBlock.writeAndSyncSingleBlockData((BlockEntity)this, (StructureTemplate.StructureBlockInfo)((StructureTemplate.StructureBlockInfo)contraption.getBlocks().get(localPos)), (AbstractContraptionEntity)poce, (Contraption)contraption);
        }
    }

    private void allTick(Level level) {
        if (this.fireRate < 0 || this.fireRate > 15) {
            this.fireRate = 0;
        }
        if (this.animateTicks < 5) {
            ++this.animateTicks;
        }
        if (this.animateTicks < 0) {
            this.animateTicks = 0;
        }
    }

    @Override
    public void setFireRate(int power) {
        this.fireRate = Mth.m_14045_((int)power, (int)0, (int)15);
    }

    @Override
    public int getActualFireRate() {
        return this.fireRate > 0 ? 150 : 0;
    }

    @Override
    public boolean canFire() {
        return this.openProgress <= 0.0f && this.fireRate > 0 && this.firingCooldown <= 0 && HeavyAutocannonCartridgeItem.hasProjectile(this.cartridge);
    }

    @Override
    public void handleFiring() {
        if (this.fireRate > 0) {
            this.animateTicks = 0;
        }
    }

    @Override
    public void handleFiring(ItemStack eject) {
        if (this.fireRate > 0) {
            this.animateTicks = 0;
            this.shoot(eject);
        }
    }

    public float getAnimateOffset(float partialTicks) {
        float t = ((float)this.animateTicks + partialTicks) * 1.2f;
        if (t <= 0.0f || t >= 4.8f) {
            return 0.0f;
        }
        float f = t < 1.0f ? t : (4.8f - t) / 3.8f;
        return Mth.m_14031_((float)(f * 1.5707964f));
    }

    public void incrementAnimationTicks() {
        ++this.animateTicks;
    }

    public int getAnimationTicks() {
        return this.animateTicks;
    }

    public void setCartridge(ItemStack cartridge) {
        this.cartridge = cartridge;
    }

    public boolean getOpen() {
        return this.openProgress >= 3.0f && this.isOpen;
    }

    public boolean willBeOpen() {
        return this.isOpen;
    }

    public void toggleOpen() {
        this.isOpen = !this.isOpen;
    }

    public void shoot(ItemStack eject) {
        this.cartridge = eject;
    }

    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.fireRate = tag.m_128451_("FiringRate");
        this.firingCooldown = tag.m_128451_("Cooldown");
        this.animateTicks = tag.m_128451_("AnimateTicks");
        this.outputBuffer = tag.m_128441_("Output") ? ItemStack.m_41712_((CompoundTag)tag.m_128469_("Output")) : ItemStack.f_41583_;
        this.isOpen = tag.m_128471_("Open");
        this.openProgress = tag.m_128457_("OpenProgress");
        this.cartridge = ItemStack.m_41712_((CompoundTag)tag.m_128469_("Cartridge"));
        this.inputBuffer.clear();
        ListTag inputTag = tag.m_128437_("Input", 10);
        for (int i = 0; i < inputTag.size(); ++i) {
            this.inputBuffer.add(ItemStack.m_41712_((CompoundTag)inputTag.m_128728_(i)));
        }
        if (!clientPacket) {
            return;
        }
        this.updateInstance = tag.m_128441_("UpdateInstance");
    }

    protected void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        tag.m_128405_("FiringRate", this.fireRate);
        tag.m_128405_("Cooldown", this.firingCooldown);
        tag.m_128405_("AnimateTicks", this.animateTicks);
        if (this.outputBuffer != null && !this.outputBuffer.m_41619_()) {
            tag.m_128365_("Output", (Tag)this.outputBuffer.m_41739_(new CompoundTag()));
        }
        tag.m_128379_("Open", this.isOpen);
        tag.m_128350_("OpenProgress", this.openProgress);
        tag.m_128365_("Cartridge", (Tag)this.cartridge.m_41739_(new CompoundTag()));
        if (!this.inputBuffer.isEmpty()) {
            tag.m_128365_("Input", (Tag)this.inputBuffer.stream().map(s -> s.m_41739_(new CompoundTag())).collect(Collectors.toCollection(ListTag::new)));
        }
        if (!clientPacket) {
            return;
        }
        if (this.updateInstance) {
            tag.m_128379_("UpdateInstance", true);
        }
    }

    @Override
    public ItemStack extractNextInput() {
        ItemStack cart = this.cartridge.m_41777_();
        this.cartridge = ItemStack.f_41583_;
        return cart;
    }

    @Override
    public List<ItemStack> getDrops() {
        List list = super.getDrops();
        for (ItemStack s : this.inputBuffer) {
            if (s.m_41619_()) continue;
            list.add(s.m_41777_());
        }
        if (!this.outputBuffer.m_41619_()) {
            list.add(this.outputBuffer.m_41777_());
        }
        if (this.cartridge != ItemStack.f_41583_) {
            list.add(this.cartridge.m_41777_());
        }
        return list;
    }

    protected AABB createRenderBoundingBox() {
        Direction dir = (Direction)this.m_58900_().m_61143_((Property)HeavyAutocannonBreechBlock.FACING);
        Direction ammoContainerDir = dir.m_122434_().m_122479_() ? dir.m_175362_(Direction.Axis.Y) : Direction.EAST;
        return super.createRenderBoundingBox().m_82369_(new Vec3(dir.m_122424_().m_253071_()).m_82549_(new Vec3(ammoContainerDir.m_253071_())));
    }

    @Override
    public boolean isManual() {
        return true;
    }

    public boolean isLoaded() {
        return this.cartridge != ItemStack.f_41583_;
    }

    public float getOpenProgress(float partialTicks) {
        return this.openProgress / 6.0f;
    }
}

