/*
 * Decompiled with CFR 0.152.
 */
package com.dsvv.cbcat.cannon.heavy_autocannon.munitions;

import com.dsvv.cbcat.cannon.heavy_autocannon.munitions.HeavyAutocannonAmmoType;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import rbasamoyai.createbigcannons.CreateBigCannons;
import rbasamoyai.createbigcannons.block_armor_properties.BlockArmorPropertiesHandler;
import rbasamoyai.createbigcannons.block_armor_properties.BlockArmorPropertiesProvider;
import rbasamoyai.createbigcannons.config.CBCCfgMunitions;
import rbasamoyai.createbigcannons.config.CBCConfigs;
import rbasamoyai.createbigcannons.effects.particles.smoke.TrailSmokeParticleData;
import rbasamoyai.createbigcannons.index.CBCSoundEvents;
import rbasamoyai.createbigcannons.munitions.AbstractCannonProjectile;
import rbasamoyai.createbigcannons.munitions.ProjectileContext;
import rbasamoyai.createbigcannons.munitions.autocannon.AbstractAutocannonProjectile;
import rbasamoyai.createbigcannons.munitions.config.components.BallisticPropertiesComponent;
import rbasamoyai.createbigcannons.network.ClientboundPlayBlockHitEffectPacket;
import rbasamoyai.createbigcannons.utils.CBCUtils;

public abstract class AbstractHeavyAutocannonProjectile
extends AbstractCannonProjectile {
    protected double displacement = 0.0;
    protected int ageRemaining;
    protected final Map<Player, Integer> whooshedPlayers = new HashMap<Player, Integer>();

    protected AbstractHeavyAutocannonProjectile(EntityType<? extends AbstractHeavyAutocannonProjectile> type, Level level) {
        super(type, level);
    }

    protected void onTickRotate() {
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
        if (!this.isInGround()) {
            Vec3 vel = this.m_20184_();
            if (vel.m_82556_() > 0.005) {
                this.m_146922_((float)(Mth.m_14136_((double)vel.f_82479_, (double)vel.f_82481_) * 57.2957763671875));
                this.m_146926_((float)(Mth.m_14136_((double)vel.f_82480_, (double)vel.m_165924_()) * 57.2957763671875));
            }
            this.m_146922_(this.m_146908_());
            this.m_146926_(this.m_146909_());
        }
    }

    public void m_8119_() {
        Vec3 prevPos = this.m_20182_();
        ChunkPos cpos = new ChunkPos(this.m_20183_());
        Vec3 nextVelocity = this.nextVelocity;
        if (this.m_9236_().f_46443_ || this.m_9236_().m_7232_(cpos.f_45578_, cpos.f_45579_)) {
            super.m_8119_();
            this.displacement += this.m_20182_().m_82554_(prevPos);
            if (!this.m_9236_().f_46443_) {
                --this.ageRemaining;
                if (this.ageRemaining <= 0) {
                    this.expireProjectile();
                }
            }
            if (!this.isInGround()) {
                AbstractAutocannonProjectile.TrailType trailType = (AbstractAutocannonProjectile.TrailType)CBCConfigs.server().munitions.autocannonTrailType.get();
                if (trailType != AbstractAutocannonProjectile.TrailType.NONE) {
                    int lifetime = trailType == AbstractAutocannonProjectile.TrailType.SHORT ? 50 : 100 + this.m_9236_().f_46441_.m_188503_(50);
                    TrailSmokeParticleData options = new TrailSmokeParticleData(lifetime);
                    for (int i = 0; i < 10; ++i) {
                        double partial = (float)i * 0.1f;
                        double dx = Mth.m_14139_((double)partial, (double)this.f_19790_, (double)this.m_20185_());
                        double dy = Mth.m_14139_((double)partial, (double)this.f_19791_, (double)this.m_20186_());
                        double dz = Mth.m_14139_((double)partial, (double)this.f_19792_, (double)this.m_20189_());
                        double sx = this.m_9236_().f_46441_.m_188500_() * 0.004 - 0.002;
                        double sy = this.m_9236_().f_46441_.m_188500_() * 0.004 - 0.002;
                        double sz = this.m_9236_().f_46441_.m_188500_() * 0.004 - 0.002;
                        this.m_9236_().m_6485_((ParticleOptions)options, true, dx, dy, dz, sx, sy, sz);
                    }
                    if (nextVelocity != null) {
                        TrailSmokeParticleData options1 = new TrailSmokeParticleData(lifetime - 1);
                        Vec3 nextPos = this.m_20182_().m_82549_(nextVelocity);
                        for (int i = 0; i < 20; ++i) {
                            double partial = (float)i * 0.1f;
                            double dx = Mth.m_14139_((double)partial, (double)this.m_20185_(), (double)nextPos.f_82479_);
                            double dy = Mth.m_14139_((double)partial, (double)this.m_20186_(), (double)nextPos.f_82480_);
                            double dz = Mth.m_14139_((double)partial, (double)this.m_20189_(), (double)nextPos.f_82481_);
                            double sx = this.m_9236_().f_46441_.m_188500_() * 0.004 - 0.002;
                            double sy = this.m_9236_().f_46441_.m_188500_() * 0.004 - 0.002;
                            double sz = this.m_9236_().f_46441_.m_188500_() * 0.004 - 0.002;
                            this.m_9236_().m_6485_((ParticleOptions)options1, true, dx, dy, dz, sx, sy, sz);
                        }
                    }
                }
                if (this.m_9236_().f_46443_ && ((Boolean)CBCConfigs.client().enableAutocannonFlybySounds.get()).booleanValue()) {
                    Iterator<Map.Entry<Player, Integer>> iter = this.whooshedPlayers.entrySet().iterator();
                    while (iter.hasNext()) {
                        Map.Entry<Player, Integer> entry = iter.next();
                        if (entry.getKey().m_213877_() || !entry.getKey().m_6084_()) {
                            iter.remove();
                            continue;
                        }
                        int v = entry.getValue();
                        if (v <= 0) {
                            iter.remove();
                            continue;
                        }
                        entry.setValue(v - 1);
                    }
                    SoundEvent soundEvent = CBCSoundEvents.AUTOCANNON_ROUND_FLYBY.getMainEvent();
                    Vec3 curPos = this.m_20182_();
                    Vec3 displacementVec = curPos.m_82546_(prevPos);
                    AABB path = this.m_20191_().m_82369_(displacementVec.m_82548_()).m_82400_(3.0);
                    for (Player player : this.m_9236_().m_45955_(TargetingConditions.m_148353_(), null, path)) {
                        Vec3 diff = player.m_20182_().m_82546_(prevPos);
                        boolean flag = this.whooshedPlayers.containsKey(player);
                        this.whooshedPlayers.put(player, 3);
                        if (flag) continue;
                        float volume = displacementVec.m_82526_(diff) < 0.0 ? 0.25f : 1.0f;
                        float pitch = 0.95f + this.f_19796_.m_188501_() * 0.2f;
                        this.m_9236_().m_6263_(player, this.m_20185_(), this.m_20186_(), this.m_20189_(), soundEvent, SoundSource.NEUTRAL, volume, pitch);
                    }
                }
            }
        }
    }

    protected void expireProjectile() {
        this.m_146870_();
    }

    public void m_142687_(Entity.RemovalReason reason) {
        super.m_142687_(reason);
        this.whooshedPlayers.clear();
    }

    public void setTracer(boolean tracer) {
        if (tracer) {
            this.f_19804_.m_135381_(ID_FLAGS, (Object)((byte)((Byte)this.f_19804_.m_135370_(ID_FLAGS) | 2)));
        } else {
            this.f_19804_.m_135381_(ID_FLAGS, (Object)((byte)((Byte)this.f_19804_.m_135370_(ID_FLAGS) & 0xFD)));
        }
    }

    public void setLifetime(int lifetime) {
        this.ageRemaining = lifetime;
    }

    protected AbstractCannonProjectile.ImpactResult calculateBlockPenetration(ProjectileContext projectileContext, BlockState state, BlockHitResult blockHitResult) {
        boolean blockBroken;
        BlockPos pos = blockHitResult.m_82425_();
        Vec3 hitLoc = blockHitResult.m_82450_();
        BallisticPropertiesComponent ballistics = this.getBallisticProperties();
        BlockArmorPropertiesProvider blockArmor = BlockArmorPropertiesHandler.getProperties((BlockState)state);
        boolean unbreakable = projectileContext.griefState() == CBCCfgMunitions.GriefState.NO_DAMAGE || state.m_60800_((BlockGetter)this.m_9236_(), pos) == -1.0f;
        Vec3 accel = this.getForces(this.m_20182_(), this.m_20184_());
        Vec3 curVel = this.m_20184_().m_82549_(accel);
        Vec3 normal = CBCUtils.getSurfaceNormalVector((Level)this.m_9236_(), (BlockHitResult)blockHitResult);
        double incidence = Math.max(0.0, curVel.m_82541_().m_82526_(normal.m_82548_()));
        double velMag = curVel.m_82553_();
        double mass = this.getProjectileMass();
        double bonusMomentum = 1.0 + Math.max(0.0, (velMag - (double)CBCConfigs.server().munitions.minVelocityForPenetrationBonus.getF()) * (double)CBCConfigs.server().munitions.penetrationBonusScale.getF());
        double incidentVel = velMag * incidence;
        double momentum = mass * incidentVel * bonusMomentum;
        double toughness = blockArmor.toughness(this.m_9236_(), state, pos, true);
        double toughnessPenalty = toughness - momentum;
        double hardnessPenalty = blockArmor.hardness(this.m_9236_(), state, pos, true) - (double)ballistics.penetration();
        double bounceBonus = Math.max(1.0 - hardnessPenalty, 0.0);
        double projectileDeflection = ballistics.deflection();
        double baseChance = CBCConfigs.server().munitions.baseProjectileBounceChance.getF();
        double bounceChance = projectileDeflection < 0.01 || incidence > projectileDeflection ? 0.0 : Math.max(baseChance, 1.0 - incidence / projectileDeflection) * bounceBonus;
        boolean surfaceImpact = this.canHitSurface();
        boolean canBounce = (Boolean)CBCConfigs.server().munitions.projectilesCanBounce.get();
        boolean bl = blockBroken = toughnessPenalty < 0.01 && !unbreakable;
        AbstractCannonProjectile.ImpactResult.KinematicOutcome outcome = surfaceImpact && canBounce && this.m_9236_().m_213780_().m_188500_() < bounceChance ? AbstractCannonProjectile.ImpactResult.KinematicOutcome.BOUNCE : (blockBroken && !this.m_9236_().f_46443_ ? AbstractCannonProjectile.ImpactResult.KinematicOutcome.PENETRATE : AbstractCannonProjectile.ImpactResult.KinematicOutcome.STOP);
        boolean shatter = surfaceImpact && outcome != AbstractCannonProjectile.ImpactResult.KinematicOutcome.BOUNCE && hardnessPenalty > (double)ballistics.toughness();
        float durabilityPenalty = ((float)Math.max(0.0, hardnessPenalty) + 1.0f) * (float)toughness / (float)incidentVel;
        state.m_60669_(this.m_9236_(), state, blockHitResult, (Projectile)this);
        if (!this.m_9236_().f_46443_) {
            Vec3 effectNormal;
            boolean bounced;
            boolean bl2 = bounced = outcome == AbstractCannonProjectile.ImpactResult.KinematicOutcome.BOUNCE;
            if (bounced) {
                double elasticity = 1.7f;
                effectNormal = curVel.m_82546_(normal.m_82490_(normal.m_82526_(curVel) * elasticity));
            } else {
                effectNormal = curVel.m_82548_();
            }
            for (BlockState state1 : blockArmor.containedBlockStates(this.m_9236_(), state, pos.m_7949_(), true)) {
                projectileContext.addPlayedEffect(new ClientboundPlayBlockHitEffectPacket(state1, this.m_6095_(), bounced, true, hitLoc.f_82479_, hitLoc.f_82480_, hitLoc.f_82481_, (float)effectNormal.f_82479_, (float)effectNormal.f_82480_, (float)effectNormal.f_82481_));
            }
        }
        if (blockBroken) {
            this.setProjectileMass(incidentVel < 1.0E-4 ? 0.0f : Math.max(this.getProjectileMass() - durabilityPenalty, 0.0f));
            this.m_9236_().m_7731_(pos, Blocks.f_50016_.m_49966_(), 11);
        } else {
            if (outcome == AbstractCannonProjectile.ImpactResult.KinematicOutcome.STOP) {
                CreateBigCannons.BLOCK_DAMAGE.damageBlock(pos.m_7949_(), Math.max(Mth.m_14165_((double)momentum), 0), state, this.m_9236_());
                this.setProjectileMass(0.0f);
            } else {
                this.setProjectileMass(incidentVel < 1.0E-4 ? 0.0f : Math.max(this.getProjectileMass() - durabilityPenalty / 2.0f, 0.0f));
            }
            Vec3 spallLoc = hitLoc.m_82549_(curVel.m_82541_().m_82490_(2.0));
            SoundType sound = state.m_60827_();
            if (!this.m_9236_().f_46443_) {
                this.m_9236_().m_6263_(null, spallLoc.f_82479_, spallLoc.f_82480_, spallLoc.f_82481_, sound.m_56775_(), SoundSource.BLOCKS, sound.m_56773_(), sound.m_56774_());
            }
        }
        shatter |= this.onImpact((HitResult)blockHitResult, new AbstractCannonProjectile.ImpactResult(outcome, shatter), projectileContext);
        if (this.getProjectileMass() == 0.0f) {
            this.removeNextTick = true;
        }
        return new AbstractCannonProjectile.ImpactResult(outcome, shatter);
    }

    public boolean isTracer() {
        return ((Byte)this.f_19804_.m_135370_(ID_FLAGS) & 2) != 0;
    }

    public double getTotalDisplacement() {
        return this.displacement;
    }

    public void setTotalDisplacement(double value) {
        this.displacement = value;
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("Tracer", this.isTracer());
        tag.m_128405_("Age", this.ageRemaining);
        tag.m_128347_("Displacement", this.displacement);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setTracer(tag.m_128471_("Tracer"));
        this.ageRemaining = tag.m_128451_("Age");
        this.displacement = tag.m_128457_("Displacement");
    }

    public void baseWriteSpawnData(FriendlyByteBuf buf) {
        super.baseWriteSpawnData(buf);
        buf.writeDouble(this.displacement);
    }

    public void baseReadSpawnData(FriendlyByteBuf buf) {
        super.baseReadSpawnData(buf);
        this.displacement = buf.readDouble();
    }

    public HeavyAutocannonAmmoType getAutocannonRoundType() {
        return HeavyAutocannonAmmoType.NORMAL;
    }
}

