/*
 * Decompiled with CFR 0.152.
 */
package com.dsvv.cbcat.cannon.heavy_autocannon.breech;

import com.dsvv.cbcat.cannon.heavy_autocannon.HeavyAutocannonBlock;
import com.dsvv.cbcat.cannon.heavy_autocannon.breech.HeavyAutocannonBreechBlockEntity;
import com.dsvv.cbcat.cannon.heavy_autocannon.munitions.box.HeavyAutocannonAmmoContainerBlock;
import com.dsvv.cbcat.cannon.heavy_autocannon.munitions.box.HeavyAutocannonAmmoContainerItem;
import com.mojang.math.Axis;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.OrientedInstance;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.visual.AbstractBlockEntityVisual;
import dev.engine_room.flywheel.lib.visual.SimpleDynamicVisual;
import java.util.function.Consumer;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import rbasamoyai.createbigcannons.cannons.autocannon.material.AutocannonMaterial;
import rbasamoyai.createbigcannons.index.CBCBlockPartials;

public class HeavyAutocannonBreechInstance
extends AbstractBlockEntityVisual<HeavyAutocannonBreechBlockEntity>
implements SimpleDynamicVisual {
    private OrientedInstance ammoContainer;
    private Direction facing = (Direction)this.blockState.m_61143_((Property)BlockStateProperties.f_61372_);
    private boolean isFilled = false;
    private Item magazineItem = null;

    public HeavyAutocannonBreechInstance(VisualizationContext ctx, HeavyAutocannonBreechBlockEntity blockEntity, float partialTick) {
        super(ctx, (BlockEntity)blockEntity, partialTick);
        Quaternionf q1;
        Quaternionf q = Axis.f_252436_.m_252977_(this.facing.m_122434_().m_122478_() ? 180.0f : 0.0f);
        this.ammoContainer = (OrientedInstance)this.instancerProvider().instancer(InstanceTypes.ORIENTED, Models.block((BlockState)this.getAmmoContainerModel())).createInstance();
        boolean flag = this.facing.m_122434_().m_122478_();
        if (flag) {
            float f = this.facing == Direction.UP ? 90.0f : -90.0f;
            q1 = Axis.f_252403_.m_252977_(f);
            q1.mul((Quaternionfc)Axis.f_252529_.m_252977_(f));
        } else {
            q1 = Axis.f_252436_.m_252977_(-90.0f - this.facing.m_122435_());
            q1.mul((Quaternionfc)Axis.f_252529_.m_252977_(-90.0f));
        }
        Direction offset = flag ? this.facing.m_175364_(Direction.Axis.Z) : this.facing.m_175362_(Direction.Axis.Y);
        Vector3f normal = this.facing == Direction.UP ? offset.m_122424_().m_253071_() : offset.m_253071_();
        normal.mul(0.625f);
        this.ammoContainer.rotation((Quaternionfc)q1).position((Vec3i)this.getVisualPosition()).translatePosition(normal.x(), normal.y(), normal.z());
        this.isFilled = this.isFilled();
        this.magazineItem = this.getMagazineItem();
        this.updateTransforms(partialTick);
    }

    private void updateTransforms(float partialTick) {
        float offset = ((HeavyAutocannonBreechBlockEntity)this.blockEntity).getAnimateOffset(partialTick) * 0.5f;
        Vector3f normal = this.facing.m_122424_().m_253071_();
        normal.mul(offset);
        ItemStack container = ((HeavyAutocannonBreechBlockEntity)this.blockEntity).getMagazine();
        this.ammoContainer.color((byte)-1, (byte)-1, (byte)-1, (byte)(container.m_41720_() instanceof HeavyAutocannonAmmoContainerItem ? 255 : 0));
        if (this.isFilled != this.isFilled() || this.magazineItem != this.getMagazineItem()) {
            this.updateLight(partialTick);
        }
    }

    public void updateLight(float partialTick) {
        this.relight(this.pos, new FlatLit[]{this.ammoContainer});
    }

    protected void _delete() {
        this.ammoContainer.delete();
    }

    private PartialModel getPartialModelForState() {
        PartialModel partialModel;
        Block block = this.blockState.m_60734_();
        if (block instanceof HeavyAutocannonBlock) {
            HeavyAutocannonBlock cBlock = (HeavyAutocannonBlock)block;
            partialModel = CBCBlockPartials.autocannonEjectorFor((AutocannonMaterial)cBlock.getAutocannonMaterial());
        } else {
            partialModel = CBCBlockPartials.CAST_IRON_AUTOCANNON_EJECTOR;
        }
        return partialModel;
    }

    private BlockState getAmmoContainerModel() {
        Item item;
        ItemStack item2 = ((HeavyAutocannonBreechBlockEntity)this.blockEntity).getMagazine();
        if (item2 == null || item2.m_41619_() || !((item = item2.m_41720_()) instanceof HeavyAutocannonAmmoContainerItem)) {
            return Blocks.f_50016_.m_49966_();
        }
        HeavyAutocannonAmmoContainerItem blockItem = (HeavyAutocannonAmmoContainerItem)item;
        BlockState state = blockItem.m_40614_().m_49966_();
        if (state.m_61138_(HeavyAutocannonAmmoContainerBlock.CONTAINER_STATE)) {
            state = (BlockState)state.m_61124_(HeavyAutocannonAmmoContainerBlock.CONTAINER_STATE, (Comparable)((Object)HeavyAutocannonAmmoContainerBlock.State.getFromFilled(HeavyAutocannonAmmoContainerItem.getTotalAmmoCount(item2) > 0)));
        }
        return state;
    }

    private boolean isFilled() {
        return HeavyAutocannonAmmoContainerItem.getTotalAmmoCount(((HeavyAutocannonBreechBlockEntity)this.blockEntity).getMagazine()) > 0;
    }

    private Item getMagazineItem() {
        ItemStack stack = ((HeavyAutocannonBreechBlockEntity)this.blockEntity).getMagazine();
        return stack == null || stack.m_41619_() ? null : stack.m_41720_();
    }

    public void collectCrumblingInstances(Consumer<@Nullable Instance> consumer) {
        consumer.accept((Instance)this.ammoContainer);
    }

    public void beginFrame(DynamicVisual.Context context) {
        this.updateTransforms(context.partialTick());
    }
}

