/*
 * Decompiled with CFR 0.152.
 */
package com.dsvv.cbcat.cannon.autocannon.munitions.he;

import java.util.function.Predicate;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import rbasamoyai.createbigcannons.CreateBigCannons;
import rbasamoyai.createbigcannons.config.CBCCfgMunitions;
import rbasamoyai.createbigcannons.config.CBCConfigs;
import rbasamoyai.createbigcannons.index.CBCEntityTypes;
import rbasamoyai.createbigcannons.index.CBCMunitionPropertiesHandlers;
import rbasamoyai.createbigcannons.munitions.AbstractCannonProjectile;
import rbasamoyai.createbigcannons.munitions.ProjectileContext;
import rbasamoyai.createbigcannons.munitions.ShellExplosion;
import rbasamoyai.createbigcannons.munitions.autocannon.AbstractAutocannonProjectile;
import rbasamoyai.createbigcannons.munitions.autocannon.flak.FlakAutocannonProjectileProperties;
import rbasamoyai.createbigcannons.munitions.config.components.BallisticPropertiesComponent;
import rbasamoyai.createbigcannons.munitions.config.components.EntityDamagePropertiesComponent;
import rbasamoyai.createbigcannons.munitions.fuzes.FuzeItem;

public class AutocannonHEProjectile
extends AbstractAutocannonProjectile {
    private ItemStack fuze = ItemStack.f_41583_;

    public AutocannonHEProjectile(EntityType<? extends AbstractAutocannonProjectile> type, Level level) {
        super(type, level);
    }

    @NotNull
    public EntityDamagePropertiesComponent getDamageProperties() {
        return new EntityDamagePropertiesComponent(9.0f, false, true, false, 1.0f);
    }

    @NotNull
    protected BallisticPropertiesComponent getBallisticProperties() {
        return new BallisticPropertiesComponent(-0.025, 0.01, false, 1.0f, 0.9f, 0.4f, 0.7f);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.canDetonate(fz -> fz.onProjectileTick(this.fuze, (AbstractCannonProjectile)this))) {
            this.detonate((Position)this.m_20182_());
            this.removeNextTick = true;
        }
    }

    protected void expireProjectile() {
        FuzeItem fuzeItem;
        Item item = this.fuze.m_41720_();
        if (item instanceof FuzeItem && (fuzeItem = (FuzeItem)item).onProjectileExpiry(this.fuze, (AbstractCannonProjectile)this)) {
            this.detonate((Position)this.m_20182_());
        }
        super.expireProjectile();
    }

    protected boolean onImpact(HitResult hitResult, AbstractCannonProjectile.ImpactResult impactResult, ProjectileContext projectileContext) {
        super.onImpact(hitResult, impactResult, projectileContext);
        if (this.canDetonate(fz -> fz.onProjectileImpact(this.fuze, (AbstractCannonProjectile)this, hitResult, impactResult, false))) {
            this.detonate((Position)hitResult.m_82450_());
            return true;
        }
        return false;
    }

    protected boolean onClip(ProjectileContext ctx, Vec3 start, Vec3 end) {
        if (super.onClip(ctx, start, end)) {
            return true;
        }
        if (this.canDetonate(fz -> fz.onProjectileClip(this.fuze, (AbstractCannonProjectile)this, start, end, ctx, false))) {
            this.detonate((Position)start);
            return true;
        }
        return false;
    }

    protected void detonate(Position position) {
        FlakAutocannonProjectileProperties properties = (FlakAutocannonProjectileProperties)CBCMunitionPropertiesHandlers.FLAK_AUTOCANNON.getPropertiesOf((Object)((EntityType)CBCEntityTypes.FLAK_AUTOCANNON.get()));
        ShellExplosion explosion = new ShellExplosion(this.m_9236_(), (Entity)this, this.indirectArtilleryFire(false), position.m_7096_(), position.m_7098_(), position.m_7094_(), properties.explosion().explosivePower() * 1.05f, false, ((CBCCfgMunitions.GriefState)CBCConfigs.server().munitions.damageRestriction.get()).explosiveInteraction());
        CreateBigCannons.handleCustomExplosion((Level)this.m_9236_(), (Explosion)explosion);
    }

    public void setFuze(ItemStack fuze) {
        this.fuze = fuze;
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        if (this.fuze != null && !this.fuze.m_41619_()) {
            tag.m_128365_("Fuze", (Tag)this.fuze.m_41739_(new CompoundTag()));
        }
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.fuze = tag.m_128425_("Fuze", 10) ? ItemStack.m_41712_((CompoundTag)tag.m_128469_("Fuze")) : ItemStack.f_41583_;
    }

    protected final boolean canDetonate(Predicate<FuzeItem> cons) {
        FuzeItem fuzeItem;
        Item item;
        return !this.m_9236_().f_46443_ && this.m_9236_().m_46805_(this.m_20183_()) && !this.m_213877_() && (item = this.fuze.m_41720_()) instanceof FuzeItem && cons.test(fuzeItem = (FuzeItem)item);
    }
}

