/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.caverns_and_chasms.client.model;

import com.teamabnormals.caverns_and_chasms.common.entity.animal.CopperGolem;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public class CopperGolemModel<T extends LivingEntity>
extends HierarchicalModel<T> {
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart nose;
    private final ModelPart rightArm;
    private final ModelPart leftArm;
    private final ModelPart rightLeg;
    private final ModelPart leftLeg;
    private float headSpinTicks;
    private float buttonPressTicks;

    public CopperGolemModel(ModelPart rootIn) {
        this.root = rootIn;
        this.head = rootIn.m_171324_("head");
        this.nose = this.head.m_171324_("nose");
        this.body = rootIn.m_171324_("body");
        this.rightArm = this.body.m_171324_("right_arm");
        this.leftArm = this.body.m_171324_("left_arm");
        this.rightLeg = rootIn.m_171324_("right_leg");
        this.leftLeg = rootIn.m_171324_("left_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -5.0f, -3.0f, 8.0f, 5.0f, 6.0f, new CubeDeformation(0.4f)).m_171514_(0, 33).m_171488_(-4.0f, -5.0f, -3.0f, 8.0f, 5.0f, 6.0f, new CubeDeformation(0.6f)).m_171514_(22, 0).m_171488_(-1.0f, -7.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(22, 18).m_171488_(-2.0f, -10.0f, -2.0f, 4.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)15.0f, (float)0.0f));
        head.m_171599_("nose", CubeListBuilder.m_171558_().m_171514_(12, 22).m_171488_(-1.0f, 0.0f, -1.25f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)-3.5f));
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 11).m_171488_(-4.0f, 0.0f, -2.5f, 8.0f, 6.0f, 5.0f, new CubeDeformation(0.15f)), PartPose.m_171419_((float)0.0f, (float)15.0f, (float)0.0f));
        body.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171480_().m_171488_(-3.0f, -1.0f, -1.5f, 3.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-4.0f, (float)0.0f, (float)0.0f));
        body.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171488_(0.0f, -1.0f, -1.5f, 3.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.0f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(24, 7).m_171480_().m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-2.0f, (float)21.0f, (float)0.0f));
        partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(24, 7).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)21.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingTicks, float partialTick) {
        super.m_6839_(entity, limbSwing, limbSwingTicks, partialTick);
        if (entity instanceof CopperGolem) {
            this.headSpinTicks = ((CopperGolem)entity).getHeadSpinTicks(partialTick);
            this.buttonPressTicks = ((CopperGolem)entity).getPressButtonTicks(partialTick);
        }
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entity instanceof CopperGolem) {
            float headspinanim = this.headSpinTicks > 10.0f ? (float)Math.PI * 2 * (this.headSpinTicks - 10.0f) / 14.0f : (this.headSpinTicks > 4.0f ? -Mth.m_14031_((float)((float)Math.PI * (this.headSpinTicks - 4.0f) / 6.0f)) * (this.headSpinTicks - 4.0f) / 10.0f : 0.0f);
            float headtilt = this.headSpinTicks < 10.0f ? Mth.m_14031_((float)((float)Math.PI * this.headSpinTicks * 0.3f)) * this.headSpinTicks * 0.012f : 0.0f;
            this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180) + headspinanim;
            this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
            this.head.f_104205_ = headtilt;
            if (this.buttonPressTicks > 0.0f) {
                this.rightArm.f_104203_ = -1.0f + Mth.m_14156_((float)this.buttonPressTicks, (float)12.0f);
                this.leftArm.f_104203_ = -1.0f + Mth.m_14156_((float)this.buttonPressTicks, (float)12.0f);
            } else {
                this.rightArm.f_104203_ = (-0.2f + 1.5f * Mth.m_14156_((float)limbSwing, (float)13.0f)) * 1.6f * limbSwingTicks;
                this.leftArm.f_104203_ = (-0.2f - 1.5f * Mth.m_14156_((float)limbSwing, (float)13.0f)) * 1.6f * limbSwingTicks;
            }
            this.rightLeg.f_104203_ = -1.5f * Mth.m_14156_((float)limbSwing, (float)13.0f) * limbSwingTicks;
            this.leftLeg.f_104203_ = 1.5f * Mth.m_14156_((float)limbSwing, (float)13.0f) * limbSwingTicks;
        }
    }
}

