/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon;

import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import tschipp.carryon.Constants;
import tschipp.carryon.common.carry.CarryOnData;
import tschipp.carryon.common.carry.CarryOnDataManager;
import tschipp.carryon.common.carry.PlacementHandler;
import tschipp.carryon.common.command.CommandCarryOn;
import tschipp.carryon.config.ConfigLoader;
import tschipp.carryon.networking.clientbound.ClientboundStartRidingPacket;
import tschipp.carryon.networking.clientbound.ClientboundSyncScriptsPacket;
import tschipp.carryon.networking.serverbound.ServerboundCarryKeyPressedPacket;
import tschipp.carryon.platform.Services;

public class CarryOnCommon {
    public static void registerServerPackets() {
        Services.PLATFORM.registerServerboundPacket(Constants.PACKET_ID_KEY_PRESSED, 0, ServerboundCarryKeyPressedPacket.class, ServerboundCarryKeyPressedPacket::toBytes, ServerboundCarryKeyPressedPacket::new, ServerboundCarryKeyPressedPacket::handle);
    }

    public static void registerClientPackets() {
        Services.PLATFORM.registerClientboundPacket(Constants.PACKET_ID_START_RIDING, 1, ClientboundStartRidingPacket.class, ClientboundStartRidingPacket::toBytes, ClientboundStartRidingPacket::new, ClientboundStartRidingPacket::handle);
        Services.PLATFORM.registerClientboundPacket(Constants.PACKET_ID_SYNC_SCRIPTS, 2, ClientboundSyncScriptsPacket.class, ClientboundSyncScriptsPacket::toBytes, ClientboundSyncScriptsPacket::new, ClientboundSyncScriptsPacket::handle);
    }

    public static void registerConfig() {
        ConfigLoader.registerConfig(Constants.COMMON_CONFIG);
        ConfigLoader.registerConfig(Constants.CLIENT_CONFIG);
    }

    public static void registerCommands(CommandDispatcher<CommandSourceStack> dispatcher) {
        CommandCarryOn.register(dispatcher);
    }

    public static void onCarryTick(ServerPlayer player) {
        CarryOnData carry = CarryOnDataManager.getCarryData((Player)player);
        if (carry.isCarrying()) {
            String cmd;
            if (carry.getActiveScript().isPresent() && !(cmd = carry.getActiveScript().get().scriptEffects().commandLoop()).isEmpty()) {
                player.m_20194_().m_129892_().m_230957_(player.m_20194_().m_129893_(), "/execute as " + player.m_36316_().getName() + " run " + cmd);
            }
            if (!Constants.COMMON_CONFIG.settings.slownessInCreative && player.m_7500_()) {
                return;
            }
            player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 1, CarryOnCommon.potionLevel(carry, player.m_9236_()), false, false));
            Inventory inv = player.m_150109_();
            inv.f_35977_ = carry.getSelected();
        }
    }

    public static boolean onTryBreakBlock(Player player) {
        CarryOnData carry;
        return player == null || Constants.COMMON_CONFIG.settings.hitWhileCarrying || !(carry = CarryOnDataManager.getCarryData(player)).isCarrying();
    }

    public static boolean onAttackedByPlayer(Player player) {
        CarryOnData carry;
        return player == null || Constants.COMMON_CONFIG.settings.hitWhileCarrying || !(carry = CarryOnDataManager.getCarryData(player)).isCarrying();
    }

    public static void onPlayerAttacked(Player player) {
        CarryOnData carry;
        if (Constants.COMMON_CONFIG.settings.dropCarriedWhenHit && !player.m_9236_().f_46443_ && (carry = CarryOnDataManager.getCarryData(player)).isCarrying()) {
            PlacementHandler.placeCarried((ServerPlayer)player);
        }
    }

    private static int potionLevel(CarryOnData carry, Level level) {
        if (carry.isCarrying(CarryOnData.CarryType.PLAYER)) {
            return 1;
        }
        if (carry.isCarrying(CarryOnData.CarryType.ENTITY)) {
            Entity entity = carry.getEntity(level);
            int i = (int)(entity.m_20206_() * entity.m_20205_());
            if (i > 4) {
                i = 4;
            }
            if (!Constants.COMMON_CONFIG.settings.heavyEntities) {
                i = 1;
            }
            return (int)((double)i * Constants.COMMON_CONFIG.settings.entitySlownessMultiplier);
        }
        if (carry.isCarrying(CarryOnData.CarryType.BLOCK)) {
            String nbt = carry.getNbt().toString();
            int i = nbt.length() / 500;
            if (i > 4) {
                i = 4;
            }
            if (!Constants.COMMON_CONFIG.settings.heavyTiles) {
                i = 1;
            }
            return (int)((double)i * Constants.COMMON_CONFIG.settings.blockSlownessMultiplier);
        }
        return 0;
    }
}

