/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.common.capability.chunkloading;

import com.google.common.collect.Lists;
import com.teamabnormals.blueprint.common.capability.chunkloading.IChunkLoader;
import com.teamabnormals.blueprint.core.util.TickTask;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.chunk.ChunkAccess;

public class ChunkLoader
implements IChunkLoader {
    public final List<Long> loadedPositions = Lists.newArrayList();
    @Nullable
    private final ServerLevel level;
    private final List<TickTask<ChunkAccess>> scheduledChunkProcesses = Lists.newArrayList();

    public ChunkLoader(@Nullable ServerLevel level) {
        this.level = level;
    }

    @Override
    public void addPos(BlockPos pos) {
        if (!this.containsPos(pos)) {
            this.forceChunk(pos, true);
            this.loadedPositions.add(pos.m_121878_());
        }
    }

    @Override
    public void removePos(BlockPos pos) {
        if (this.loadedPositions.remove(pos.m_121878_())) {
            this.forceChunk(pos, false);
        }
    }

    @Override
    public boolean containsPos(BlockPos pos) {
        return this.loadedPositions.contains(pos.m_121878_());
    }

    @Override
    public void tick() {
        for (TickTask<ChunkAccess> process : this.scheduledChunkProcesses) {
            process.tick();
        }
        this.scheduledChunkProcesses.removeIf(TickTask::isComplete);
    }

    private void forceChunk(BlockPos pos, boolean load) {
        ServerLevel level = this.level;
        if (level != null) {
            level.m_8602_(pos.m_123341_() >> 4, pos.m_123343_() >> 4, load);
        }
    }

    public void scheduleChunkProcess(ChunkAccess chunk, Consumer<ChunkAccess> chunkProcess, int ticks) {
        this.scheduledChunkProcesses.add(new TickTask<ChunkAccess>(chunk, chunkProcess, ticks));
    }

    public Tag serializeNBT() {
        return new LongArrayTag(this.loadedPositions);
    }

    public void deserializeNBT(Tag nbt) {
        this.loadedPositions.clear();
        long[] lArray = ((LongArrayTag)nbt).m_128851_();
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            Long pos = lArray[i];
            this.addPos(BlockPos.m_122022_((long)pos));
        }
    }
}

