/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.render.entity;

import mod.azure.azurelib.cache.texture.AnimatableTexture;
import mod.azure.azurelib.rewrite.render.AzLayerRenderer;
import mod.azure.azurelib.rewrite.render.AzModelRenderer;
import mod.azure.azurelib.rewrite.render.AzRendererConfig;
import mod.azure.azurelib.rewrite.render.AzRendererPipeline;
import mod.azure.azurelib.rewrite.render.AzRendererPipelineContext;
import mod.azure.azurelib.rewrite.render.entity.AzEntityLayerRenderer;
import mod.azure.azurelib.rewrite.render.entity.AzEntityLeashRenderUtil;
import mod.azure.azurelib.rewrite.render.entity.AzEntityModelRenderer;
import mod.azure.azurelib.rewrite.render.entity.AzEntityRenderer;
import mod.azure.azurelib.rewrite.render.entity.AzEntityRendererConfig;
import mod.azure.azurelib.rewrite.render.entity.AzEntityRendererPipelineContext;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class AzEntityRendererPipeline<T extends class_1297>
extends AzRendererPipeline<T> {
    private final AzEntityRenderer<T> entityRenderer;
    protected Matrix4f entityRenderTranslations = new Matrix4f();
    protected Matrix4f modelRenderTranslations = new Matrix4f();

    public AzEntityRendererPipeline(AzEntityRendererConfig<T> config, AzEntityRenderer<T> entityRenderer) {
        super(config);
        this.entityRenderer = entityRenderer;
    }

    @Override
    protected AzRendererPipelineContext<T> createContext(AzRendererPipeline<T> rendererPipeline) {
        return new AzEntityRendererPipelineContext(this);
    }

    @Override
    protected AzModelRenderer<T> createModelRenderer(AzLayerRenderer<T> layerRenderer) {
        return new AzEntityModelRenderer<T>(this, layerRenderer);
    }

    @Override
    protected AzLayerRenderer<T> createLayerRenderer(AzRendererConfig<T> config) {
        return new AzEntityLayerRenderer(config::renderLayers);
    }

    @Override
    public void updateAnimatedTextureFrame(T entity) {
        AnimatableTexture.setAndUpdate(this.config.textureLocation(entity));
    }

    @Override
    public void preRender(AzRendererPipelineContext<T> context, boolean isReRender) {
        class_4587 poseStack = context.poseStack();
        this.entityRenderTranslations.set((Matrix4fc)poseStack.method_23760().method_23761());
        AzEntityRendererConfig<Object> config = this.entityRenderer.config();
        float scaleWidth = config.scaleWidth((class_1297)context.animatable());
        float scaleHeight = config.scaleHeight((class_1297)context.animatable());
        this.scaleModelForRender(context, scaleWidth, scaleHeight, isReRender);
        if (config.alpha((class_1297)context.animatable()) < 1.0f) {
            context.setAlpha(config.alpha((class_1297)context.animatable()));
        }
        config.preRenderEntry(context);
    }

    @Override
    public void postRender(AzRendererPipelineContext<T> context, boolean isReRender) {
        this.config.postRenderEntry(context);
    }

    @Override
    public void renderFinal(AzRendererPipelineContext<T> context) {
        class_4597 bufferSource = context.multiBufferSource();
        class_1297 entity = (class_1297)context.animatable();
        int packedLight = context.packedLight();
        float partialTick = context.partialTick();
        class_4587 poseStack = context.poseStack();
        this.entityRenderer.superRender(entity, 0.0f, partialTick, poseStack, bufferSource, packedLight);
        if (!(entity instanceof class_1308)) {
            return;
        }
        class_1308 mob = (class_1308)entity;
        class_1297 leashHolder = mob.method_5933();
        if (leashHolder == null) {
            return;
        }
        AzEntityLeashRenderUtil.renderLeash(this.entityRenderer, mob, partialTick, poseStack, bufferSource, leashHolder);
    }

    public AzEntityRenderer<T> getRenderer() {
        return this.entityRenderer;
    }
}

