/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.animation.property;

import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import mod.azure.azurelib.rewrite.animation.easing.AzEasingType;
import mod.azure.azurelib.rewrite.animation.easing.AzEasingTypes;
import mod.azure.azurelib.rewrite.animation.play_behavior.AzPlayBehavior;
import mod.azure.azurelib.rewrite.animation.play_behavior.AzPlayBehaviors;
import mod.azure.azurelib.rewrite.animation.property.AzAnimationProperties;
import mod.azure.azurelib.rewrite.animation.property.codec.AzAnimationStagePropertiesCodec;
import net.minecraft.class_2540;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AzAnimationStageProperties
extends AzAnimationProperties {
    public static final Function<class_2540, AzAnimationStageProperties> DECODER = AzAnimationStagePropertiesCodec.DECODER;
    public static final BiConsumer<class_2540, AzAnimationStageProperties> ENCODER = AzAnimationStagePropertiesCodec.ENCODER;
    public static final AzAnimationStageProperties DEFAULT = new AzAnimationStageProperties(1.0, AzEasingTypes.NONE, AzPlayBehaviors.PLAY_ONCE, Float.valueOf(0.0f), 0.0);
    public static final AzAnimationStageProperties EMPTY = new AzAnimationStageProperties(null, null, null, null, null);
    private AzPlayBehavior playBehavior;

    public AzAnimationStageProperties(@Nullable Double animationSpeed, @Nullable AzEasingType easingType, @Nullable AzPlayBehavior playBehavior, @Nullable Float transitionLength, @Nullable Double startTickOffset) {
        super(animationSpeed, easingType, transitionLength, startTickOffset);
        this.playBehavior = playBehavior;
        this.startTickOffset = startTickOffset;
    }

    public boolean hasPlayBehavior() {
        return this.playBehavior != null;
    }

    @Override
    public AzAnimationStageProperties withAnimationSpeed(double animationSpeed) {
        this.animationSpeed = animationSpeed;
        return new AzAnimationStageProperties(animationSpeed, this.easingType, this.playBehavior, this.transitionLength, this.startTickOffset);
    }

    @Override
    public AzAnimationStageProperties withEasingType(@NotNull AzEasingType easingType) {
        this.easingType = easingType;
        return new AzAnimationStageProperties(this.animationSpeed, easingType, this.playBehavior, this.transitionLength, this.startTickOffset);
    }

    public AzAnimationStageProperties withPlayBehavior(@NotNull AzPlayBehavior playBehavior) {
        this.playBehavior = playBehavior;
        return new AzAnimationStageProperties(this.animationSpeed, this.easingType, playBehavior, this.transitionLength, this.startTickOffset);
    }

    @Override
    public AzAnimationStageProperties withTransitionLength(float transitionLength) {
        this.transitionLength = Float.valueOf(transitionLength);
        return new AzAnimationStageProperties(this.animationSpeed, this.easingType, this.playBehavior, Float.valueOf(transitionLength), this.startTickOffset);
    }

    @Override
    public AzAnimationStageProperties withStartTickOffset(double startTickOffset) {
        this.startTickOffset = startTickOffset;
        return new AzAnimationStageProperties(this.animationSpeed, this.easingType, this.playBehavior, this.transitionLength, startTickOffset);
    }

    public AzPlayBehavior playBehavior() {
        return this.playBehavior == null ? DEFAULT.playBehavior() : this.playBehavior;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        AzAnimationStageProperties that = (AzAnimationStageProperties)object;
        return Objects.equals(this.playBehavior, that.playBehavior) && super.equals(object);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.playBehavior);
    }
}

