/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.animation.property;

import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import mod.azure.azurelib.rewrite.animation.easing.AzEasingType;
import mod.azure.azurelib.rewrite.animation.property.codec.AzAnimationPropertiesCodec;
import net.minecraft.class_2540;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AzAnimationProperties {
    public static final Function<class_2540, AzAnimationProperties> DECODER = AzAnimationPropertiesCodec.DECODER;
    public static final BiConsumer<class_2540, AzAnimationProperties> ENCODER = AzAnimationPropertiesCodec.ENCODER;
    public static final AzAnimationProperties DEFAULT = new AzAnimationProperties(1.0, null, Float.valueOf(0.0f), 0.0);
    public static final AzAnimationProperties EMPTY = new AzAnimationProperties(null, null, null, null);
    @Nullable
    protected Double animationSpeed;
    @Nullable
    protected AzEasingType easingType;
    @Nullable
    protected Float transitionLength;
    @Nullable
    protected Double startTickOffset;

    public AzAnimationProperties(@Nullable Double animationSpeed, @Nullable AzEasingType easingType, @Nullable Float transitionLength, @Nullable Double startTickOffset) {
        this.animationSpeed = animationSpeed;
        this.easingType = easingType;
        this.transitionLength = transitionLength;
        this.startTickOffset = startTickOffset;
    }

    public boolean hasAnimationSpeed() {
        return this.animationSpeed != null;
    }

    public boolean hasEasingType() {
        return this.easingType != null;
    }

    public boolean hasTransitionLength() {
        return this.transitionLength != null;
    }

    public boolean hasStartTickOffset() {
        return this.startTickOffset != null;
    }

    public AzAnimationProperties withAnimationSpeed(double animationSpeed) {
        this.animationSpeed = animationSpeed;
        return new AzAnimationProperties(animationSpeed, this.easingType, this.transitionLength, this.startTickOffset);
    }

    public AzAnimationProperties withEasingType(@NotNull AzEasingType easingType) {
        this.easingType = easingType;
        return new AzAnimationProperties(this.animationSpeed, easingType, this.transitionLength, this.startTickOffset);
    }

    public AzAnimationProperties withTransitionLength(float transitionLength) {
        this.transitionLength = Float.valueOf(transitionLength);
        return new AzAnimationProperties(this.animationSpeed, this.easingType, Float.valueOf(transitionLength), this.startTickOffset);
    }

    public AzAnimationProperties withStartTickOffset(double startTickOffset) {
        this.startTickOffset = startTickOffset;
        return new AzAnimationProperties(this.animationSpeed, this.easingType, this.transitionLength, startTickOffset);
    }

    public double animationSpeed() {
        return this.animationSpeed == null ? DEFAULT.animationSpeed() : this.animationSpeed.doubleValue();
    }

    public AzEasingType easingType() {
        return this.easingType;
    }

    public float transitionLength() {
        return this.transitionLength == null ? DEFAULT.transitionLength() : this.transitionLength.floatValue();
    }

    public double startTickOffset() {
        return this.startTickOffset == null ? DEFAULT.startTickOffset() : this.startTickOffset.doubleValue();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        AzAnimationProperties that = (AzAnimationProperties)object;
        return Objects.equals(this.animationSpeed, that.animationSpeed) && Objects.equals(this.easingType, that.easingType) && Objects.equals(this.transitionLength, that.transitionLength) && Objects.equals(this.startTickOffset, that.startTickOffset);
    }

    public int hashCode() {
        return Objects.hash(this.animationSpeed, this.easingType, this.transitionLength, this.startTickOffset);
    }
}

