/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.apexcore.registrate.builder;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.tterrag.registrate.builders.BuilderCallback;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.RegistrateItemModelProvider;
import com.tterrag.registrate.providers.RegistrateRecipeProvider;
import com.tterrag.registrate.util.CreativeModeTabModifier;
import com.tterrag.registrate.util.OneTimeEventReceiver;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import com.tterrag.registrate.util.nullness.NonNullUnaryOperator;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.registries.ForgeRegistries;
import xyz.apex.forge.apexcore.registrate.CoreRegistrate;
import xyz.apex.forge.apexcore.registrate.builder.AbstractBuilder;
import xyz.apex.forge.apexcore.registrate.builder.BlockBuilder;
import xyz.apex.forge.apexcore.registrate.builder.factory.ItemFactory;
import xyz.apex.forge.apexcore.registrate.entry.ItemEntry;

public final class ItemBuilder<OWNER extends CoreRegistrate<OWNER>, ITEM extends Item, PARENT>
extends AbstractBuilder<OWNER, Item, ITEM, PARENT, ItemBuilder<OWNER, ITEM, PARENT>, ItemEntry<ITEM>> {
    private final ItemFactory<ITEM> itemFactory;
    private NonNullSupplier<Item.Properties> initialProperties = Item.Properties::new;
    private NonNullFunction<Item.Properties, Item.Properties> propertiesModifier = NonNullUnaryOperator.identity();
    private NonNullSupplier<Supplier<ItemColor>> colorHandler = () -> () -> null;
    private Map<ResourceKey<CreativeModeTab>, Consumer<CreativeModeTabModifier>> creativeModeTabs = Maps.newLinkedHashMap();

    public ItemBuilder(OWNER owner, PARENT parent, String name, BuilderCallback callback, ItemFactory<ITEM> itemFactory) {
        super(owner, parent, name, callback, ForgeRegistries.Keys.ITEMS, (x$0, x$1) -> new ItemEntry((CoreRegistrate<?>)((CoreRegistrate)x$0), x$1), ItemEntry::cast);
        this.itemFactory = itemFactory;
        this.onRegister(item -> {
            DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> OneTimeEventReceiver.addModListener(this.getOwner(), RegisterColorHandlersEvent.Item.class, event -> {
                ItemColor colorHandler = (ItemColor)((Supplier)this.colorHandler.get()).get();
                if (colorHandler != null) {
                    event.register(colorHandler, new ItemLike[]{item});
                }
            }));
            this.creativeModeTabs.forEach(owner::modifyCreativeModeTab);
            this.creativeModeTabs.clear();
        });
    }

    public ItemBuilder<OWNER, ITEM, PARENT> properties(NonNullUnaryOperator<Item.Properties> propertiesModifier) {
        this.propertiesModifier = this.propertiesModifier.andThen(propertiesModifier);
        return this;
    }

    public ItemBuilder<OWNER, ITEM, PARENT> initialProperties(NonNullSupplier<Item.Properties> initialProperties) {
        this.initialProperties = initialProperties;
        return this;
    }

    public ItemBuilder<OWNER, ITEM, PARENT> tab(ResourceKey<CreativeModeTab> tab, Consumer<CreativeModeTabModifier> modifier) {
        this.creativeModeTabs.put(tab, modifier);
        return this;
    }

    public ItemBuilder<OWNER, ITEM, PARENT> tab(ResourceKey<CreativeModeTab> tab) {
        return this.tab(tab, modifier -> modifier.accept(this.asSupplier()));
    }

    public ItemBuilder<OWNER, ITEM, PARENT> removeTab(ResourceKey<CreativeModeTab> tab) {
        this.creativeModeTabs.remove(tab);
        return this;
    }

    public ItemBuilder<OWNER, ITEM, PARENT> color(NonNullSupplier<Supplier<ItemColor>> colorHandler) {
        this.colorHandler = colorHandler;
        return this;
    }

    public ItemBuilder<OWNER, ITEM, PARENT> defaultModel() {
        return this.model((ctx, provider) -> provider.generated((NonNullSupplier)ctx));
    }

    public ItemBuilder<OWNER, ITEM, PARENT> model(NonNullBiConsumer<DataGenContext<Item, ITEM>, RegistrateItemModelProvider> consumer) {
        return (ItemBuilder)this.setData(ProviderType.ITEM_MODEL, (NonNullBiConsumer)consumer);
    }

    public ItemBuilder<OWNER, ITEM, PARENT> defaultLang() {
        return (ItemBuilder)this.lang(Item::m_5524_);
    }

    public ItemBuilder<OWNER, ITEM, PARENT> lang(String name) {
        return (ItemBuilder)this.lang(Item::m_5524_, name);
    }

    public ItemBuilder<OWNER, ITEM, PARENT> recipe(NonNullBiConsumer<DataGenContext<Item, ITEM>, RegistrateRecipeProvider> consumer) {
        return (ItemBuilder)this.setData(ProviderType.RECIPE, (NonNullBiConsumer)consumer);
    }

    @SafeVarargs
    public final ItemBuilder<OWNER, ITEM, PARENT> tag(TagKey<Item> ... tags) {
        return (ItemBuilder)this.tag(ProviderType.ITEM_TAGS, tags);
    }

    @SafeVarargs
    public final ItemBuilder<OWNER, ITEM, PARENT> removeTag(TagKey<Item> ... tags) {
        return (ItemBuilder)this.removeTag(ProviderType.ITEM_TAGS, tags);
    }

    public ItemBuilder<OWNER, ITEM, PARENT> food(FoodProperties foodProperties) {
        return this.properties((NonNullUnaryOperator<Item.Properties>)((NonNullUnaryOperator)properties -> properties.m_41489_(foodProperties)));
    }

    public ItemBuilder<OWNER, ITEM, PARENT> stacksTo(int stackSize) {
        return this.properties((NonNullUnaryOperator<Item.Properties>)((NonNullUnaryOperator)properties -> properties.m_41487_(stackSize)));
    }

    public ItemBuilder<OWNER, ITEM, PARENT> defaultDurability(int durability) {
        return this.properties((NonNullUnaryOperator<Item.Properties>)((NonNullUnaryOperator)properties -> properties.m_41499_(durability)));
    }

    public ItemBuilder<OWNER, ITEM, PARENT> durability(int durability) {
        return this.properties((NonNullUnaryOperator<Item.Properties>)((NonNullUnaryOperator)properties -> properties.m_41503_(durability)));
    }

    @Deprecated
    public ItemBuilder<OWNER, ITEM, PARENT> craftRemainder(Item craftingRemainingItem) {
        return this.properties((NonNullUnaryOperator<Item.Properties>)((NonNullUnaryOperator)properties -> properties.m_41495_(craftingRemainingItem)));
    }

    public ItemBuilder<OWNER, ITEM, PARENT> craftRemainder(NonNullSupplier<? extends Item> craftingRemainingItem) {
        return this.properties((NonNullUnaryOperator<Item.Properties>)((NonNullUnaryOperator)properties -> properties.m_41495_((Item)craftingRemainingItem.get())));
    }

    public ItemBuilder<OWNER, ITEM, PARENT> rarity(Rarity rarity) {
        return this.properties((NonNullUnaryOperator<Item.Properties>)((NonNullUnaryOperator)properties -> properties.m_41497_(rarity)));
    }

    public ItemBuilder<OWNER, ITEM, PARENT> fireResistant() {
        return this.properties((NonNullUnaryOperator<Item.Properties>)((NonNullUnaryOperator)Item.Properties::m_41486_));
    }

    public ItemBuilder<OWNER, ITEM, PARENT> setNoRepair() {
        return this.properties((NonNullUnaryOperator<Item.Properties>)((NonNullUnaryOperator)Item.Properties::setNoRepair));
    }

    public ItemBuilder<OWNER, ITEM, PARENT> requiredFeatures(FeatureFlag ... flags) {
        return this.properties((NonNullUnaryOperator<Item.Properties>)((NonNullUnaryOperator)properties -> properties.m_246768_(flags)));
    }

    @Override
    protected ITEM createEntry() {
        Item.Properties properties = (Item.Properties)this.propertiesModifier.apply((Object)((Item.Properties)this.initialProperties.get()));
        return this.itemFactory.create(properties);
    }

    public static <OWNER extends CoreRegistrate<OWNER>, ITEM extends Item, PARENT> ItemBuilder<OWNER, ITEM, PARENT> applyDefaults(ItemBuilder<OWNER, ITEM, PARENT> builder) {
        return builder.defaultModel().defaultLang();
    }

    public static <OWNER extends CoreRegistrate<OWNER>, ITEM extends Item, PARENT> ItemBuilder<OWNER, ITEM, PARENT> applyBlockItemDefaults(ItemBuilder<OWNER, ITEM, PARENT> builder) {
        return ((ItemBuilder)((ItemBuilder)builder.transform(ItemBuilder::applyDefaults)).clearData(ProviderType.LANG)).model((ctx, provider) -> {
            Object patt7878$temp = builder.parent;
            if (patt7878$temp instanceof BlockBuilder) {
                BlockBuilder blockBuilder = (BlockBuilder)patt7878$temp;
                builder.owner.getDataProvider(ProviderType.BLOCKSTATE).flatMap(prov -> prov.getExistingVariantBuilder((Block)blockBuilder.getEntry())).map(bldr -> (BlockStateProvider.ConfiguredModelList)bldr.getModels().get(bldr.partialState())).map(BlockStateProvider.ConfiguredModelList::toJSON).filter(JsonElement::isJsonObject).map(JsonElement::getAsJsonObject).map(json -> json.get("model")).map(JsonElement::getAsString).ifPresentOrElse(str -> provider.withExistingParent(ctx.getName(), str), () -> provider.blockItem(builder.asSupplier()));
            } else {
                provider.blockItem(builder.asSupplier());
            }
        });
    }

    public static <OWNER extends CoreRegistrate<OWNER>, ITEM extends ForgeSpawnEggItem, PARENT> ItemBuilder<OWNER, ITEM, PARENT> applySpawnEggItemDefaults(ItemBuilder<OWNER, ITEM, PARENT> builder) {
        return ((ItemBuilder)builder.transform(ItemBuilder::applyDefaults)).tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256731_).model((ctx, provider) -> provider.withExistingParent(ctx.getName(), new ResourceLocation("minecraft", "item/template_spawn_egg")));
    }
}

