/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.apexcore.registrate.builder;

import com.tterrag.registrate.builders.BuilderCallback;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.loot.RegistrateEntityLootTables;
import com.tterrag.registrate.providers.loot.RegistrateLootTableProvider;
import com.tterrag.registrate.util.OneTimeEventReceiver;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import com.tterrag.registrate.util.nullness.NonNullUnaryOperator;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;
import xyz.apex.forge.apexcore.lib.util.RegistryHelper;
import xyz.apex.forge.apexcore.registrate.CoreRegistrate;
import xyz.apex.forge.apexcore.registrate.builder.AbstractBuilder;
import xyz.apex.forge.apexcore.registrate.builder.ItemBuilder;
import xyz.apex.forge.apexcore.registrate.builder.factory.EntityFactory;
import xyz.apex.forge.apexcore.registrate.entry.EntityEntry;
import xyz.apex.forge.apexcore.registrate.holder.ItemHolder;

public final class EntityBuilder<OWNER extends CoreRegistrate<OWNER>, ENTITY extends Entity, PARENT>
extends AbstractBuilder<OWNER, EntityType<?>, EntityType<ENTITY>, PARENT, EntityBuilder<OWNER, ENTITY, PARENT>, EntityEntry<ENTITY>> {
    public static final String SPAWN_EGG_SUFFIX = "_spawn_egg";
    private final EntityFactory<ENTITY> entityFactory;
    private MobCategory mobCategory = MobCategory.MISC;
    private NonNullUnaryOperator<EntityType.Builder<ENTITY>> builderModifier = NonNullUnaryOperator.identity();
    private Supplier<NonNullFunction<EntityRendererProvider.Context, EntityRenderer<? super ENTITY>>> rendererFactory = () -> null;
    private Supplier<AttributeSupplier.Builder> attributesFactory = () -> null;
    @Nullable
    private SpawnPlacementData<ENTITY> spawnPlacementData = null;

    public EntityBuilder(OWNER owner, PARENT parent, String name, BuilderCallback callback, EntityFactory<ENTITY> entityFactory) {
        super(owner, parent, name, callback, ForgeRegistries.Keys.ENTITY_TYPES, (x$0, x$1) -> new EntityEntry((CoreRegistrate<?>)((CoreRegistrate)x$0), x$1), EntityEntry::cast);
        this.entityFactory = entityFactory;
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> this.onRegister(entityType -> {
            OneTimeEventReceiver.addModListener(this.getOwner(), EntityRenderersEvent.RegisterRenderers.class, event -> {
                NonNullFunction<EntityRendererProvider.Context, EntityRenderer<? super ENTITY>> renderer = this.rendererFactory.get();
                if (renderer != null) {
                    try {
                        event.registerEntityRenderer(entityType, arg_0 -> renderer.apply(arg_0));
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("Failed to register renderer for Entity %s:%s".formatted(owner.modId, name), e);
                    }
                }
            });
            OneTimeEventReceiver.addModListener(this.getOwner(), EntityAttributeCreationEvent.class, event -> {
                AttributeSupplier.Builder attributeBuilder = this.attributesFactory.get();
                if (attributeBuilder != null) {
                    event.put(entityType, attributeBuilder.m_22265_());
                }
            });
            OneTimeEventReceiver.addModListener(this.getOwner(), FMLCommonSetupEvent.class, event -> event.enqueueWork(() -> {
                if (this.spawnPlacementData != null) {
                    EntityBuilder.registerEntitySpawnPlacements(entityType, this.spawnPlacementData);
                }
            }));
        }));
    }

    public EntityBuilder<OWNER, ENTITY, PARENT> properties(NonNullUnaryOperator<EntityType.Builder<ENTITY>> builderModifier) {
        this.builderModifier = this.builderModifier.andThen(builderModifier);
        return this;
    }

    public EntityBuilder<OWNER, ENTITY, PARENT> renderer(Supplier<NonNullFunction<EntityRendererProvider.Context, EntityRenderer<? super ENTITY>>> rendererFactory) {
        this.rendererFactory = rendererFactory;
        return this;
    }

    public EntityBuilder<OWNER, ENTITY, PARENT> attributes(Supplier<AttributeSupplier.Builder> attributesFactory) {
        this.attributesFactory = attributesFactory;
        return this;
    }

    public EntityBuilder<OWNER, ENTITY, PARENT> category(MobCategory mobCategory) {
        this.mobCategory = mobCategory;
        return this;
    }

    public EntityBuilder<OWNER, ENTITY, PARENT> spawnPlacement(SpawnPlacements.Type spawnPlacementType, Heightmap.Types heightMapType, SpawnPlacements.SpawnPredicate<ENTITY> spawnPredicate) {
        this.spawnPlacementData = new SpawnPlacementData<ENTITY>(spawnPlacementType, heightMapType, spawnPredicate);
        return this;
    }

    public EntityBuilder<OWNER, ENTITY, PARENT> spawnPlacement(SpawnPlacements.Type spawnPlacementType, Heightmap.Types heightMapType) {
        return this.spawnPlacement(spawnPlacementType, heightMapType, (entityType, level, spawnType, pos, rng) -> ((EntityEntry)((Object)((Object)this.get()))).isIn(entityType));
    }

    public EntityBuilder<OWNER, ENTITY, PARENT> defaultSpawnEgg(int backgroundColor, int highlightColor) {
        return (EntityBuilder)this.spawnEgg(backgroundColor, highlightColor).build();
    }

    public ItemBuilder<OWNER, ForgeSpawnEggItem, EntityBuilder<OWNER, ENTITY, PARENT>> spawnEgg(int backgroundColor, int highlightColor) {
        return (ItemBuilder)((ItemHolder)((Object)this.owner)).item(this, "%s%s".formatted(this.name, SPAWN_EGG_SUFFIX), properties -> new ForgeSpawnEggItem(this.asSupplier(), backgroundColor, highlightColor, properties)).transform(ItemBuilder::applySpawnEggItemDefaults);
    }

    public EntityBuilder<OWNER, ENTITY, PARENT> defaultLang() {
        return (EntityBuilder)this.lang(EntityType::m_20675_);
    }

    public EntityBuilder<OWNER, ENTITY, PARENT> lang(String name) {
        return (EntityBuilder)this.lang(EntityType::m_20675_, name);
    }

    public EntityBuilder<OWNER, ENTITY, PARENT> loot(NonNullBiConsumer<RegistrateEntityLootTables, EntityType<ENTITY>> consumer) {
        return (EntityBuilder)this.setData(ProviderType.LOOT, (ctx, provider) -> provider.addLootAction(RegistrateLootTableProvider.LootType.ENTITY, lootTables -> consumer.accept(lootTables, (Object)((EntityType)ctx.get()))));
    }

    public EntityBuilder<OWNER, ENTITY, PARENT> sized(float width, float height) {
        return this.properties(properties -> properties.m_20699_(width, height));
    }

    public EntityBuilder<OWNER, ENTITY, PARENT> noSummon() {
        return this.properties(EntityType.Builder::m_20698_);
    }

    public EntityBuilder<OWNER, ENTITY, PARENT> noSave() {
        return this.properties(EntityType.Builder::m_20716_);
    }

    public EntityBuilder<OWNER, ENTITY, PARENT> fireImmune() {
        return this.properties(EntityType.Builder::m_20719_);
    }

    public EntityBuilder<OWNER, ENTITY, PARENT> immuneTo(Block ... blocks) {
        return this.properties(properties -> properties.m_20714_(blocks));
    }

    public EntityBuilder<OWNER, ENTITY, PARENT> canSpawnFarFromPlayer() {
        return this.properties(EntityType.Builder::m_20720_);
    }

    public EntityBuilder<OWNER, ENTITY, PARENT> clientTrackingRange(int clientTrackingRange) {
        return this.properties(properties -> properties.m_20702_(clientTrackingRange));
    }

    public EntityBuilder<OWNER, ENTITY, PARENT> updateInterval(int updateInterval) {
        return this.properties(properties -> properties.m_20717_(updateInterval));
    }

    public EntityBuilder<OWNER, ENTITY, PARENT> setUpdateInterval(int interval) {
        return this.properties(properties -> properties.setUpdateInterval(interval));
    }

    public EntityBuilder<OWNER, ENTITY, PARENT> setTrackingRange(int range) {
        return this.properties(properties -> properties.setTrackingRange(range));
    }

    public EntityBuilder<OWNER, ENTITY, PARENT> setShouldReceiveVelocityUpdates(boolean value) {
        return this.properties(properties -> properties.setShouldReceiveVelocityUpdates(value));
    }

    public EntityBuilder<OWNER, ENTITY, PARENT> setCustomClientFactory(BiFunction<PlayMessages.SpawnEntity, Level, ENTITY> customClientFactory) {
        return this.properties(properties -> properties.setCustomClientFactory(customClientFactory));
    }

    @SafeVarargs
    public final EntityBuilder<OWNER, ENTITY, PARENT> tag(TagKey<EntityType<?>> ... tags) {
        return (EntityBuilder)this.tag(ProviderType.ENTITY_TAGS, tags);
    }

    @SafeVarargs
    public final EntityBuilder<OWNER, ENTITY, PARENT> removeTag(TagKey<EntityType<?>> ... tags) {
        return (EntityBuilder)this.removeTag(ProviderType.ENTITY_TAGS, tags);
    }

    @Override
    protected EntityType<ENTITY> createEntry() {
        return ((EntityType.Builder)this.builderModifier.apply((Object)EntityType.Builder.m_20704_(this.entityFactory, (MobCategory)this.mobCategory))).m_20712_("%s:%s".formatted(this.owner.modId, this.name));
    }

    public static <ENTITY extends Entity> void registerEntitySpawnPlacements(EntityType<ENTITY> entityType, SpawnPlacementData<ENTITY> spawnPlacementData) {
        SpawnPlacements.Data existingData = SpawnPlacements.f_21750_.put(entityType, spawnPlacementData.toVanillaData());
        if (existingData != null) {
            throw new IllegalStateException("Duplicate SpawnPlacement registration for type: %s".formatted(RegistryHelper.getRegistryName(ForgeRegistries.ENTITY_TYPES, entityType)));
        }
    }

    private record SpawnPlacementData<ENTITY extends Entity>(SpawnPlacements.Type spawnPlacementType, Heightmap.Types heightMapType, SpawnPlacements.SpawnPredicate<ENTITY> spawnPredicate) {
        public SpawnPlacements.Data toVanillaData() {
            return new SpawnPlacements.Data(this.heightMapType, this.spawnPlacementType, this.spawnPredicate);
        }
    }
}

