/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.apexcore.registrate;

import com.google.common.annotations.Beta;
import com.google.errorprone.annotations.OverridingMethodsMustInvokeSuper;
import com.tterrag.registrate.AbstractRegistrate;
import com.tterrag.registrate.builders.Builder;
import com.tterrag.registrate.builders.BuilderCallback;
import com.tterrag.registrate.builders.NoConfigBuilder;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.RegistrateLangProvider;
import com.tterrag.registrate.providers.RegistrateProvider;
import com.tterrag.registrate.util.CreativeModeTabModifier;
import com.tterrag.registrate.util.OneTimeEventReceiver;
import com.tterrag.registrate.util.entry.RegistryEntry;
import com.tterrag.registrate.util.nullness.NonNullBiFunction;
import com.tterrag.registrate.util.nullness.NonNullConsumer;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import com.tterrag.registrate.util.nullness.NonNullUnaryOperator;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.NewRegistryEvent;
import net.minecraftforge.registries.RegistryBuilder;
import org.jetbrains.annotations.ApiStatus;
import xyz.apex.forge.apexcore.registrate.entry.ForgeRegistryEntry;

public class CoreRegistrate<OWNER extends CoreRegistrate<OWNER>> {
    @ApiStatus.Internal
    public final Backend backend;
    protected final OWNER self = this;
    public final String modId;

    protected CoreRegistrate(String modId) {
        this.modId = modId;
        this.backend = new Backend();
    }

    @OverridingMethodsMustInvokeSuper
    protected OWNER registerEventListeners(IEventBus bus) {
        this.backend.registerEventListeners(bus);
        return this.self;
    }

    public final String getModId() {
        return this.modId;
    }

    public final Backend getBackend() {
        return this.backend;
    }

    public final String currentName() {
        return this.backend.currentName();
    }

    public final ResourceKey<CreativeModeTab> currentCreativeModeTab() {
        return this.backend.currentCreativeModeTab;
    }

    public final <TYPE, VALUE extends TYPE> RegistryEntry<VALUE> get(ResourceKey<? extends Registry<TYPE>> registryType) {
        return this.backend.get(registryType);
    }

    public final <TYPE, VALUE extends TYPE> RegistryEntry<VALUE> get(String name, ResourceKey<? extends Registry<TYPE>> registryType) {
        return this.backend.get(name, registryType);
    }

    @Beta
    public final <TYPE, VALUE extends TYPE> RegistryEntry<VALUE> getOptional(String name, ResourceKey<? extends Registry<TYPE>> registryType) {
        return this.backend.getOptional(name, registryType);
    }

    public final <TYPE> Collection<RegistryEntry<TYPE>> getAll(ResourceKey<? extends Registry<TYPE>> registryType) {
        return this.backend.getAll(registryType);
    }

    public final <TYPE, VALUE extends TYPE> OWNER addRegisterCallback(String name, ResourceKey<? extends Registry<TYPE>> registryType, NonNullConsumer<? super VALUE> callback) {
        this.backend.addRegisterCallback(name, registryType, callback);
        return this.self;
    }

    public final <TYPE> OWNER addRegisterCallback(ResourceKey<? extends Registry<TYPE>> registryType, Runnable callback) {
        this.backend.addRegisterCallback(registryType, callback);
        return this.self;
    }

    public final <TYPE> boolean isRegistered(ResourceKey<? extends Registry<TYPE>> registryType) {
        return this.backend.isRegistered(registryType);
    }

    public final <PROVIDER extends RegistrateProvider> Optional<PROVIDER> getDataProvider(ProviderType<PROVIDER> providerType) {
        return this.backend.getDataProvider(providerType);
    }

    public final <PROVIDER extends RegistrateProvider, TYPE> OWNER setDataGenerator(Builder<TYPE, ?, ?, ?> builder, ProviderType<PROVIDER> providerType, NonNullConsumer<? extends PROVIDER> consumer) {
        this.backend.setDataGenerator(builder, providerType, consumer);
        return this.self;
    }

    public final <PROVIDER extends RegistrateProvider, TYPE> OWNER setDataGenerator(String name, ResourceKey<? extends Registry<TYPE>> registryType, ProviderType<PROVIDER> providerType, NonNullConsumer<? extends PROVIDER> consumer) {
        this.backend.setDataGenerator(name, registryType, providerType, consumer);
        return this.self;
    }

    public final <PROVIDER extends RegistrateProvider> OWNER addDataGenerator(ProviderType<PROVIDER> providerType, NonNullConsumer<? extends PROVIDER> consumer) {
        this.backend.addDataGenerator(providerType, consumer);
        return this.self;
    }

    public final MutableComponent addLang(String type, ResourceLocation id, String localizedName) {
        return this.backend.addLang(type, id, localizedName);
    }

    public final MutableComponent addLang(String type, ResourceLocation id, String suffix, String localizedName) {
        return this.backend.addLang(type, id, suffix, localizedName);
    }

    public final MutableComponent addRawLang(String key, String value) {
        return this.backend.addRawLang(key, value);
    }

    public final <PROVIDER extends RegistrateProvider> void generateData(ProviderType<? extends PROVIDER> providerType, PROVIDER provider) {
        this.backend.genData(providerType, provider);
    }

    public final OWNER skipErrors(boolean skipErrors) {
        this.backend.skipErrors(skipErrors);
        return this.self;
    }

    public final OWNER skipErrors() {
        return this.skipErrors(true);
    }

    public final OWNER object(String name) {
        this.backend.object(name);
        return this.self;
    }

    public final OWNER defaultCreativeModeTab(ResourceKey<CreativeModeTab> creativeModeTab) {
        this.backend.defaultCreativeTab((ResourceKey)creativeModeTab);
        return this.self;
    }

    public final OWNER defaultCreativeModeTab() {
        return this.defaultCreativeModeTab(this.currentName(), config -> {});
    }

    public final OWNER defaultCreativeModeTab(String name) {
        return this.defaultCreativeModeTab(name, config -> {});
    }

    public final OWNER defaultCreativeModeTab(Consumer<CreativeModeTab.Builder> config) {
        return this.defaultCreativeModeTab(this.currentName(), config);
    }

    public final OWNER defaultCreativeModeTab(String name, Consumer<CreativeModeTab.Builder> config) {
        RegistryEntry registryEntry = this.simple((Object)name, (ResourceKey)Registries.f_279569_, (NonNullSupplier)() -> {
            CreativeModeTab.Builder builder = CreativeModeTab.builder().m_257737_(() -> this.getAll(Registries.f_256913_).stream().filter(entry -> entry instanceof ItemLike).map(entry -> (ItemLike)entry).findFirst().map(ItemStack::new).orElse(ItemStack.f_41583_)).m_257941_((Component)this.addLang("itemGroup", new ResourceLocation(this.modId, name), RegistrateLangProvider.toEnglishName((String)name)));
            config.accept(builder);
            return builder.m_257652_();
        });
        return this.defaultCreativeModeTab((ResourceKey<CreativeModeTab>)registryEntry.getKey());
    }

    public final OWNER modifyCreativeModeTab(ResourceKey<CreativeModeTab> creativeModeTab, Consumer<CreativeModeTabModifier> modifier) {
        this.backend.modifyCreativeModeTab(creativeModeTab, modifier);
        return this.self;
    }

    public final OWNER transform(NonNullUnaryOperator<OWNER> func) {
        return (OWNER)((CoreRegistrate)func.apply(this.self));
    }

    public final <TYPE, VALUE extends TYPE, PARENT, BUILDER extends Builder<TYPE, VALUE, PARENT, BUILDER>> BUILDER transform(NonNullFunction<OWNER, BUILDER> function) {
        return (BUILDER)((Builder)function.apply(this.self));
    }

    public final <TYPE, VALUE extends TYPE, PARENT, BUILDER extends Builder<TYPE, VALUE, PARENT, BUILDER>> BUILDER entry(NonNullBiFunction<String, BuilderCallback, BUILDER> factory) {
        return (BUILDER)this.backend.entry(factory);
    }

    public final <TYPE, VALUE extends TYPE, PARENT, BUILDER extends Builder<TYPE, VALUE, PARENT, BUILDER>> BUILDER entry(String name, NonNullFunction<BuilderCallback, BUILDER> factory) {
        return (BUILDER)this.backend.entry(name, factory);
    }

    @Deprecated
    public final <TYPE> ResourceKey<Registry<TYPE>> makeRegistry(String name, Supplier<RegistryBuilder<TYPE>> registryBuilderFactory) {
        return this.backend.makeRegistry(name, registryBuilderFactory);
    }

    @Beta
    @ApiStatus.Experimental
    public final <TYPE> ForgeRegistryEntry<TYPE> createRegistry(String name, NonNullUnaryOperator<RegistryBuilder<TYPE>> registryBuilderModifier) {
        ResourceKey registryType = ResourceKey.m_135788_((ResourceLocation)new ResourceLocation(this.modId, name));
        AtomicReference forgeRegistryHolder = new AtomicReference();
        OneTimeEventReceiver.addModListener((AbstractRegistrate)this.backend, NewRegistryEvent.class, event -> {
            RegistryBuilder registryBuilder = ((RegistryBuilder)registryBuilderModifier.apply((Object)new RegistryBuilder())).setName(registryType.m_135782_());
            event.create(registryBuilder, forgeRegistryHolder::set);
        });
        return new ForgeRegistryEntry((CoreRegistrate<?>)this.self, registryType, forgeRegistryHolder::get);
    }

    @Beta
    @ApiStatus.Experimental
    public final <TYPE> ForgeRegistryEntry<TYPE> createRegistry(NonNullUnaryOperator<RegistryBuilder<TYPE>> registryBuilderModifier) {
        return this.createRegistry(this.currentName(), registryBuilderModifier);
    }

    @Beta
    @ApiStatus.Experimental
    public final <TYPE> ForgeRegistryEntry<TYPE> createRegistry(String name) {
        return this.createRegistry(name, builder -> builder);
    }

    @Beta
    @ApiStatus.Experimental
    public final <TYPE> ForgeRegistryEntry<TYPE> createRegistry() {
        return this.createRegistry(this.currentName(), builder -> builder);
    }

    public final <TYPE, VALUE extends TYPE> RegistryEntry<VALUE> simple(ResourceKey<Registry<TYPE>> registryType, NonNullSupplier<VALUE> factory) {
        return this.simple(this.self, this.currentName(), registryType, factory);
    }

    public final <TYPE, VALUE extends TYPE> RegistryEntry<VALUE> simple(String name, ResourceKey<Registry<TYPE>> registryType, NonNullSupplier<VALUE> factory) {
        return this.simple(this.self, name, registryType, factory);
    }

    public final <TYPE, VALUE extends TYPE, P> RegistryEntry<VALUE> simple(P parent, ResourceKey<Registry<TYPE>> registryType, NonNullSupplier<VALUE> factory) {
        return this.simple(parent, this.currentName(), registryType, factory);
    }

    public final <TYPE, VALUE extends TYPE, P> RegistryEntry<VALUE> simple(P parent, String name, ResourceKey<Registry<TYPE>> registryType, NonNullSupplier<VALUE> factory) {
        return ((NoConfigBuilder)this.entry(name, callback -> new NoConfigBuilder((AbstractRegistrate)this.backend, parent, name, callback, registryType, factory))).register();
    }

    public final class Backend
    extends AbstractRegistrate<Backend> {
        private ResourceKey<CreativeModeTab> currentCreativeModeTab;

        private Backend() {
            super(CoreRegistrate.this.modId);
            this.currentCreativeModeTab = CreativeModeTabs.f_256750_;
        }

        protected Backend registerEventListeners(IEventBus bus) {
            return (Backend)super.registerEventListeners(bus);
        }

        protected String currentName() {
            return super.currentName();
        }

        public Backend defaultCreativeTab(ResourceKey<CreativeModeTab> creativeModeTab) {
            this.currentCreativeModeTab = creativeModeTab;
            return (Backend)super.defaultCreativeTab(creativeModeTab);
        }

        public <P> NoConfigBuilder<CreativeModeTab, CreativeModeTab, P> defaultCreativeTab(P parent, String name, Consumer<CreativeModeTab.Builder> config) {
            this.defaultCreativeTab(ResourceKey.m_135785_((ResourceKey)Registries.f_279569_, (ResourceLocation)new ResourceLocation(CoreRegistrate.this.modId, name)));
            return super.defaultCreativeTab(parent, name, config);
        }
    }
}

