/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.apexcore.lib.block;

import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.Nullable;
import xyz.apex.forge.apexcore.lib.block.BaseBlock;
import xyz.apex.forge.apexcore.lib.block.IMultiBlock;
import xyz.apex.forge.apexcore.lib.block.MultiBlockPattern;

public abstract class BaseMultiBlock
extends BaseBlock
implements IMultiBlock {
    public BaseMultiBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_(this.getMultiBlockPattern().registerDefaultState(this.m_49966_()));
    }

    @Override
    public final Block m_7374_() {
        return super.m_7374_();
    }

    @Override
    @Nullable
    protected BlockState modifyPlacementState(BlockState placementBlockState, BlockPlaceContext ctx) {
        BlockState blockState = super.modifyPlacementState(placementBlockState, ctx);
        if (blockState == null) {
            return null;
        }
        return this.getMultiBlockPattern().getStateForPlacement(this, blockState, ctx);
    }

    @MustBeInvokedByOverriders
    public boolean m_7898_(BlockState blockState, LevelReader level, BlockPos pos) {
        MultiBlockPattern pattern = this.getMultiBlockPattern();
        if (!pattern.canSurvive(this, level, pos, blockState)) {
            return false;
        }
        return super.m_7898_(blockState, level, pos);
    }

    @MustBeInvokedByOverriders
    public void m_6807_(BlockState blockState, Level level, BlockPos pos, BlockState oldBlockState, boolean isMoving) {
        this.getMultiBlockPattern().onPlace(this, blockState, level, pos, oldBlockState);
    }

    @MustBeInvokedByOverriders
    public void m_6810_(BlockState blockState, Level level, BlockPos pos, BlockState newBlockState, boolean isMoving) {
        this.getMultiBlockPattern().onRemove(this, blockState, level, pos, newBlockState);
        super.m_6810_(blockState, level, pos, newBlockState, isMoving);
    }

    @Override
    @MustBeInvokedByOverriders
    protected void registerProperties(Consumer<Property<?>> consumer) {
        super.registerProperties(consumer);
        this.getMultiBlockPattern().registerProperties(consumer);
    }

    public RenderShape m_7514_(BlockState blockState) {
        int index = this.getMultiBlockIndex(blockState);
        return index == this.getMultiBlockRenderModelIndex() ? RenderShape.MODEL : RenderShape.INVISIBLE;
    }

    public static abstract class WithContainer<BLOCK_ENTITY extends BlockEntity, CONTAINER extends AbstractContainerMenu>
    extends BaseBlock.WithContainer<BLOCK_ENTITY, CONTAINER>
    implements IMultiBlock {
        public WithContainer(BlockBehaviour.Properties properties) {
            super(properties);
        }

        @Override
        public final Block m_7374_() {
            return super.m_7374_();
        }

        @Override
        @Nullable
        protected BlockState modifyPlacementState(BlockState placementBlockState, BlockPlaceContext ctx) {
            BlockState blockState = super.modifyPlacementState(placementBlockState, ctx);
            if (blockState == null) {
                return null;
            }
            return this.getMultiBlockPattern().getStateForPlacement(this, blockState, ctx);
        }

        @MustBeInvokedByOverriders
        public boolean m_7898_(BlockState blockState, LevelReader level, BlockPos pos) {
            MultiBlockPattern pattern = this.getMultiBlockPattern();
            if (!pattern.canSurvive(this, level, pos, blockState)) {
                return false;
            }
            return super.m_7898_(blockState, level, pos);
        }

        @MustBeInvokedByOverriders
        public void m_6807_(BlockState blockState, Level level, BlockPos pos, BlockState oldBlockState, boolean isMoving) {
            this.getMultiBlockPattern().onPlace(this, blockState, level, pos, oldBlockState);
        }

        @Override
        @MustBeInvokedByOverriders
        public void m_6810_(BlockState blockState, Level level, BlockPos pos, BlockState newBlockState, boolean isMoving) {
            this.getMultiBlockPattern().onRemove(this, blockState, level, pos, newBlockState);
            super.m_6810_(blockState, level, pos, newBlockState, isMoving);
        }

        @Override
        @MustBeInvokedByOverriders
        protected void registerProperties(Consumer<Property<?>> consumer) {
            super.registerProperties(consumer);
            this.getMultiBlockPattern().registerProperties(consumer);
        }

        public RenderShape m_7514_(BlockState blockState) {
            int index = this.getMultiBlockIndex(blockState);
            return index == this.getMultiBlockRenderModelIndex() ? RenderShape.MODEL : RenderShape.INVISIBLE;
        }
    }

    public static abstract class WithBlockEntity<BLOCK_ENTITY extends BlockEntity>
    extends BaseBlock.WithBlockEntity<BLOCK_ENTITY>
    implements IMultiBlock {
        public WithBlockEntity(BlockBehaviour.Properties properties) {
            super(properties);
        }

        @Override
        public final Block m_7374_() {
            return super.m_7374_();
        }

        @Override
        @Nullable
        protected BlockState modifyPlacementState(BlockState placementBlockState, BlockPlaceContext ctx) {
            BlockState blockState = super.modifyPlacementState(placementBlockState, ctx);
            if (blockState == null) {
                return null;
            }
            return this.getMultiBlockPattern().getStateForPlacement(this, blockState, ctx);
        }

        @MustBeInvokedByOverriders
        public boolean m_7898_(BlockState blockState, LevelReader level, BlockPos pos) {
            MultiBlockPattern pattern = this.getMultiBlockPattern();
            if (!pattern.canSurvive(this, level, pos, blockState)) {
                return false;
            }
            return super.m_7898_(blockState, level, pos);
        }

        @MustBeInvokedByOverriders
        public void m_6807_(BlockState blockState, Level level, BlockPos pos, BlockState oldBlockState, boolean isMoving) {
            this.getMultiBlockPattern().onPlace(this, blockState, level, pos, oldBlockState);
        }

        @MustBeInvokedByOverriders
        public void m_6810_(BlockState blockState, Level level, BlockPos pos, BlockState newBlockState, boolean isMoving) {
            this.getMultiBlockPattern().onRemove(this, blockState, level, pos, newBlockState);
            super.m_6810_(blockState, level, pos, newBlockState, isMoving);
        }

        @Override
        @MustBeInvokedByOverriders
        protected void registerProperties(Consumer<Property<?>> consumer) {
            super.registerProperties(consumer);
            this.getMultiBlockPattern().registerProperties(consumer);
        }

        public RenderShape m_7514_(BlockState blockState) {
            int index = this.getMultiBlockIndex(blockState);
            return index == this.getMultiBlockRenderModelIndex() ? RenderShape.MODEL : RenderShape.INVISIBLE;
        }
    }
}

