/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.utils;

import com.almostreliable.unified.utils.JsonQuery;
import com.almostreliable.unified.utils.JsonUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public final class JsonCompare {
    private static final Set<String> SANITIZE_KEYS = Set.of("item", "tag", "id");

    private JsonCompare() {
    }

    public static int compare(JsonObject first, JsonObject second, Map<String, Rule> rules) {
        for (Map.Entry<String, Rule> entry : rules.entrySet()) {
            int compareIndex;
            JsonElement fElement = first.get(entry.getKey());
            JsonElement sElement = second.get(entry.getKey());
            if (fElement == null && sElement == null || (compareIndex = entry.getValue().compare(fElement, sElement)) == 0) continue;
            return compareIndex;
        }
        return 0;
    }

    public static JsonObject compare(Map<String, Rule> rules, JsonObject ... jsonObjects) {
        List<JsonObject> unsorted = Arrays.asList(jsonObjects);
        unsorted.sort((f, s) -> JsonCompare.compare(f, s, rules));
        return unsorted.get(0);
    }

    @Nullable
    public static JsonObject compareShaped(JsonObject first, JsonObject second, CompareContext compareContext) {
        if (!JsonCompare.matches(first, second, compareContext)) {
            return null;
        }
        JsonArray firstPattern = JsonUtils.arrayOrSelf(first.get("pattern"));
        JsonArray secondPattern = JsonUtils.arrayOrSelf(second.get("pattern"));
        if (firstPattern.size() != secondPattern.size()) {
            return null;
        }
        for (int i = 0; i < firstPattern.size(); ++i) {
            if (JsonUtils.stringOrSelf(firstPattern.get(i)).length() == JsonUtils.stringOrSelf(secondPattern.get(i)).length()) continue;
            return null;
        }
        Map<Character, JsonObject> firstKeyMap = JsonCompare.createShapedKeyMap(first);
        Map<Character, JsonObject> secondKeyMap = JsonCompare.createShapedKeyMap(second);
        for (int i = 0; i < firstPattern.size(); ++i) {
            String firstPatternString = JsonUtils.stringOrSelf(firstPattern.get(i));
            String secondPatternString = JsonUtils.stringOrSelf(secondPattern.get(i));
            for (int j = 0; j < firstPatternString.length(); ++j) {
                char firstChar = firstPatternString.charAt(j);
                char secondChar = secondPatternString.charAt(j);
                if (firstChar == ' ' && secondChar == ' ') continue;
                if (!firstKeyMap.containsKey(Character.valueOf(firstChar)) || !secondKeyMap.containsKey(Character.valueOf(secondChar))) {
                    return null;
                }
                if (firstKeyMap.get(Character.valueOf(firstChar)).equals((Object)secondKeyMap.get(Character.valueOf(secondChar)))) continue;
                return null;
            }
        }
        return first;
    }

    private static Map<Character, JsonObject> createShapedKeyMap(JsonObject json) {
        JsonObject keys = JsonUtils.objectOrSelf(json.get("key"));
        HashMap<Character, JsonObject> keyMap = new HashMap<Character, JsonObject>();
        for (Map.Entry patterKey : keys.entrySet()) {
            char c = ((String)patterKey.getKey()).charAt(0);
            if (c == ' ') continue;
            keyMap.put(Character.valueOf(c), JsonUtils.objectOrSelf((JsonElement)patterKey.getValue()));
        }
        return keyMap;
    }

    public static boolean matches(JsonObject first, JsonObject second, CompareContext compareContext) {
        CompareSettings compareSettings = compareContext.settings;
        if (!compareSettings.hasIgnoredFields() && first.size() != second.size()) {
            return false;
        }
        for (String field : compareContext.compareFields()) {
            JsonElement secondElem = second.get(field);
            if (secondElem == null) {
                return false;
            }
            JsonElement firstElem = first.get(field);
            if (compareSettings.shouldSanitize && JsonCompare.needsSanitizing(firstElem, secondElem)) {
                firstElem = JsonCompare.sanitize(firstElem);
                secondElem = JsonCompare.sanitize(secondElem);
            }
            if (firstElem.equals(secondElem)) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean needsSanitizing(JsonElement firstElem, JsonElement secondElem) {
        if (firstElem instanceof JsonArray) {
            JsonArray firstArray = (JsonArray)firstElem;
            if (secondElem instanceof JsonArray) {
                JsonArray secondArray = (JsonArray)secondElem;
                if (firstArray.size() == secondArray.size()) return true;
            }
        }
        if (firstElem instanceof JsonObject) {
            if (secondElem instanceof JsonObject) return true;
        }
        if (firstElem instanceof JsonPrimitive) {
            if (secondElem instanceof JsonObject) return true;
        }
        if (!(firstElem instanceof JsonObject)) return false;
        if (!(secondElem instanceof JsonPrimitive)) return false;
        return true;
    }

    private static JsonElement createSanitizedObjectOrDefault(JsonElement value, JsonElement defaultValue) {
        JsonPrimitive primitive;
        if (value instanceof JsonPrimitive && (primitive = (JsonPrimitive)value).isString()) {
            JsonObject newObject = new JsonObject();
            newObject.addProperty("au_sanitized", primitive.getAsString());
            newObject.addProperty("count", (Number)1);
            return newObject;
        }
        return defaultValue;
    }

    private static JsonElement sanitize(JsonElement element) {
        if (element instanceof JsonArray) {
            JsonArray jsonArray = (JsonArray)element;
            JsonArray newArray = new JsonArray();
            for (JsonElement arrayElement : jsonArray) {
                newArray.add(JsonCompare.sanitize(arrayElement));
            }
            return newArray;
        }
        if (element instanceof JsonObject) {
            JsonObject jsonObject = (JsonObject)element;
            Set keySet = jsonObject.keySet();
            if (keySet.stream().filter(SANITIZE_KEYS::contains).count() != 1L) {
                return element;
            }
            if (keySet.contains("count") && JsonQuery.of((JsonElement)jsonObject, "count").asInt().filter(i -> i == 1).isEmpty()) {
                return element;
            }
            String key = keySet.stream().filter(SANITIZE_KEYS::contains).findFirst().orElseThrow();
            JsonElement sanitized = JsonCompare.createSanitizedObjectOrDefault(jsonObject.get(key), (JsonElement)jsonObject);
            if (sanitized == jsonObject || !(sanitized instanceof JsonObject)) {
                return jsonObject;
            }
            JsonObject sanitizedObject = (JsonObject)sanitized;
            JsonCompare.mergeRemainingProperties(jsonObject, sanitizedObject);
            return sanitizedObject;
        }
        return JsonCompare.createSanitizedObjectOrDefault(element, element);
    }

    private static void mergeRemainingProperties(JsonObject jsonObject, JsonObject sanitizedObject) {
        for (Map.Entry entry : jsonObject.entrySet()) {
            if (SANITIZE_KEYS.contains(entry.getKey()) || ((String)entry.getKey()).equals("count")) continue;
            sanitizedObject.add((String)entry.getKey(), (JsonElement)entry.getValue());
        }
    }

    public static interface Rule {
        public int compare(@Nullable JsonElement var1, @Nullable JsonElement var2);

        public String getName();
    }

    public record CompareContext(CompareSettings settings, List<String> compareFields) {
        public static CompareContext create(CompareSettings settings, JsonObject curRecipe) {
            HashSet compareFields = curRecipe.keySet();
            if (settings.hasIgnoredFields()) {
                compareFields = new HashSet(compareFields);
                compareFields.removeAll(settings.ignoredFields);
            }
            return new CompareContext(settings, List.copyOf(compareFields));
        }
    }

    public static class CompareSettings {
        public static final String IGNORED_FIELDS = "ignoredFields";
        public static final String RULES = "rules";
        public static final String SHOULD_SANITIZE = "shouldSanitize";
        private final LinkedHashMap<String, Rule> rules = new LinkedHashMap();
        private final Set<String> ignoredFields = new HashSet<String>();
        private boolean shouldSanitize;

        public void ignoreField(String property) {
            this.ignoredFields.add(property);
        }

        public void addRule(String key, Rule rule) {
            Rule old = this.rules.put(key, rule);
            this.ignoreField(key);
            if (old != null) {
                throw new IllegalStateException("Multiple rule for key <" + key + "> found");
            }
        }

        public void setShouldSanitize(boolean shouldSanitize) {
            this.shouldSanitize = shouldSanitize;
        }

        public boolean hasIgnoredFields() {
            return !this.ignoredFields.isEmpty();
        }

        public JsonObject serialize() {
            JsonObject result = new JsonObject();
            JsonArray ignoredFieldsArray = new JsonArray();
            this.ignoredFields.stream().filter(f -> !this.rules.containsKey(f)).forEach(arg_0 -> ((JsonArray)ignoredFieldsArray).add(arg_0));
            result.add(IGNORED_FIELDS, (JsonElement)ignoredFieldsArray);
            JsonObject rulesJson = new JsonObject();
            this.rules.forEach((s, rule) -> rulesJson.addProperty(s, rule.getName()));
            result.add(RULES, (JsonElement)rulesJson);
            result.addProperty(SHOULD_SANITIZE, Boolean.valueOf(this.shouldSanitize));
            return result;
        }

        public void deserialize(JsonObject json) {
            json.getAsJsonArray(IGNORED_FIELDS).forEach(e -> this.ignoreField(e.getAsString()));
            json.getAsJsonObject(RULES).entrySet().forEach(e -> {
                Rule r = switch (((JsonElement)e.getValue()).getAsString()) {
                    case "HigherRule" -> new HigherRule();
                    case "LowerRule" -> new LowerRule();
                    default -> throw new IllegalArgumentException("Unknown rule <" + ((JsonElement)e.getValue()).getAsString() + ">");
                };
                this.addRule((String)e.getKey(), r);
            });
            this.shouldSanitize = json.getAsJsonPrimitive(SHOULD_SANITIZE).getAsBoolean();
        }

        public Map<String, Rule> getRules() {
            return this.rules;
        }
    }

    public static class HigherRule
    implements Rule {
        public static final String NAME = "HigherRule";

        @Override
        public int compare(@Nullable JsonElement first, @Nullable JsonElement second) {
            double d;
            double firstValue;
            if (first instanceof JsonPrimitive) {
                JsonPrimitive fp = (JsonPrimitive)first;
                v0 = fp.getAsDouble();
            } else {
                v0 = firstValue = 0.0;
            }
            if (second instanceof JsonPrimitive) {
                JsonPrimitive sp = (JsonPrimitive)second;
                d = sp.getAsDouble();
            } else {
                d = 0.0;
            }
            double secondValue = d;
            return Double.compare(secondValue, firstValue);
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class LowerRule
    implements Rule {
        public static final String NAME = "LowerRule";

        @Override
        public int compare(@Nullable JsonElement first, @Nullable JsonElement second) {
            double d;
            double firstValue;
            if (first instanceof JsonPrimitive) {
                JsonPrimitive fp = (JsonPrimitive)first;
                v0 = fp.getAsDouble();
            } else {
                v0 = firstValue = 0.0;
            }
            if (second instanceof JsonPrimitive) {
                JsonPrimitive sp = (JsonPrimitive)second;
                d = sp.getAsDouble();
            } else {
                d = 0.0;
            }
            double secondValue = d;
            return Double.compare(firstValue, secondValue);
        }

        @Override
        public String getName() {
            return NAME;
        }
    }
}

