/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.allurement.core.mixin;

import com.teamabnormals.allurement.core.AllurementConfig;
import com.teamabnormals.allurement.core.other.AllurementUtil;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public abstract class PlayerMixin
extends LivingEntity {
    @Shadow
    public int f_36078_;
    @Shadow
    public float f_36080_;

    protected PlayerMixin(EntityType<? extends LivingEntity> type, Level level) {
        super(type, level);
    }

    @Inject(at={@At(value="RETURN")}, method={"getXpNeededForNextLevel"}, cancellable=true)
    private void xpBarCap(CallbackInfoReturnable<Integer> cir) {
        if (((Boolean)AllurementConfig.COMMON.removeLevelScaling.get()).booleanValue()) {
            int xpPerLevel = (Integer)AllurementConfig.COMMON.experiencePerLevel.get();
            if (((Boolean)AllurementConfig.COMMON.removeLevelScalingAfterCap.get()).booleanValue()) {
                cir.setReturnValue((Object)Math.min((Integer)cir.getReturnValue(), xpPerLevel));
            } else {
                cir.setReturnValue((Object)xpPerLevel);
            }
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"getExperienceReward"}, cancellable=true)
    private void getExperienceReward(CallbackInfoReturnable<Integer> cir) {
        if (((Boolean)AllurementConfig.COMMON.dropExperiencePercentage.get()).booleanValue() && !this.m_9236_().m_46469_().m_46207_(GameRules.f_46133_) && !this.m_5833_()) {
            float totalXp = this.f_36080_ * (float)AllurementUtil.getXpNeededForNextLevel(this.f_36078_);
            for (int i = 0; i < this.f_36078_; ++i) {
                totalXp += (float)AllurementUtil.getXpNeededForNextLevel(i);
            }
            totalXp = (float)((double)totalXp * (Double)AllurementConfig.COMMON.experiencePercentage.get());
            int base = Mth.m_14143_((float)totalXp);
            float bonus = Mth.m_14187_((float)totalXp);
            if (bonus != 0.0f && Math.random() < (double)bonus) {
                ++base;
            }
            cir.setReturnValue((Object)base);
        }
    }
}

