/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.item;

import com.github.alexmodguy.alexscaves.server.entity.util.DeepOneReaction;
import com.github.alexmodguy.alexscaves.server.item.ACItemRegistry;
import com.github.alexmodguy.alexscaves.server.level.storage.ACWorldData;
import java.awt.Color;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class GazingPearlItem
extends Item {
    public GazingPearlItem() {
        super(new Item.Properties().m_41487_(1).m_41497_(Rarity.UNCOMMON));
    }

    public static int getPearlColor(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128471_("HasReputation")) {
            float shine = (float)(Math.sin((float)System.currentTimeMillis() / 4000.0f) + 1.0) * 0.5f;
            int reputation = tag.m_128451_("Reputation");
            int color = 100 - reputation;
            int rainbow = Color.HSBtoRGB((float)color / 200.0f, shine * 0.3f + 0.7f, 1.0f);
            return rainbow;
        }
        float hue = (float)(System.currentTimeMillis() % 10000L) / 10000.0f;
        float shine = (float)(Math.sin((float)System.currentTimeMillis() / 4000.0f) + 1.0) * 0.5f;
        int rainbow = Color.HSBtoRGB(hue, shine * 0.3f + 0.7f, 1.0f);
        return rainbow;
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128471_("HasReputation")) {
            int reputation = tag.m_128451_("Reputation");
            DeepOneReaction reaction = DeepOneReaction.fromReputation(reputation);
            String key = "item.alexscaves.gazing_pearl.desc_" + reaction.name().toLowerCase(Locale.ROOT);
            tooltip.add((Component)Component.m_237115_((String)key).m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC));
        }
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int i, boolean held) {
        ACWorldData acWorldData;
        CompoundTag tag;
        long lastReputationTimestamp;
        super.m_6883_(stack, level, entity, i, held);
        if (!(level.f_46443_ || (lastReputationTimestamp = (tag = stack.m_41784_()).m_128454_("LastReputationTimestamp")) > 0L && level.m_46467_() - lastReputationTimestamp <= 100L || (acWorldData = ACWorldData.get(level)) == null)) {
            tag.m_128356_("LastReputationTimestamp", level.m_46467_());
            tag.m_128379_("HasReputation", true);
            tag.m_128405_("Reputation", acWorldData.getDeepOneReputation(entity.m_20148_()));
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !oldStack.m_150930_((Item)ACItemRegistry.GAZING_PEARL.get()) || !newStack.m_150930_((Item)ACItemRegistry.GAZING_PEARL.get());
    }
}

