/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.integration;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.TippedArrowItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.zeta.Zeta;
import org.violetmoon.zeta.config.ZetaGeneralConfig;
import org.violetmoon.zeta.event.load.ZGatherHints;
import org.violetmoon.zeta.integration.JeiGatherHints;
import org.violetmoon.zeta.mod.ZetaMod;
import org.violetmoon.zeta.util.RegistryUtil;
import org.violetmoon.zeta.util.zetalist.ZetaList;

@JeiPlugin
public class ZetaJeiPlugin
implements IModPlugin {
    private static final ResourceLocation UID = new ResourceLocation("zeta", "zeta");

    @NotNull
    public ResourceLocation getPluginUid() {
        return UID;
    }

    public void onRuntimeAvailable(@NotNull IJeiRuntime jeiRuntime) {
        ZetaMod.ZETA.configManager.addOnReloadListener("jei_plugin", configInternals -> ZetaJeiPlugin.removeDisabledIngredients(jeiRuntime, ZetaList.INSTANCE.getZetas()));
        ZetaList.INSTANCE.getZetas().forEach(z -> z.configManager.addOnReloadListener("jei_plugin", configInternals -> ZetaJeiPlugin.removeDisabledIngredients(jeiRuntime, List.of(z))));
    }

    private static void removeDisabledIngredients(@NotNull IJeiRuntime jeiRuntime, Iterable<Zeta> zetas) {
        for (Zeta z : zetas) {
            if (!ZetaGeneralConfig.hideDisabledContent) {
                return;
            }
            HashSet hidePotions = Sets.newHashSet();
            NonNullList stacksToHide = NonNullList.m_122779_();
            for (Holder h : z.registry.getRegisteredObjects(Registries.f_256973_)) {
                if (ZetaMod.ZETA.brewingRegistry.isEnabled((Potion)h.get())) continue;
                hidePotions.add((Potion)h.get());
            }
            if (!hidePotions.isEmpty()) {
                for (Item item : BuiltInRegistries.f_257033_) {
                    if (!(item instanceof PotionItem) && !(item instanceof TippedArrowItem)) continue;
                    NonNullList potionStacks = NonNullList.m_122779_();
                    potionStacks.stream().filter(it -> hidePotions.contains(PotionUtils.m_43579_((ItemStack)it))).forEach(arg_0 -> stacksToHide.add(arg_0));
                }
            }
            if (stacksToHide.isEmpty()) continue;
            Minecraft.m_91087_().m_18689_(() -> jeiRuntime.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, (Collection)stacksToHide));
        }
    }

    public void registerRecipes(@NotNull IRecipeRegistration registration) {
        if (!ZetaGeneralConfig.enableJeiItemInfo) {
            return;
        }
        RegistryAccess registryAccess = Minecraft.m_91087_().f_91073_.m_9598_();
        List<Item> blacklist = RegistryUtil.massRegistryGet(ZetaGeneralConfig.suppressedInfo, BuiltInRegistries.f_257033_);
        for (Zeta z : ZetaList.INSTANCE.getZetas()) {
            z.loadBus.fire(new JeiGatherHints(registration, z.modid, registryAccess, blacklist), ZGatherHints.class);
        }
    }
}

