/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.zoom;

import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraft.util.Mth;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModFileInfo;

public enum WiZoom {
    INSTANCE;

    public static final String MODID = "wi_zoom";
    public static final Minecraft MC;
    private static final Lazy<KeyMapping> ZOOM_KEY;
    private final double defaultLevel = 3.0;
    private Double currentLevel;
    private Double defaultMouseSensitivity;

    public void initialize() {
        IModFileInfo modInfo = ModList.get().getModFileById(MODID);
        String version = modInfo.versionString();
        System.out.println("Starting WI Zoom v" + version);
    }

    public double changeFovBasedOnZoom(double fov) {
        OptionInstance mouseSensitivitySetting = WiZoom.MC.f_91066_.m_231964_();
        if (this.currentLevel == null) {
            this.currentLevel = 3.0;
        }
        if (!this.getZoomKey().m_90857_()) {
            this.currentLevel = 3.0;
            if (this.defaultMouseSensitivity != null) {
                mouseSensitivitySetting.m_231514_((Object)this.defaultMouseSensitivity);
                this.defaultMouseSensitivity = null;
            }
            return fov;
        }
        if (this.defaultMouseSensitivity == null) {
            this.defaultMouseSensitivity = (Double)mouseSensitivitySetting.m_231551_();
        }
        mouseSensitivitySetting.m_231514_((Object)(this.defaultMouseSensitivity * (1.0 / this.currentLevel)));
        return fov / this.currentLevel;
    }

    public void onMouseScroll(double amount) {
        if (!this.getZoomKey().m_90857_()) {
            return;
        }
        if (this.currentLevel == null) {
            this.currentLevel = 3.0;
        }
        if (amount > 0.0) {
            this.currentLevel = this.currentLevel * 1.1;
        } else if (amount < 0.0) {
            this.currentLevel = this.currentLevel * 0.9;
        }
        this.currentLevel = Mth.m_14008_((double)this.currentLevel, (double)1.0, (double)50.0);
    }

    public KeyMapping getZoomKey() {
        return (KeyMapping)ZOOM_KEY.get();
    }

    static {
        MC = Minecraft.m_91087_();
        ZOOM_KEY = Lazy.of(() -> new KeyMapping("key.wi_zoom.zoom", InputConstants.Type.KEYSYM, 86, "WI Zoom"));
    }
}

