/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.world.module;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.material.MapColor;
import org.apache.commons.lang3.tuple.Pair;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.base.util.CorundumColor;
import org.violetmoon.quark.content.tools.module.BeaconRedirectionModule;
import org.violetmoon.quark.content.world.block.CorundumBlock;
import org.violetmoon.quark.content.world.block.CorundumClusterBlock;
import org.violetmoon.quark.content.world.undergroundstyle.CorundumStyle;
import org.violetmoon.quark.content.world.undergroundstyle.base.UndergroundStyleConfig;
import org.violetmoon.quark.content.world.undergroundstyle.base.UndergroundStyleGenerator;
import org.violetmoon.zeta.api.IIndirectConnector;
import org.violetmoon.zeta.block.IZetaBlock;
import org.violetmoon.zeta.block.ZetaInheritedPaneBlock;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.load.ZCommonSetup;
import org.violetmoon.zeta.event.load.ZConfigChanged;
import org.violetmoon.zeta.event.load.ZGatherHints;
import org.violetmoon.zeta.event.load.ZRegister;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.util.Hint;
import org.violetmoon.zeta.util.handler.ToolInteractionHandler;
import org.violetmoon.zeta.world.WorldGenHandler;
import org.violetmoon.zeta.world.generator.Generator;

@ZetaLoadModule(category="world")
public class CorundumModule
extends ZetaModule {
    @Config
    public UndergroundStyleConfig generationSettings = ((UndergroundStyleConfig.Builder)((UndergroundStyleConfig.Builder)((UndergroundStyleConfig.Builder)((UndergroundStyleConfig.Builder)((UndergroundStyleConfig.Builder)((UndergroundStyleConfig.Builder)UndergroundStyleConfig.styleBuilder().style(new CorundumStyle()).biomeDeny(new TagKey[]{BiomeTags.f_207603_})).rarity(400)).horizontalSize(36)).verticalSize(14)).horizontalVariation(8)).verticalVariation(6)).build();
    @Config
    @Config.Min(value=0.0)
    @Config.Max(value=1.0)
    public static double crystalChance = 0.16;
    @Config
    @Config.Min(value=0.0)
    @Config.Max(value=1.0)
    public static double crystalClusterChance = 0.2;
    @Config
    @Config.Min(value=0.0)
    @Config.Max(value=1.0)
    public static double crystalClusterOnSidesChance = 0.6;
    @Config
    @Config.Min(value=0.0)
    @Config.Max(value=1.0)
    public static double doubleCrystalChance = 0.2;
    @Config(description="The chance that a crystal can grow, this is on average 1 in X world ticks, set to a higher value to make them grow slower. Minimum is 1, for every tick. Set to 0 to disable growth.")
    public static int caveCrystalGrowthChance = 5;
    @Config(flag="cave_corundum_runes")
    public static boolean crystalsCraftRunes = true;
    @Config
    public static boolean enableCollateralMovement = true;
    public static boolean staticEnabled;
    public static List<CorundumBlock> crystals;
    public static List<CorundumClusterBlock> clusters;
    @Hint
    public static final TagKey<Block> corundumTag;

    @LoadEvent
    public final void register(ZRegister event) {
        for (CorundumColor color : CorundumColor.values()) {
            this.add(color.name, color.beaconColor, color.mapColor);
        }
    }

    @LoadEvent
    public final void configChanged(ZConfigChanged event) {
        staticEnabled = this.enabled;
    }

    @LoadEvent
    public final void setup(ZCommonSetup event) {
        WorldGenHandler.addGenerator((ZetaModule)this, (Generator)new UndergroundStyleGenerator(this.generationSettings, "corundum"), (GenerationStep.Decoration)GenerationStep.Decoration.UNDERGROUND_DECORATION, (int)1);
    }

    @LoadEvent
    public void addAdditionalHints(ZGatherHints event) {
        MutableComponent comp = Component.m_237115_((String)"quark.jei.hint.corundum_cluster_grow");
        if (Quark.ZETA.modules.isEnabled(BeaconRedirectionModule.class)) {
            comp = comp.m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"quark.jei.hint.corundum_cluster_redirect"));
        }
        for (Block block : clusters) {
            event.accept((ItemLike)block.m_5456_(), (Component)comp);
        }
    }

    private void add(String name, int color, MapColor mapColor) {
        CorundumBlock crystal = new CorundumBlock(name + "_corundum", color, this, mapColor, false);
        crystals.add(crystal);
        CorundumBlock waxed = new CorundumBlock("waxed_" + name + "_corundum", color, this, mapColor, true);
        ToolInteractionHandler.registerWaxedBlock((ZetaModule)this, (Block)crystal, (Block)waxed);
        new ZetaInheritedPaneBlock((IZetaBlock)crystal).setCreativeTab(CreativeModeTabs.f_256725_);
        CorundumClusterBlock cluster = new CorundumClusterBlock(crystal);
        clusters.add(cluster);
        ClusterConnection connection = new ClusterConnection(cluster);
        IIndirectConnector.INDIRECT_STICKY_BLOCKS.add(Pair.of(connection::isValidState, (Object)connection));
    }

    static {
        crystals = Lists.newArrayList();
        clusters = Lists.newArrayList();
        corundumTag = BlockTags.create((ResourceLocation)new ResourceLocation("quark", "corundum"));
    }

    public record ClusterConnection(CorundumClusterBlock cluster) implements IIndirectConnector
    {
        public boolean isEnabled() {
            return enableCollateralMovement;
        }

        private boolean isValidState(BlockState state) {
            return state.m_60734_() == this.cluster;
        }

        public boolean canConnectIndirectly(Level world, BlockPos ourPos, BlockPos sourcePos, BlockState ourState, BlockState sourceState) {
            BlockPos offsetPos = ourPos.m_121945_(((Direction)ourState.m_61143_(CorundumClusterBlock.FACING)).m_122424_());
            if (!offsetPos.equals((Object)sourcePos)) {
                return false;
            }
            return sourceState.m_60734_() == this.cluster.base;
        }
    }
}

