/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.addons.oddities.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.addons.oddities.block.be.TinyPotatoBlockEntity;
import org.violetmoon.quark.addons.oddities.item.TinyPotatoBlockItem;
import org.violetmoon.quark.addons.oddities.module.TinyPotatoModule;
import org.violetmoon.zeta.block.OldMaterials;
import org.violetmoon.zeta.block.ZetaBlock;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.registry.IZetaBlockItemProvider;
import org.violetmoon.zeta.util.ItemNBTHelper;

public class TinyPotatoBlock
extends ZetaBlock
implements SimpleWaterloggedBlock,
EntityBlock,
IZetaBlockItemProvider {
    public static final DirectionProperty HORIZONTAL_FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape SHAPE = TinyPotatoBlock.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0);
    public static final String ANGRY = "angery";

    public static boolean isAngry(ItemStack stack) {
        return ItemNBTHelper.getBoolean((ItemStack)stack, (String)ANGRY, (boolean)false);
    }

    public TinyPotatoBlock(@Nullable ZetaModule module) {
        super("tiny_potato", module, OldMaterials.wool().m_60978_(0.25f));
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.SOUTH));
        if (module == null) {
            return;
        }
        this.setCreativeTab(CreativeModeTabs.f_256791_);
    }

    public boolean m_7278_(@NotNull BlockState state) {
        return true;
    }

    public int m_6782_(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos) {
        return AbstractContainerMenu.m_38918_((BlockEntity)world.m_7702_(pos));
    }

    protected void m_7926_(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{HORIZONTAL_FACING, WATERLOGGED});
    }

    @NotNull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public void m_6810_(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity be = world.m_7702_(pos);
            if (be instanceof TinyPotatoBlockEntity) {
                TinyPotatoBlockEntity inventory = (TinyPotatoBlockEntity)be;
                Containers.m_19002_((Level)world, (BlockPos)pos, (Container)inventory);
            }
            super.m_6810_(state, world, pos, newState, isMoving);
        }
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        ItemStack stack = super.m_7397_(level, pos, state);
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof TinyPotatoBlockEntity) {
            TinyPotatoBlockEntity tater = (TinyPotatoBlockEntity)be;
            if (tater.m_8077_()) {
                stack.m_41714_(tater.m_7770_());
            }
            if (tater.angry) {
                ItemNBTHelper.setBoolean((ItemStack)stack, (String)ANGRY, (boolean)true);
            }
        }
        return stack;
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext ctx) {
        return SHAPE;
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, Level world, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        BlockEntity be = world.m_7702_(pos);
        if (be instanceof TinyPotatoBlockEntity) {
            TinyPotatoBlockEntity tater = (TinyPotatoBlockEntity)be;
            tater.interact(player, hand, player.m_21120_(hand), hit.m_82434_());
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                TinyPotatoModule.patPotatoTrigger.trigger(sp);
            }
            if (world instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)world;
                AABB box = SHAPE.m_83215_();
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123750_, (double)pos.m_123341_() + box.f_82288_ + Math.random() * (box.f_82291_ - box.f_82288_), (double)pos.m_123342_() + box.f_82292_, (double)pos.m_123343_() + box.f_82290_ + Math.random() * (box.f_82293_ - box.f_82290_), 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
        return InteractionResult.m_19078_((boolean)world.f_46443_);
    }

    @NotNull
    public BlockState m_5573_(@NotNull BlockPlaceContext ctx) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)HORIZONTAL_FACING, (Comparable)ctx.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ctx.m_43725_().m_6425_(ctx.m_8083_()).m_76152_() == Fluids.f_76193_));
    }

    @NotNull
    public BlockState m_7417_(BlockState state, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, facing, facingState, level, pos, facingPos);
    }

    public void m_6402_(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity living, ItemStack stack) {
        BlockEntity be;
        boolean hasCustomName = stack.m_41788_();
        boolean isAngry = TinyPotatoBlock.isAngry(stack);
        if ((hasCustomName || isAngry) && (be = world.m_7702_(pos)) instanceof TinyPotatoBlockEntity) {
            TinyPotatoBlockEntity tater = (TinyPotatoBlockEntity)be;
            if (hasCustomName) {
                tater.name = stack.m_41786_();
            }
            tater.angry = TinyPotatoBlock.isAngry(stack);
        }
    }

    public boolean m_8133_(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, int id, int param) {
        super.m_8133_(state, world, pos, id, param);
        BlockEntity tile = world.m_7702_(pos);
        return tile != null && tile.m_7531_(id, param);
    }

    public BlockItem provideItemBlock(Block block, Item.Properties properties) {
        return new TinyPotatoBlockItem(block, properties);
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @NotNull
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new TinyPotatoBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        return TinyPotatoBlock.createTickerHelper(type, TinyPotatoModule.blockEntityType, TinyPotatoBlockEntity::commonTick);
    }
}

