/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.world;

import com.google.common.collect.ImmutableMap;
import eu.ha3.presencefootsteps.PresenceFootsteps;
import eu.ha3.presencefootsteps.world.Emitter;
import eu.ha3.presencefootsteps.world.Lookup;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSets;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public record StateLookup(Map<String, Bucket> substrates) implements Lookup<BlockState>
{
    public StateLookup() {
        this((Map<String, Bucket>)new Object2ObjectLinkedOpenHashMap());
    }

    @Override
    public String getAssociation(BlockState state, String substrate) {
        return this.substrates.getOrDefault((Object)substrate, (Bucket)Bucket.EMPTY).get((BlockState)state).value;
    }

    @Override
    public void add(String key, String value) {
        if (!Emitter.isResult(value)) {
            PresenceFootsteps.logger.info("Skipping non-result value " + key + "=" + value);
            return;
        }
        Key k = Key.of(key, value);
        this.substrates.computeIfAbsent(k.substrate, Bucket.Substrate::new).add(k);
    }

    @Override
    public Set<String> getSubstrates() {
        return this.substrates.keySet();
    }

    @Override
    public boolean contains(BlockState state) {
        for (Bucket substrate : this.substrates.values()) {
            if (!substrate.contains(state)) continue;
            return true;
        }
        return false;
    }

    private static interface Bucket {
        public static final Bucket EMPTY = state -> Key.NULL;

        default public void add(Key key) {
        }

        public Key get(BlockState var1);

        default public boolean contains(BlockState state) {
            return false;
        }

        public record Tile(Map<BlockState, Key> cache, KeyList keys) implements Bucket
        {
            Tile(ResourceLocation id) {
                this((Map<BlockState, Key>)new Object2ObjectLinkedOpenHashMap(), new KeyList());
            }

            @Override
            public void add(Key key) {
                this.keys.add(key);
            }

            @Override
            public Key get(BlockState state) {
                return this.cache.computeIfAbsent(state, this.keys::findMatch);
            }

            @Override
            public boolean contains(BlockState state) {
                return this.get(state) != Key.NULL;
            }
        }

        public record Substrate(KeyList wildcards, Map<ResourceLocation, Bucket> blocks, Map<ResourceLocation, Bucket> tags) implements Bucket
        {
            Substrate(String substrate) {
                this(new KeyList(), (Map<ResourceLocation, Bucket>)new Object2ObjectLinkedOpenHashMap(), (Map<ResourceLocation, Bucket>)new Object2ObjectLinkedOpenHashMap());
            }

            @Override
            public void add(Key key) {
                if (key.isWildcard()) {
                    this.wildcards.add(key);
                } else {
                    (key.isTag() ? this.tags : this.blocks).computeIfAbsent(key.identifier(), Tile::new).add(key);
                }
            }

            @Override
            public Key get(BlockState state) {
                Key association = this.getTile(state).get(state);
                return association == Key.NULL ? this.wildcards.findMatch(state) : association;
            }

            @Override
            public boolean contains(BlockState state) {
                return this.getTile(state).contains(state) || this.wildcards.findMatch(state) != Key.NULL;
            }

            private Bucket getTile(BlockState state) {
                return this.blocks.computeIfAbsent(BuiltInRegistries.f_256975_.m_7981_((Object)state.m_60734_()), id -> {
                    for (ResourceLocation tag : this.tags.keySet()) {
                        if (!state.m_204336_(TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)tag))) continue;
                        return this.tags.get(tag);
                    }
                    return EMPTY;
                });
            }
        }
    }

    private record Key(ResourceLocation identifier, String substrate, Set<Attribute> properties, String value, boolean empty, boolean isTag, boolean isWildcard) {
        public static final Key NULL = new Key(new ResourceLocation("air"), "", (Set<Attribute>)ObjectSets.emptySet(), "UNASSIGNED", true, false, false);

        public static Key of(String key, String value) {
            String id;
            boolean isTag;
            boolean bl = isTag = key.indexOf(35) == 0;
            if (isTag) {
                key = key.replaceFirst("#", "");
            }
            boolean isWildcard = (id = key.split("[\\.\\[]")[0]).indexOf(42) == 0;
            ResourceLocation identifier = new ResourceLocation("air");
            if (!isWildcard) {
                if (id.indexOf(94) > -1) {
                    identifier = new ResourceLocation(id.split("\\^")[0]);
                    PresenceFootsteps.logger.warn("Metadata entry for " + key + "=" + value + " was ignored");
                } else {
                    identifier = new ResourceLocation(id);
                }
                if (!isTag && !BuiltInRegistries.f_256975_.m_7804_(identifier)) {
                    PresenceFootsteps.logger.warn("Sound registered for unknown block id " + identifier);
                }
            }
            key = key.replace(id, "");
            String substrate = key.replaceFirst("\\[[^\\]]+\\]", "");
            String finalSubstrate = "";
            if (substrate.indexOf(46) > -1) {
                finalSubstrate = substrate.split("\\.")[1];
                key = key.replace(substrate, "");
            }
            Set properties = (Set)ObjectArrayList.of((Object[])key.replace("[", "").replace("]", "").split(",")).stream().filter(line -> line.indexOf(61) > -1).map(Attribute::new).collect(ObjectOpenHashSet.toSet());
            boolean empty = properties.isEmpty();
            return new Key(identifier, finalSubstrate, properties, value, empty, isTag, isWildcard);
        }

        boolean matches(BlockState state) {
            if (this.empty) {
                return true;
            }
            ImmutableMap entries = state.m_61148_();
            Set keys = entries.keySet();
            for (Attribute property : this.properties) {
                for (Property key : keys) {
                    Comparable value;
                    if (!key.m_61708_().equals(property.name) || Objects.toString(value = (Comparable)entries.get(key)).equalsIgnoreCase(property.value)) continue;
                    return false;
                }
            }
            return true;
        }

        @Override
        public String toString() {
            return (this.isTag ? "#" : "") + this.identifier + "[" + this.properties.stream().map(Attribute::toString).collect(Collectors.joining()) + "]." + this.substrate + "=" + this.value;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.empty, this.identifier, this.isTag, this.isWildcard, this.properties, this.substrate);
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj || obj != null && this.getClass() == obj.getClass() && this.equals((Key)obj);
        }

        private boolean equals(Key other) {
            return this.isTag == other.isTag && this.isWildcard == other.isWildcard && this.empty == other.empty && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.substrate, other.substrate) && Objects.equals(this.properties, other.properties);
        }

        private record Attribute(String name, String value) {
            Attribute(String prop) {
                this(prop.split("="));
            }

            Attribute(String[] split) {
                this(split[0], split[1]);
            }

            @Override
            public String toString() {
                return this.name + "=" + this.value;
            }
        }
    }

    private record KeyList(Set<Key> priorityKeys, Set<Key> keys) {
        public KeyList() {
            this((Set<Key>)new ObjectLinkedOpenHashSet(), (Set<Key>)new ObjectLinkedOpenHashSet());
        }

        void add(Key key) {
            Set<Key> keys = this.getSetFor(key);
            keys.remove(key);
            keys.add(key);
        }

        private Set<Key> getSetFor(Key key) {
            return key.empty() ? this.keys : this.priorityKeys;
        }

        public Key findMatch(BlockState state) {
            for (Key i : this.priorityKeys) {
                if (!i.matches(state)) continue;
                return i;
            }
            for (Key i : this.keys) {
                if (!i.matches(state)) continue;
                return i;
            }
            return Key.NULL;
        }
    }
}

