/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.sound.generator;

import eu.ha3.presencefootsteps.sound.Options;
import eu.ha3.presencefootsteps.sound.State;
import eu.ha3.presencefootsteps.sound.generator.Modifier;
import eu.ha3.presencefootsteps.sound.generator.TerrestrialStepSoundGenerator;
import eu.ha3.presencefootsteps.util.MathUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

class WingedStepSoundGenerator
extends TerrestrialStepSoundGenerator {
    protected boolean isFalling = false;
    protected FlightState state = FlightState.IDLE;
    protected int flapMod = 0;
    private long lastTimeImmobile;
    protected long nextFlapTime;

    public WingedStepSoundGenerator(Modifier<TerrestrialStepSoundGenerator> modifier) {
        super(modifier);
    }

    @Override
    public boolean generateFootsteps(LivingEntity ply) {
        this.lastTimeImmobile = this.timeImmobile;
        return super.generateFootsteps(ply);
    }

    @Override
    protected void simulateAirborne(LivingEntity ply) {
        this.isFalling = this.motionTracker.getMotionY() < -0.3;
        super.simulateAirborne(ply);
        if (this.isAirborne) {
            this.simulateFlying(ply);
        }
    }

    @Override
    protected boolean updateImmobileState(LivingEntity ply, float reference) {
        if (this.isAirborne) {
            Vec3 vel = ply.m_20184_();
            boolean stationary = vel.f_82479_ != 0.0 && vel.f_82481_ != 0.0;
            this.lastReference = reference;
            if (!this.isImmobile && stationary) {
                this.timeImmobile = System.currentTimeMillis();
                this.isImmobile = true;
            } else if (this.isImmobile && !stationary) {
                this.isImmobile = false;
                return System.currentTimeMillis() - this.timeImmobile > (long)this.variator.IMMOBILE_DURATION;
            }
            return false;
        }
        return super.updateImmobileState(ply, reference);
    }

    protected int getWingSpeed() {
        return switch (this.state) {
            case FlightState.COASTING -> {
                if (this.flapMod == 0) {
                    yield this.variator.WING_SPEED_COAST;
                }
                yield this.variator.WING_SPEED_NORMAL * this.flapMod;
            }
            case FlightState.COASTING_STRAFING -> this.variator.WING_SPEED_NORMAL * (1 + this.flapMod);
            case FlightState.DASHING -> this.variator.WING_SPEED_RAPID;
            case FlightState.ASCENDING, FlightState.FLYING -> this.variator.WING_SPEED_NORMAL;
            default -> this.variator.WING_SPEED_IDLE;
        };
    }

    @Override
    protected void simulateJumpingLanding(LivingEntity ply) {
        boolean speedingJumpStateChange;
        if (this.hasStoppingConditions((Entity)ply)) {
            return;
        }
        long now = System.currentTimeMillis();
        float speed = (float)Math.sqrt(this.motionTracker.getHorizontalSpeed());
        if (this.isAirborne) {
            this.nextFlapTime = now + (long)this.variator.WING_JUMPING_REST_TIME;
        }
        boolean hugeLanding = !this.isAirborne && ply.f_19789_ > this.variator.HUGEFALL_LANDING_DISTANCE_MIN;
        boolean bl = speedingJumpStateChange = speed > this.variator.MIN_MOTION_HOR;
        if (hugeLanding || speedingJumpStateChange) {
            if (!this.isAirborne) {
                float volume = speedingJumpStateChange ? 2.0f : MathUtil.scalex(ply.f_19789_, this.variator.HUGEFALL_LANDING_DISTANCE_MIN, this.variator.HUGEFALL_LANDING_DISTANCE_MAX);
                this.acoustics.playAcoustic(ply, "_SWIFT", State.LAND, Options.singular("gliding_volume", volume));
            } else {
                this.acoustics.playAcoustic(ply, "_SWIFT", State.JUMP, Options.EMPTY);
            }
        }
        if (this.isAirborne && this.isJumping(ply)) {
            this.simulateJumping(ply);
        } else if (!this.isAirborne && hugeLanding) {
            this.simulateLanding(ply);
        }
    }

    protected void simulateFlying(LivingEntity ply) {
        long now = System.currentTimeMillis();
        if (this.updateState(this.motionTracker.getHorizontalSpeed(), this.motionTracker.getMotionY(), ply.f_20900_)) {
            this.nextFlapTime = now + (long)this.variator.FLIGHT_TRANSITION_TIME;
        }
        if (!ply.m_5842_() && !this.isFalling && now > this.nextFlapTime) {
            this.nextFlapTime = now + (long)this.getWingSpeed() + (long)(ply.m_9236_().f_46441_.m_188503_(100) - 50);
            this.flapMod = (this.flapMod + 1) % (1 + ply.m_9236_().f_46441_.m_188503_(4));
            float volume = 1.0f;
            long diffImmobile = now - this.lastTimeImmobile;
            if (diffImmobile > (long)this.variator.WING_IMMOBILE_FADE_START) {
                volume -= MathUtil.scalex(diffImmobile, this.variator.WING_IMMOBILE_FADE_START, this.variator.WING_IMMOBILE_FADE_START + this.variator.WING_IMMOBILE_FADE_DURATION);
            }
            this.acoustics.playAcoustic(ply, "_WING", State.WALK, Options.singular("gliding_volume", volume));
        }
    }

    protected boolean updateState(double horSpeed, double verticalSpeed, double strafe) {
        float motionHor = (float)Math.sqrt(horSpeed);
        FlightState result = FlightState.IDLE;
        if (motionHor > this.variator.MIN_DASH_MOTION) {
            result = FlightState.DASHING;
        } else if (motionHor > this.variator.MIN_COAST_MOTION && (float)Math.abs(verticalSpeed) < this.variator.MIN_COAST_MOTION / 20.0f) {
            result = strafe > (double)this.variator.MIN_MOTION_Y ? FlightState.COASTING_STRAFING : FlightState.COASTING;
        } else if (motionHor > this.variator.MIN_MOTION_HOR) {
            result = FlightState.FLYING;
        } else if (verticalSpeed < 0.0) {
            result = FlightState.DESCENDING;
        } else if ((float)verticalSpeed > this.variator.MIN_MOTION_Y) {
            result = FlightState.ASCENDING;
        }
        boolean changed = result != this.state;
        this.state = result;
        return changed;
    }

    private static enum FlightState {
        DASHING,
        COASTING,
        COASTING_STRAFING,
        FLYING,
        IDLE,
        ASCENDING,
        DESCENDING;

    }
}

